/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features;

import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.SfsFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;

public class SfsCsdrFeatureRestService
extends SfsFeatureRestService {
    private static final Log LOGGER = LogFactory.getInstance(SfsCsdrFeatureRestService.class);

    @Override
    public Response createServiceInstanceQuotasBudget(String projectId, CreateInstanceRequest request) throws RestException {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(request == null ? "" : request.getInstance().getName()));
        Response response = super.validateCreateCsdrRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            LOGGER.error((Object)"createServiceInstanceQuotasBudget failed, status code: %s", (long)response.getStatus());
            return response;
        }
        String replicationType = request.getInstance().getReplicationType();
        PolicyBO policy = request.getInstance().getPolicy();
        if (ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType) && !this.validatePolicy(policy)) {
            LOGGER.error((Object)"policy check failed in createServiceInstanceQuotasBudget.");
            this.recordResponseLog(Response.Status.BAD_REQUEST.getStatusCode(), "Not set policy.");
            return this.getResponse(Response.Status.BAD_REQUEST, "Not set policy.");
        }
        String type = request.getInstance().getType();
        try {
            ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().checkCreateInstanceParamAndCalQuota(pg, projectId, extendParam);
            JSONObject returnJson = new JSONObject();
            String regionId = (String)pg.getProps().get("regionId");
            String protId = (String)pg.getProps().get("projectId");
            String drRegionId = (String)pg.getProps().get("drRegionId");
            String drProId = (String)pg.getProps().get("drProjectId");
            JSONArray array = this.constructQuotaResult(type, protId, regionId, drProId, drRegionId, list);
            returnJson.put((Object)"quotas", (Object)array);
            LOGGER.debug((Object)"createServiceInstanceQuotasBudget: %s", new Object[]{array});
            this.recordResponseLog(Response.Status.OK.getStatusCode(), "request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    protected JSONObject getCreateInstanceJsonObject(String projectId, BcsCreateInstanceRequest request, String reqId, JSONObject evsQuota) {
        ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
        ExtendParamInfo extendParam = new ExtendParamInfo();
        extendParam.setSubscriptionId(request.getSubscriptionId());
        extendParam.setEvsQuota(evsQuota);
        String taskId = this.getSfsInstanceService().createServiceInstance(pg, extendParam);
        JSONObject json = new JSONObject();
        json.put((Object)"task_id", (Object)taskId);
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request.task_id is " + taskId + ".");
        return json;
    }

    @Override
    protected ProtectGroup convertInstanceBOToPg(CreateInstanceRequest request, String projectId) {
        ProtectGroup pg = new ProtectGroup();
        ServiceInstanceBO instance = request.getInstance();
        pg.setName(instance.getName());
        pg.setDescription(instance.getDescription());
        pg.setProperty("regionId", (Object)instance.getRegionName());
        pg.setProperty("projectId", (Object)projectId);
        pg.setProperty("zoneName", (Object)instance.getAzName());
        pg.setProperty("originalAvailableZone", (Object)instance.getAzName());
        if (!VerifyUtil.isEmpty((String)instance.getSlaveRegionName())) {
            pg.setProperty("drRegionId", (Object)instance.getSlaveRegionName());
        }
        if (!VerifyUtil.isEmpty((String)instance.getRemoteProjectId())) {
            pg.setProperty("drProjectId", (Object)instance.getRemoteProjectId());
        }
        if (!VerifyUtil.isEmpty((String)instance.getSlaveAzName())) {
            pg.setProperty("drZoneName", (Object)instance.getSlaveAzName());
        }
        pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
        pg.setPoType(17);
        pg.setObjectType(ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
        this.initPgPolicyTemplate(pg, instance);
        this.initPgPoList(pg, instance);
        this.initPgOwnerId(pg);
        return pg;
    }

    private void initPgOwnerId(ProtectGroup pg) {
        User user;
        Object object = ServiceContext.getInstance().lookup("user/usermgr");
        if (object instanceof IUserMgr) {
            IUserMgr userMgr = (IUserMgr)object;
            user = userMgr.getUserByName("admin");
            if (user == null) {
                LOGGER.error((Object)"get admin user failed.");
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            LOGGER.error((Object)"get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        pg.setOwnerId(user.getUserId());
    }

    private void initPgPoList(ProtectGroup pg, ServiceInstanceBO instance) {
        HashSet<ProtectObject> poList = new HashSet<ProtectObject>();
        if (VerifyUtil.isEmpty((Collection)instance.getShares())) {
            LOGGER.error((Object)"Instance share is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (Share share : instance.getShares()) {
            ProtectObject po = this.convertShareBOToPo(share);
            poList.add(po);
        }
        pg.setPolist(poList);
    }

    private void initPgPolicyTemplate(ProtectGroup pg, ServiceInstanceBO instance) {
        PolicyTemplate template = new PolicyTemplate();
        if (ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.SYNCHRONIZE.getValue().equals(instance.getReplicationType())) {
            template.setType(38);
        } else {
            template.setType(39);
            PolicyBO policy = instance.getPolicy();
            Schedule autoSchedule = this.convertPolicyToSchedule(template, policy);
            template.getSchedules().add(autoSchedule);
        }
        pg.setTemplate(template);
    }

    protected ProtectObject convertShareBOToPo(Share share) {
        ProtectObject po = new ProtectObject();
        po.setMoUuid(share.getId());
        if (!VerifyUtil.isEmpty((Collection)share.getOsAllowAccessList())) {
            po.setProperty("os_allow_access", (Object)JSONArray.fromObject((Object)share.getOsAllowAccessList()).toString());
        }
        return po;
    }

    @Override
    public Response deleteServiceInstance(String projectId, String instanceId, String subscriptionId) throws RestException {
        String reqId = this.recordRequestLog("projectId is " + projectId + "instanceId is " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        try {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            String taskId = this.getSfsInstanceService().deleteServiceInstance(projectId, instanceId, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "Accept request. task_id is " + taskId + ".");
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"deleteServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"deleteServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public Response createServiceInstance(String projectId, BcsCreateInstanceRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (request == null ? "" : request.toString()));
        Response response = this.validateCreateCsdrRequestParam(projectId, request);
        if (Response.Status.OK.getStatusCode() != response.getStatus()) {
            return response;
        }
        String serviceInstanceName = request.getInstance().getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serviceInstanceName);
        try {
            JSONObject json = this.getCreateInstanceJsonObject(projectId, request, reqId, null);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"createServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"createServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public Response addServerQuotasBudget(String projectId, String instanceId, AddServersRequest request) {
        return Response.ok().build();
    }

    @Override
    public Response addServer(String projectId, String instanceId, BcsAddServersRequest request) {
        return Response.ok().build();
    }

    @Override
    protected JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO instanceInfoBO, List<QuotaResourcesBo> list) {
        return new JSONArray();
    }

    @Override
    protected boolean validateVolumeParam(VolumeBO volume) {
        return false;
    }

    @Override
    public Response downgradeServiceInstanceCheck(String projectId, String instanceId, String instanceType, String productId) {
        return Response.ok().build();
    }

    @Override
    public ServiceInstaceEnumDefine.ServiceInstanceTypeE getInstanceType() {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION;
    }
}

