/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features;

import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.FeatureRestService;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.AzMapBo;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRepicaAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.service.ISfsServiceInstanceService;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;

public abstract class SfsFeatureRestService
extends FeatureRestService {
    private static final Log LOGGER = LogFactory.getInstance(SfsFeatureRestService.class);

    protected ISfsServiceInstanceService getInstanceService() {
        Object service = this.call("getSfsInstanceService", new Class[0], new Object[0]);
        if (service instanceof ISfsServiceInstanceService) {
            return (ISfsServiceInstanceService)service;
        }
        throw new LegoCheckedException(0x300001L);
    }

    @Override
    public Response queryProtectableServers(String projectId, String regionId, String availableZone, String instanceType, String instanceID) throws RestException {
        String remoteAz;
        Response resultResponse = this.checkParamForProtectableServers(projectId, regionId, availableZone, instanceType);
        if (resultResponse != null) {
            return resultResponse;
        }
        String remoteRegion = this.getHttpServletRequest().getParameter("remote_region");
        Optional<Response> resultResponseOptional = this.checkRemoteInfo(remoteRegion, remoteAz = this.getHttpServletRequest().getParameter("remote_available_zone"));
        if (resultResponseOptional.isPresent()) {
            return resultResponseOptional.get();
        }
        ServiceInstaceEnumDefine.ServiceInstanceTypeE type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)instanceType);
        if (type == null) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_type is incorrect.");
        }
        AzMapBo azMap = new AzMapBo();
        azMap.setRegion(regionId);
        azMap.setAvailableZone(availableZone);
        azMap.setRemoteRegion(remoteRegion);
        azMap.setRemoteAvailableZone(remoteAz);
        List shares = this.getSfsInstanceService().queryAvailableShares(projectId, azMap);
        JSONArray result = new JSONArray();
        for (Share share : shares) {
            JSONObject obj = this.getProtectAbleShareJsonObject(share);
            result.add((Object)obj);
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"servers", (Object)result);
        return this.getResponse(Response.Status.OK, returnJson);
    }

    private Optional<Response> checkRemoteInfo(String remoteRegion, String remoteAz) throws RestException {
        if (VerifyUtil.isEmpty((String)remoteRegion)) {
            this.wrong(Response.Status.BAD_REQUEST, "remoteRegion is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)remoteRegion)) {
            this.wrong(Response.Status.BAD_REQUEST, "remoteRegion is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)remoteAz)) {
            this.wrong(Response.Status.BAD_REQUEST, "remoteAz is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)remoteAz)) {
            this.wrong(Response.Status.BAD_REQUEST, "remoteAz is incorrect.");
        }
        return Optional.empty();
    }

    @Override
    public Response queryAvailableOsPlaceholderServers(String instanceType, String serverId, String projectId, String remoteProjectId, OpenStackAvailabilityZoneMapping zoneMapping) {
        return Response.ok().build();
    }

    @Override
    public Response queryAzPairs(String regionId) {
        List mappings = this.getOpenstackResourceService().getAZMappingsByObjectType(ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        ServiceInstaceEnumDefine.ServiceInstanceTypeE type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION;
        this.getAZMap(mappings, regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION, maps);
        ArrayList<OpenStackRepicaAvailabilityZone.RegionInfo> regionPairs = new ArrayList<OpenStackRepicaAvailabilityZone.RegionInfo>();
        boolean isAddSucc = false;
        for (Map map : maps) {
            if (map == null) {
                LOGGER.error((Object)"Parameter error. Empty AZ mapping exists.");
                throw new LegoCheckedException(0x300001L);
            }
            for (int j = 0; j < regionPairs.size(); ++j) {
                isAddSucc = false;
                OpenStackRepicaAvailabilityZone.RegionInfo regionPair = (OpenStackRepicaAvailabilityZone.RegionInfo)regionPairs.get(j);
                if (regionPair == null) {
                    LOGGER.error((Object)"The region information cannot be queried because the parameter is incorrect.");
                    throw new LegoCheckedException(0x300001L);
                }
                String primaryRegionId = regionPair.getPrimaryRegion().getRegionId();
                String secondRegionId = regionPair.getSecondRegion().getRegionId();
                if (primaryRegionId != null && secondRegionId != null && (isAddSucc = this.sameAZInSameRegion(j, regionPairs, map, type))) break;
            }
            if (isAddSucc) {
                LOGGER.info((Object)"Same data, skip");
                continue;
            }
            if (!map.get("primary_region_id").equals(regionId) && !map.get("second_region_id").equals(regionId)) continue;
            this.getAZMap(map, regionPairs, true, type);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"region_pairs", regionPairs);
        return Response.ok().entity((Object)jsonObject.toString()).build();
    }

    protected JSONObject getProtectAbleShareJsonObject(Share share) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)share.getName());
        jsonObject.put((Object)"description", (Object)share.getDescription());
        jsonObject.put((Object)"status", (Object)share.getStatus());
        jsonObject.put((Object)"share_proto", (Object)share.getShareProto());
        jsonObject.put((Object)"id", (Object)share.getId());
        jsonObject.put((Object)"size", (Object)share.getSize());
        jsonObject.put((Object)"share_type", (Object)share.getShareType());
        return jsonObject;
    }
}

