/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.common;

import com.huawei.ism.drm.cloudservice.rest.cloudservice.annotation.Enum;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EnumValidator
implements ConstraintValidator<Enum, Object> {
    private static final Log LOGGER = LogFactory.getInstance(EnumValidator.class);
    private static Map<String, Set<Object>> enumSetMap = new HashMap<String, Set<Object>>();
    private String clazzName;

    public void initialize(Enum constraintAnnotation) {
        this.clazzName = constraintAnnotation.clazz().getSimpleName();
        String clazzMethod = constraintAnnotation.method();
        if (enumSetMap.containsKey(this.clazzName)) {
            return;
        }
        List enumList = Optional.of(constraintAnnotation).map(Enum::clazz).map(Class::getEnumConstants).map(Arrays::asList).orElseGet(Collections::emptyList);
        try {
            Method method = constraintAnnotation.clazz().getMethod(clazzMethod, new Class[0]);
            Set enumSet = enumList.stream().map(constraint -> {
                try {
                    return method.invoke(constraint, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.error((Object)"Get enum '%s' value '%s' by method '%s' failed, err: %s", new Object[]{this.clazzName, constraint, clazzMethod, ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Get enum '%s' value '%s' by method '%s' failed, err: %s", new Object[]{this.clazzName, constraint, clazzMethod, ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                return new Object();
            }).collect(Collectors.toSet());
            enumSetMap.put(this.clazzName, enumSet);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)"Get enum '%s' method '%s' failed, err: %s", new Object[]{this.clazzName, clazzMethod, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        catch (Exception e) {
            LOGGER.error((Object)"Get enum '%s' method '%s' failed, err: %s", new Object[]{this.clazzName, clazzMethod, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        return value == null || enumSetMap.get(this.clazzName).contains(value);
    }
}

