/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.util;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InstanceTypeConverter {
    private static final String[][] MAPPINGS = new String[][]{{"csdr", "replication"}, {"csha", "hypermetro"}, {"vha", "vha"}};
    private static final Map<String, String> REPLICA_STATUS_MAP = new HashMap<String, String>(){
        {
            this.put(OpenstackEnumDefine.ReplicationRepStatusE.ACTIVE.getValue(), "normal");
            this.put(OpenstackEnumDefine.ReplicationRepStatusE.ACTIVESTOPPED.getValue(), "stop");
            this.put(OpenstackEnumDefine.ReplicationRepStatusE.INACTIVE.getValue(), "stop");
            this.put(OpenstackEnumDefine.ReplicationRepStatusE.ERROR.getValue(), "error");
            this.put(OpenstackEnumDefine.ReplicationRepStatusE.DISABLED.getValue(), "disabled");
            this.put(OpenstackEnumDefine.ReplicationRepStatusE.COPYING.getValue(), "copying");
            this.put(OpenstackEnumDefine.ReplicationRepStatusE.UNKNOWN.getValue(), "error");
        }
    };
    private static final Map<String, ServiceInstaceEnumDefine.ServiceInstanceTypeE> ENUMS = new HashMap<String, ServiceInstaceEnumDefine.ServiceInstanceTypeE>();

    public static String old2New(String instanceType) {
        return InstanceTypeConverter.get(instanceType, 1);
    }

    public static String new2Old(String instanceType) {
        return InstanceTypeConverter.get(instanceType, 0);
    }

    public static ServiceInstaceEnumDefine.ServiceInstanceTypeE old2Enum(String instanceType) {
        instanceType = InstanceTypeConverter.old2New(instanceType);
        return InstanceTypeConverter.new2Enum(instanceType);
    }

    public static ServiceInstaceEnumDefine.ServiceInstanceTypeE new2Enum(String instanceType) {
        return InstanceTypeConverter.new2Enum(instanceType, false);
    }

    public static ServiceInstaceEnumDefine.ServiceInstanceTypeE new2Enum(String instanceType, boolean warn) {
        ServiceInstaceEnumDefine.ServiceInstanceTypeE type = ENUMS.get(instanceType);
        if (instanceType != null && type == null && warn) {
            throw new LegoCheckedException(1073947393L, "instance_type is incorrect");
        }
        return type;
    }

    public static void old2New(List<InstanceInfoBO> instances) {
        if (instances == null) {
            return;
        }
        for (InstanceInfoBO instance : instances) {
            InstanceTypeConverter.old2New(instance);
        }
    }

    public static void old2New(InstanceInfoBO instance) {
        if (instance != null) {
            String type = InstanceTypeConverter.old2New(instance.getType());
            instance.setType(type);
            if (null != REPLICA_STATUS_MAP.get(instance.getReplicaStatus())) {
                instance.setReplicaStatus(REPLICA_STATUS_MAP.get(instance.getReplicaStatus()));
            }
        }
    }

    public static void new2Old(List<InstanceInfoBO> instances) {
        if (instances == null) {
            return;
        }
        for (InstanceInfoBO instance : instances) {
            InstanceTypeConverter.new2Old(instance);
        }
    }

    public static void new2Old(InstanceInfoBO instance) {
        if (instance != null) {
            String type = InstanceTypeConverter.new2Old(instance.getType());
            instance.setType(type);
        }
    }

    public static void new2Old(ServiceInstanceBO instance) {
        if (instance != null) {
            String type = InstanceTypeConverter.new2Old(instance.getType());
            instance.setType(type);
        }
    }

    private static String get(String key, int location) {
        if (key == null) {
            return null;
        }
        for (String[] mapping : MAPPINGS) {
            if (!key.equals(mapping[location])) continue;
            return mapping[(location + 1) % 2];
        }
        return key;
    }

    static {
        ENUMS.put("csdr", ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION);
        ENUMS.put("csha", ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO);
        ENUMS.put("vha", ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA);
        ENUMS.put("vha_csdr", ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION);
        ENUMS.put("csha_csdr", ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION);
    }
}

