/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.rest.client;

import com.huawei.ism.drm.wcc.rest.client.ResponseResult;
import com.huawei.ism.drm.wcc.rest.client.RestAdapter;
import com.huawei.ism.drm.wcc.rest.client.RestClient;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;

public class HttpsConnectTestRestClient
extends RestClient {
    private static final ILogger LOGGER = new CryptLogger();
    public static final String HTTPS_FAIL_MSG = "SSLHandshakeException";
    private static final int TIME_OUT = 3;

    public HttpsConnectTestRestClient(String domain, String port, boolean isForceCheckCert) throws AppException {
        super(domain, port, isForceCheckCert);
    }

    @Override
    protected ResponseResult doRequest(HttpHost targetHost, ClassicHttpRequest httpRequest) throws AppException {
        try {
            HttpGet httpGet = new HttpGet(targetHost.toURI());
            httpGet.setPath(httpRequest.getPath());
            RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.of((long)3L, (TimeUnit)TimeUnit.SECONDS)).setConnectTimeout(Timeout.of((long)3L, (TimeUnit)TimeUnit.SECONDS)).setConnectionRequestTimeout(Timeout.of((long)3L, (TimeUnit)TimeUnit.SECONDS)).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpGet);
            return RestAdapter.dealResponse(Optional.of(response));
        }
        catch (Exception e) {
            LOGGER.error("HttpsConnectTestRestClient failed to doRequest.");
            if (e instanceof SSLHandshakeException) {
                throw new AppException(HTTPS_FAIL_MSG);
            }
            throw new AppException(e.getMessage());
        }
    }
}

