/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.rest.client;

import com.huawei.ism.drm.wcc.rest.client.HttpRequestMethod;
import com.huawei.ism.drm.wcc.rest.client.ResponseResult;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.kmc.common.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.springframework.util.StreamUtils;

public class RestAdapter {
    private static final ILogger LOGGER = new CryptLogger();

    public static HttpHost buildHttpHost(String targetDomain, String port) {
        return new HttpHost("https", targetDomain, Integer.parseInt(port));
    }

    public static ClassicHttpRequest buildHttpRequest(String contextPath, HttpRequestMethod method, List<Header> headers, String requestBody) {
        switch (method) {
            case POST: {
                HttpPost httpPost = new HttpPost(contextPath);
                headers.forEach(arg_0 -> ((HttpPost)httpPost).addHeader(arg_0));
                httpPost.setEntity((HttpEntity)new StringEntity(requestBody, StandardCharsets.UTF_8));
                return httpPost;
            }
            case GET: {
                HttpGet httpGet = new HttpGet(contextPath);
                headers.forEach(arg_0 -> ((HttpGet)httpGet).addHeader(arg_0));
                return httpGet;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(contextPath);
                headers.forEach(arg_0 -> ((HttpPut)httpPut).addHeader(arg_0));
                httpPut.setEntity((HttpEntity)new StringEntity(requestBody, StandardCharsets.UTF_8));
                return httpPut;
            }
            case DELETE: {
                HttpDelete httpDelete = new HttpDelete(contextPath);
                headers.forEach(arg_0 -> ((HttpDelete)httpDelete).addHeader(arg_0));
                return httpDelete;
            }
            case PATCH: {
                HttpPatch httpPatch = new HttpPatch(contextPath);
                headers.forEach(arg_0 -> ((HttpPatch)httpPatch).addHeader(arg_0));
                httpPatch.setEntity((HttpEntity)new StringEntity(requestBody, StandardCharsets.UTF_8));
                return httpPatch;
            }
        }
        LOGGER.error("Not support http method.");
        return new HttpGet(contextPath);
    }

    public static ResponseResult dealResponse(Optional<CloseableHttpResponse> responseOptional) {
        if (!responseOptional.isPresent()) {
            LOGGER.error("Response empty.");
            return new ResponseResult(false, null);
        }
        CloseableHttpResponse response = responseOptional.get();
        String code = String.valueOf(response.getCode());
        if (code.startsWith("2")) {
            return new ResponseResult(true, response);
        }
        LOGGER.error(String.format(Locale.ENGLISH, "Request failed. errorCode: %s, errorMsg: %s", code, RestAdapter.getResponseContent(response.getEntity())));
        return new ResponseResult(false, response);
    }

    public static String getResponseContent(HttpEntity entity) {
        Objects.requireNonNull(entity);
        try {
            return StreamUtils.copyToString((InputStream)entity.getContent(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "Trans response content error. e:%s", e.getMessage()));
            return "";
        }
    }
}

