/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.rest.client;

import com.huawei.ism.drm.wcc.rest.client.HttpRequestMethod;
import com.huawei.ism.drm.wcc.rest.client.ResponseResult;
import com.huawei.ism.drm.wcc.rest.client.RestAdapter;
import com.huawei.ism.drm.wcc.rest.security.SSLTrustManager;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicHeader;

public class RestClient {
    private static final ILogger LOGGER = new CryptLogger();
    private static final int CONNECTION_TIME_OUT = 60000;
    private static final String TLS_V1_2 = "TLSv1.2";
    protected final CloseableHttpClient httpClient;
    private final String port;
    private final String targetDomain;

    public RestClient(String domain, String port) throws AppException {
        this(domain, port, Boolean.FALSE);
    }

    public RestClient(String domain, String port, boolean isForceCheckCert) throws AppException {
        this.targetDomain = domain;
        this.port = port;
        this.httpClient = this.buildRESTHttpClient(isForceCheckCert);
    }

    private CloseableHttpClient buildRESTHttpClient(boolean isForceCheckCert) throws AppException {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new SSLTrustManager(this.targetDomain, isForceCheckCert)}, SecureRandomFactory.getInstanceStrongWithDRBG());
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "Init SSL context catch exception. e:%s", e.getMessage()));
            throw new AppException("Init SSL context error.");
        }
        CloseableHttpClient client = null;
        try {
            String[] supportedProtocols = new String[]{TLS_V1_2};
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, supportedProtocols, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register("https", (Object)sslFactory).build();
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registry);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000L, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(30000L, TimeUnit.MILLISECONDS).setResponseTimeout(30000L, TimeUnit.MILLISECONDS).build();
            client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connMgr).disableContentCompression().build();
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "Build ssl exception. e:%s", e.getMessage()));
        }
        return client;
    }

    public ResponseResult doPost(String url, Map<String, String> header, String requestBody) throws AppException {
        if (header == null || StringUtils.isEmpty((CharSequence)requestBody)) {
            LOGGER.error("Param empty for post request.");
            throw new AppException("Param empty for post request.");
        }
        HttpHost targetHost = RestAdapter.buildHttpHost(this.targetDomain, this.port);
        ClassicHttpRequest httpRequest = RestAdapter.buildHttpRequest(url, HttpRequestMethod.POST, this.getHeaders(header), requestBody);
        return this.doRequest(targetHost, httpRequest);
    }

    public ResponseResult doGet(String url, Map<String, String> header) throws AppException {
        if (header == null) {
            LOGGER.error("Header cannot be null.");
            throw new AppException("Header is null for get request.");
        }
        HttpHost targetHost = RestAdapter.buildHttpHost(this.targetDomain, this.port);
        ClassicHttpRequest httpRequest = RestAdapter.buildHttpRequest(url, HttpRequestMethod.GET, this.getHeaders(header), null);
        return this.doRequest(targetHost, httpRequest);
    }

    public ResponseResult doPut(String url, Map<String, String> header, String requestBody) throws AppException {
        if (header == null || StringUtils.isEmpty((CharSequence)requestBody)) {
            LOGGER.error("Param empty for put request.");
            throw new AppException("Param empty for put request.");
        }
        HttpHost targetHost = RestAdapter.buildHttpHost(this.targetDomain, this.port);
        ClassicHttpRequest httpRequest = RestAdapter.buildHttpRequest(url, HttpRequestMethod.PUT, this.getHeaders(header), requestBody);
        return this.doRequest(targetHost, httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseResult doRequest(HttpHost targetHost, ClassicHttpRequest httpRequest) throws AppException {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Future<CloseableHttpResponse> future = exec.submit(() -> {
            CloseableHttpResponse response = null;
            try {
                response = this.httpClient.execute(targetHost, httpRequest);
            }
            catch (IOException e) {
                LOGGER.error(String.format(Locale.ENGLISH, "Execute request failed. e: %s", e.getMessage()));
            }
            return response;
        });
        try {
            ResponseResult responseResult = RestAdapter.dealResponse(Optional.ofNullable(future.get(10L, TimeUnit.SECONDS)));
            return responseResult;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("Execute request time out.");
        }
        finally {
            exec.shutdown();
        }
        return RestAdapter.dealResponse(Optional.empty());
    }

    private List<Header> getHeaders(Map<String, String> header) {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("Accept", (Object)"application/json"));
        headers.add((Header)new BasicHeader("Content-Type", (Object)"application/json;charset=utf8"));
        header.keySet().forEach(key -> headers.add((Header)new BasicHeader(key, header.get(key))));
        return headers;
    }
}

