/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.rest.security;

import com.huawei.ism.drm.wcc.util.alarm.CertAlarmQueue;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.utils.DaemonThreadFactory;
import com.huawei.ism.drm.wcc.util.utils.FileUtils;
import com.huawei.ism.drm.wcc.util.utils.FileWatchService;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.ILogger;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractX509TrustManager
implements X509TrustManager {
    private static final ILogger LOGGER = new CryptLogger();
    protected static final String CERT_AUTH_SWITCH = "cert.auth.switch";
    private static final Set<String> INITIALIZED_KEY_STORE_SET = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Queue<WeakReference<AbstractX509TrustManager>> TRUST_MANAGER_QUEUE = new ConcurrentLinkedQueue<WeakReference<AbstractX509TrustManager>>();
    private static final int RADIX = 16;
    private static final int MAX_WILL_BE_EXPIRED_DAYS = 90;
    private static final long SCHEDULE_PERIOD = 60L;
    private static final long SCHEDULE_INITIAL_DELAY = 0L;
    private static final Consumer<AbstractX509TrustManager> RELOAD_CRL_CONSUMER = AbstractX509TrustManager::loadCrl;
    private static final Consumer<AbstractX509TrustManager> RELOAD_TRUST_MANAGER_CONSUMER = abstractX509TrustManager -> {
        if (AbstractX509TrustManager.getKeystoreFileModifyTime() == 0L) {
            abstractX509TrustManager.reloadKeystoreFileModifyTime();
        }
        abstractX509TrustManager.reloadTrustManager();
    };
    private static long keystoreFileModifyTime = 0L;
    protected String ipAddress;
    protected X509TrustManager trustManager;
    private boolean isForceCheckCert = Boolean.FALSE;
    private String keystoreFile;
    private Set<String> revokedCertSnSet;

    public AbstractX509TrustManager(String keystoreFile, String ipAddress, X509TrustManager trustManager, boolean isForceCheckCert) {
        this.keystoreFile = keystoreFile;
        this.ipAddress = ipAddress;
        this.trustManager = trustManager;
        this.isForceCheckCert = isForceCheckCert;
        TRUST_MANAGER_QUEUE.offer(new WeakReference<AbstractX509TrustManager>(this));
        this.loadCrl();
        this.initKeystore();
    }

    public AbstractX509TrustManager(String keystoreFile, String ipAddress, X509TrustManager trustManager) {
        this.keystoreFile = keystoreFile;
        this.ipAddress = ipAddress;
        this.trustManager = trustManager;
        this.isForceCheckCert = false;
    }

    private static synchronized void iterateTrustManagerQueue(Consumer<AbstractX509TrustManager> consumer) {
        int trustManagersSize = TRUST_MANAGER_QUEUE.size();
        for (int i = 0; i < trustManagersSize; ++i) {
            AbstractX509TrustManager abstractX509TrustManager;
            WeakReference<AbstractX509TrustManager> weakReference = TRUST_MANAGER_QUEUE.poll();
            if (weakReference == null || (abstractX509TrustManager = (AbstractX509TrustManager)weakReference.get()) == null) continue;
            try {
                consumer.accept(abstractX509TrustManager);
            }
            catch (Exception e) {
                LOGGER.error("IterateTrustManagerQueue Failed to execute consumer.");
            }
            TRUST_MANAGER_QUEUE.offer(weakReference);
        }
    }

    public static long getKeystoreFileModifyTime() {
        return keystoreFileModifyTime;
    }

    private static void reloadTrustManagers() {
        AbstractX509TrustManager.iterateTrustManagerQueue(RELOAD_TRUST_MANAGER_CONSUMER);
        keystoreFileModifyTime = 0L;
    }

    public void setForceCheckCert(boolean isForceCheckCert) {
        this.isForceCheckCert = isForceCheckCert;
    }

    public boolean isForceCheckCert() {
        return this.isForceCheckCert;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    protected abstract void reloadTrustManager();

    protected void checkRevoked(X509Certificate[] chain) throws SSLHandshakeException {
        HashMap<String, Set<String>> revokedCertsMap = new HashMap<String, Set<String>>();
        if (this.revokedCertSnSet == null || this.revokedCertSnSet.isEmpty()) {
            HashSet<String> normalCertSet = new HashSet<String>();
            normalCertSet.add(this.ipAddress);
            CertAlarmQueue.getUnRevokedCertMap().addAll(normalCertSet);
            return;
        }
        HashSet<String> normalCertSet = new HashSet<String>();
        for (X509Certificate cert : chain) {
            String serialNumber = cert.getSerialNumber().toString(16).toUpperCase(Locale.ENGLISH);
            Principal principal = cert.getSubjectDN();
            if (!this.revokedCertSnSet.contains(serialNumber)) {
                normalCertSet.add(this.ipAddress);
                continue;
            }
            this.addToSet(revokedCertsMap, this.ipAddress, String.valueOf(principal));
            LOGGER.error(String.format(Locale.ROOT, "Found revoked cert: ip:%s, sn:%s, principal:%s.", this.ipAddress, serialNumber, principal));
        }
        CertAlarmQueue.addRevokedCerts(revokedCertsMap);
        CertAlarmQueue.addUnRevokedCerts(normalCertSet);
        if (!revokedCertsMap.isEmpty()) {
            throw new SSLHandshakeException("Cert is revoked.");
        }
    }

    protected void checkExpired(X509Certificate[] chain) throws SSLHandshakeException {
        for (X509Certificate x509Certificate : chain) {
            Date nowDate;
            Date notAfter = x509Certificate.getNotAfter();
            if (!notAfter.before(nowDate = new Date())) continue;
            LOGGER.error(String.format(Locale.ROOT, "Check server certificate failed. cert is not invalidity, ip=%s.", this.ipAddress));
            CertAlarmQueue.addFailForCertExpired(this.ipAddress);
            throw new SSLHandshakeException("Cert is expired.");
        }
    }

    protected void checkExpiring(X509Certificate[] chain) {
        int minDiffDays = Integer.MAX_VALUE;
        Date nowDate = new Date();
        for (X509Certificate x509Certificate : chain) {
            Date notAfter = x509Certificate.getNotAfter();
            int diffDays = AbstractX509TrustManager.getDiffDays(notAfter, nowDate);
            minDiffDays = Math.min(minDiffDays, diffDays);
        }
        if (minDiffDays <= 90) {
            LOGGER.warn(String.format(Locale.ROOT, "The certificate will be invalid in %s days at the earliest, ip=%s", this.ipAddress, minDiffDays));
            CertAlarmQueue.addFailForCertExpiring(this.ipAddress, minDiffDays);
        } else {
            CertAlarmQueue.addSuccessCertForNotExpiring(this.ipAddress);
        }
    }

    protected void checkTrusted(X509Certificate[] chain, String authType) throws SSLHandshakeException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
            CertAlarmQueue.addSuccessCert(this.ipAddress);
        }
        catch (CertificateException e) {
            LOGGER.error(String.format(Locale.ROOT, "Check server certificate failed, cert is not trusted, ip=%s.", this.ipAddress));
            CertAlarmQueue.addFailForCertNoTrust(this.ipAddress);
            throw new SSLHandshakeException("Cert is not trust.");
        }
    }

    private static int getDiffDays(Date d1, Date d2) {
        long diff = d1.getTime() - d2.getTime();
        return Math.toIntExact(TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS));
    }

    private void loadCrl() {
        Optional<String> runtimePathOptional = SysPropertiesUtils.getRuntimePath();
        if (!runtimePathOptional.isPresent()) {
            LOGGER.warn("RuntimePath not find, skip loadCrl.");
            return;
        }
        File crlFile = new File(runtimePathOptional.get() + "/LegoRuntime/certs/bcm.crl");
        if (!crlFile.isFile()) {
            LOGGER.warn("CrlFile not find, skip loadCrl.");
            return;
        }
        List<String> lineList = FileUtils.readLines(crlFile);
        if (!lineList.isEmpty()) {
            this.revokedCertSnSet = new HashSet<String>(lineList);
        }
    }

    private void addToSet(Map<String, Set<String>> map, String key, String value) {
        Set set = map.computeIfAbsent(key, defaultKey -> new HashSet());
        set.add(value);
    }

    private Pair<String, String> getKeyStoreFolderAndFileName() {
        String trustManagerKeystoreFile = this.getKeystoreFile();
        if (StringUtils.isEmpty((CharSequence)trustManagerKeystoreFile)) {
            return Pair.of(null, null);
        }
        int indexOf = trustManagerKeystoreFile.lastIndexOf(File.separator);
        if (indexOf == -1) {
            LOGGER.warn("End to getKeyStoreFolder, cause format not match.");
            return Pair.of(null, null);
        }
        return Pair.of((Object)trustManagerKeystoreFile.substring(0, indexOf), (Object)trustManagerKeystoreFile.substring(indexOf + 1));
    }

    private void reloadKeystoreFileModifyTime() {
        File file = new File(this.getKeystoreFile());
        keystoreFileModifyTime = file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKeystore() {
        Set<String> set = INITIALIZED_KEY_STORE_SET;
        synchronized (set) {
            if (INITIALIZED_KEY_STORE_SET.contains(this.getKeystoreFile())) {
                LOGGER.info(String.format(Locale.ROOT, "End to initKeystore, cause keystore file:%s already Initialized.", this.getKeystoreFile()));
                return;
            }
            Optional<String> runtimePathOption = SysPropertiesUtils.getRuntimePath();
            if (!runtimePathOption.isPresent()) {
                LOGGER.info("End to initKeystore, cause runtimePath not find.");
                return;
            }
            try {
                Pair<String, String> keyStoreFolderAndFileName = this.getKeyStoreFolderAndFileName();
                FileWatchService.registerTask((String)keyStoreFolderAndFileName.getLeft(), (String)keyStoreFolderAndFileName.getRight(), AbstractX509TrustManager::reloadTrustManagers);
                INITIALIZED_KEY_STORE_SET.add(this.getKeystoreFile());
            }
            catch (IOException e) {
                LOGGER.error("InitKeystore initialize fail.");
            }
        }
    }

    static {
        Optional<String> runtimePathOption = SysPropertiesUtils.getRuntimePath();
        if (runtimePathOption.isPresent()) {
            try {
                FileWatchService.registerTask(Paths.get(runtimePathOption.get(), "/LegoRuntime/certs/bcm.crl").getParent().toString(), "bcm.crl", Arrays.asList(StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE), () -> AbstractX509TrustManager.iterateTrustManagerQueue(RELOAD_CRL_CONSUMER));
            }
            catch (IOException e) {
                LOGGER.error("AbstractX509TrustManager reloadBcmCrl fail.");
                throw new ExceptionInInitializerError("AbstractX509TrustManager reloadBcmCrl fail.");
            }
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("AbstractX509TrustManager-pool"));
            scheduler.scheduleAtFixedRate(() -> {
                try {
                    AbstractX509TrustManager.iterateTrustManagerQueue(abstractX509TrustManager -> {});
                }
                catch (Exception e) {
                    LOGGER.error("Exception occurred when clearTrustManagers.");
                }
            }, 0L, 60L, TimeUnit.SECONDS);
        } else {
            LOGGER.info("RuntimePath not find, AbstractX509TrustManager skip register file watch task.");
        }
    }
}

