/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.rest.security;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.kmc.common.ILogger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;

public class SecureRandomFactory {
    private static final ILogger LOGGER = new CryptLogger();
    private static final boolean PREDICTION_RESISTANT = true;
    private static final boolean RE_SEED = false;
    private static final int CIPHER_LEN = 256;
    private static final int NONCE_LEN = 32;

    public static SecureRandom getInstanceStrongWithDRBG() throws NoSuchAlgorithmException {
        SecureRandom source;
        try {
            source = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("SecureRandom getInstanceStrong failed, Cause no such algorithm.");
            throw e;
        }
        AESEngine cipher = new AESEngine();
        byte[] nonce = new byte[32];
        source.nextBytes(nonce);
        return new SP800SecureRandomBuilder(source, true).buildCTR((BlockCipher)cipher, 256, nonce, false);
    }
}

