/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util;

import com.huawei.ism.drm.wcc.util.KeyUpdateHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class WrappedKeyUpdateHandler
implements KeyUpdateHandler {
    private ServiceLoader<KeyUpdateHandler> loader = ServiceLoader.load(KeyUpdateHandler.class);

    @Override
    public boolean doBeforeUpdate(String domain) {
        List<KeyUpdateHandler> handlers = this.getRootKeyUpdateHandlers();
        return !handlers.isEmpty() && handlers.stream().allMatch(handler -> handler.doBeforeUpdate(domain));
    }

    @Override
    public boolean doAfterUpdate(String domain) {
        List<KeyUpdateHandler> handlers = this.getRootKeyUpdateHandlers();
        return !handlers.isEmpty() && handlers.stream().allMatch(handler -> handler.doAfterUpdate(domain));
    }

    private List<KeyUpdateHandler> getRootKeyUpdateHandlers() {
        ArrayList<KeyUpdateHandler> handlers = new ArrayList<KeyUpdateHandler>();
        for (KeyUpdateHandler handler : this.loader) {
            handlers.add(handler);
        }
        return handlers;
    }
}

