/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.kmc;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.kmc.KmcNotifyCallback;
import com.huawei.ism.drm.wcc.util.kms.HardwareCallback;
import com.huawei.ism.drm.wcc.util.utils.ProcessOutputThread;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.IHardwareCallback;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.INotifyCallback;
import com.huawei.kmc.common.InitStage;
import com.huawei.kmc.common.KdfAlgForPwd;
import com.huawei.kmc.crypt.CryptoAPIEx;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class KmcInstance {
    public static int kmcDomain = 1;
    public static final String DOMAIN = "CRYPT_DEFAULT_DOMAIN";
    private static final ILogger logger = new CryptLogger();
    private static final String CIPHER_SEPARATOR = "@@@@@";
    private static final int ITERATIONS = 50000;
    private static final String SCRIPT_COMMD = "sudo -u root -S /opt/BCManager/Runtime/root_tools";
    private static final String ALARM_COMMAND = "/bin/reportAlarm.sh";
    private static final String GET_IP_COMMAND = "ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d \"addr:\"";
    private static final String DEFAULT_CIPHER = "generalCipher";
    private static final CryptoAPIEx SOFT_INSTANCE = new CryptoAPIEx();
    private static final CryptoAPIEx HW_INSTANCE = new CryptoAPIEx();
    private static final boolean IS_GENERAL_CIPHER;
    private static final KdfAlgForPwd KDF_ALG_FOR_PWD;

    private KmcInstance() {
    }

    public static CryptoAPIEx getInstance() {
        if (IS_GENERAL_CIPHER) {
            return SOFT_INSTANCE;
        }
        return HW_INSTANCE;
    }

    public static CryptoAPIEx getSoftInstance() {
        return SOFT_INSTANCE;
    }

    public static CryptoAPIEx getHwInstance() {
        return HW_INSTANCE;
    }

    public static String encrypt(String plainText) throws AppException {
        String softCipher = new String(SOFT_INSTANCE.encrypt(kmcDomain, plainText.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        if (IS_GENERAL_CIPHER) {
            return softCipher;
        }
        String hwCipher = "";
        try {
            hwCipher = new String(HW_INSTANCE.encrypt(kmcDomain, plainText.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (AppException exception) {
            logger.error(String.format(Locale.ENGLISH, "hw encrypt error. errorMsg: %s", exception.getMessage()));
        }
        return softCipher + CIPHER_SEPARATOR + hwCipher;
    }

    public static String decrypt(String cipherText) throws AppException {
        if (StringUtils.isEmpty((CharSequence)cipherText)) {
            logger.error("Empty cipher text. Decrypt failed.");
            throw new AppException("Empty cipher text. Decrypt failed.");
        }
        if (cipherText.contains(CIPHER_SEPARATOR)) {
            String[] ciphers = cipherText.split(CIPHER_SEPARATOR);
            if (KmcInstance.needDecryptByHw(ciphers)) {
                try {
                    return new String(HW_INSTANCE.decrypt(kmcDomain, ciphers[1].getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                }
                catch (AppException e) {
                    logger.error("Decrypt use hardWare failed. Exception:" + e.getMessage());
                }
            }
            return new String(SOFT_INSTANCE.decrypt(kmcDomain, ciphers[0].getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        return new String(SOFT_INSTANCE.decrypt(kmcDomain, cipherText.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    private static boolean needDecryptByHw(String[] ciphers) {
        return !IS_GENERAL_CIPHER && ciphers.length == 2 && StringUtils.isNotEmpty((CharSequence)ciphers[1]);
    }

    public static void registerKey(String key) throws AppException {
        KmcInstance.getInstance().registerByteKey(kmcDomain, key.getBytes(StandardCharsets.UTF_8));
    }

    public static synchronized void releaseComponent() throws AppException {
        SOFT_INSTANCE.finalized();
        if (!IS_GENERAL_CIPHER) {
            try {
                HW_INSTANCE.finalized();
            }
            catch (AppException e) {
                logger.error(String.format(Locale.ENGLISH, "release hw kmc failed. e: %s", e.getMessage()));
            }
        }
    }

    public static synchronized void initComponent(String path) {
        KmcInstance.initComponent(path, false);
    }

    public static synchronized void initComponent(String path, boolean isOnce) {
        String scriptPath = SCRIPT_COMMD;
        if (path.split("/Runtime").length != 0) {
            scriptPath = "sudo -u root -S " + path.split("/Runtime")[0] + "/Runtime/root_tools";
        }
        List<String> currentUserResult = KmcInstance.runShell("whoami");
        String currentUser = currentUserResult.get(0);
        boolean isRoot = currentUser.equalsIgnoreCase("root");
        String command = scriptPath + "/deleteKmcSem.sh " + currentUser;
        KmcInstance.runShell(command);
        KmcInstance.initSoftKmc(path, isOnce, isRoot, command);
        KmcInstance.initHwKmc(path, isOnce, isRoot, command);
    }

    private static void initHwKmc(String path, boolean isOnce, boolean isRoot, String command) {
        String currentCipher = SysPropertiesUtils.getCurrentCipherType(path);
        if (DEFAULT_CIPHER.equals(currentCipher)) {
            logger.debug("GeneralCipher type. No need to init hw kmc.");
            return;
        }
        if (InitStage.INIT_KMC_DONE.getValue() == HW_INSTANCE.getInitStage()) {
            return;
        }
        Properties kmcProps = SysPropertiesUtils.getHwProperties(path);
        kmcProps.put("primary_key_store_file", path + "/" + kmcProps.get("primary_key_store_file"));
        kmcProps.put("standby_key_store_file", path + "/" + kmcProps.get("standby_key_store_file"));
        HW_INSTANCE.setHardCallBack((IHardwareCallback)new HardwareCallback());
        KmcInstance.initKmc(kmcProps, command, HW_INSTANCE);
        if (!isRoot && !isOnce) {
            KmcInstance.asyncInitKmcTillSuccess(kmcProps, command);
        }
    }

    private static void asyncInitKmcTillSuccess(Properties kmcProps, String command) {
        if (InitStage.INIT_KMC_DONE.getValue() == HW_INSTANCE.getInitStage()) {
            KmcInstance.refreshMkMask(HW_INSTANCE);
            return;
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        executor.submit(() -> {
            boolean isNeedRetry;
            KmcInstance.sendAlarm();
            while (isNeedRetry = KmcInstance.retryTillSuccess(kmcProps, command)) {
            }
        });
        executor.shutdown();
    }

    private static void sendAlarm() {
        Optional<String> runtimePath = SysPropertiesUtils.getRuntimePath();
        if (runtimePath.isPresent()) {
            String localIp = KmcInstance.runShell(GET_IP_COMMAND).get(0);
            String kmsDomain = "kms-scc-apig." + SysPropertiesUtils.getRegionProperty("config.hcs.node.region") + "." + SysPropertiesUtils.getPropertyValue("config.hcs.domain");
            String baseCommand = "nohup sh %s --type 1 --severity 2 --alarmId 52625522 --createTime %s  --param \"%s,%s\"";
            String alarmCommand = String.format(Locale.ENGLISH, baseCommand, runtimePath.get() + ALARM_COMMAND, System.currentTimeMillis(), localIp, kmsDomain);
            KmcInstance.runShell(alarmCommand);
        }
    }

    private static boolean retryTillSuccess(Properties kmcProps, String command) {
        boolean isNeedRetry = true;
        try {
            Thread.sleep(600000L);
            SysPropertiesUtils.reloadProperties();
            HW_INSTANCE.initialize(kmcProps);
            if (0 == HW_INSTANCE.getMaxMkID(kmcDomain)) {
                HW_INSTANCE.activeNewKey(kmcDomain);
            }
            isNeedRetry = false;
            KmcInstance.refreshMkMask(HW_INSTANCE);
            KmcInstance.cleanAlarm();
        }
        catch (Exception e) {
            logger.error("Retry init hw kmc till success.");
            KmcInstance.runShell(command);
        }
        return isNeedRetry;
    }

    private static void cleanAlarm() {
        Optional<String> runtimePath = SysPropertiesUtils.getRuntimePath();
        if (runtimePath.isPresent()) {
            String localIp = KmcInstance.runShell(GET_IP_COMMAND).get(0);
            String baseCommand = "nohup sh %s --type 2 --severity 2 --alarmId 52625522 --createTime %s --param \"%s\"";
            String alarmCommand = String.format(Locale.ENGLISH, baseCommand, runtimePath.get() + ALARM_COMMAND, System.currentTimeMillis(), localIp);
            KmcInstance.runShell(alarmCommand);
        }
    }

    private static void initSoftKmc(String path, boolean isOnce, boolean isRoot, String command) {
        if (InitStage.INIT_KMC_DONE.getValue() == SOFT_INSTANCE.getInitStage()) {
            return;
        }
        Properties kmcProps = SysPropertiesUtils.getPropertiesFromFile(path);
        kmcProps.put("primary_key_store_file", path + "/" + kmcProps.get("primary_key_store_file"));
        kmcProps.put("standby_key_store_file", path + "/" + kmcProps.get("standby_key_store_file"));
        CryptoAPIEx.setJniLogger((ILogger)logger);
        CryptoAPIEx.setLogLevel((ILogger.LogLevel)ILogger.LogLevel.DISABLE);
        if (!isOnce) {
            KmcInstance.setNotifyCallback();
        }
        KmcInstance.initKmc(kmcProps, command, SOFT_INSTANCE);
        if (!isRoot) {
            KmcInstance.refreshMkMask(SOFT_INSTANCE);
        }
    }

    private static void initKmc(Properties kmcProps, String command, CryptoAPIEx instance) {
        int retries = 0;
        boolean isNeedRetry = true;
        do {
            try {
                instance.initialize(kmcProps);
                if (0 == instance.getMaxMkID(kmcDomain)) {
                    logger.info("Kmc active new key.");
                    instance.activeNewKey(kmcDomain);
                }
                isNeedRetry = false;
            }
            catch (Exception e) {
                logger.error("init KMC error:" + e);
                if (++retries % 3 == 0) {
                    logger.error("Repeat init kmc :" + retries);
                    break;
                }
                KmcInstance.runShell(command);
            }
        } while (isNeedRetry);
    }

    private static void refreshMkMask(CryptoAPIEx instance) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(() -> {
            try {
                instance.refreshMkMask();
            }
            catch (Exception e) {
                logger.error("exception occured when refreshMkMask");
            }
        }, 60000L, 3600000L, TimeUnit.MILLISECONDS);
    }

    private static void setNotifyCallback() {
        CryptoAPIEx.setJniNotifyCallback((INotifyCallback)new KmcNotifyCallback());
    }

    private static List<String> runShell(String shStr) {
        logger.debug("Begin to runShell(String shStr) shStr=" + shStr);
        ArrayList<String> result = new ArrayList<String>();
        int waitFor = 0;
        try {
            logger.debug("Runtime.getRuntime().exec " + shStr);
            Process process = Runtime.getRuntime().exec(shStr, null, null);
            ProcessOutputThread outputThread = new ProcessOutputThread(process.getInputStream());
            ProcessOutputThread errorOutputThread = new ProcessOutputThread(process.getErrorStream());
            outputThread.start();
            errorOutputThread.start();
            waitFor = process.waitFor();
            outputThread.join();
            errorOutputThread.join();
            List<String> outputList = outputThread.getOutputList();
            List<String> errorOutputList = errorOutputThread.getOutputList();
            result.addAll(outputList);
            result.addAll(errorOutputList);
            result.add(waitFor + "");
        }
        catch (Exception e) {
            logger.error("Run shell error :" + e.getMessage());
        }
        logger.debug("Finish runShell(String shStr). " + waitFor);
        return result;
    }

    public static String hmac(String key) {
        String softCipher = "";
        String hwCipher = "";
        try {
            softCipher = new String(SOFT_INSTANCE.hmacV2(kmcDomain, key.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            if (IS_GENERAL_CIPHER) {
                return softCipher;
            }
            hwCipher = new String(HW_INSTANCE.hmacV2(kmcDomain, key.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (AppException e) {
            logger.error(String.format(Locale.ENGLISH, "Hmac failed. e:%s", e.getMessage()));
        }
        return softCipher + CIPHER_SEPARATOR + hwCipher;
    }

    public static boolean hmacVerify(String plainText, String hmacData) {
        if (StringUtils.isEmpty((CharSequence)plainText) || StringUtils.isEmpty((CharSequence)hmacData)) {
            logger.error("Empty plain or hmac data.");
            return false;
        }
        try {
            if (hmacData.contains(CIPHER_SEPARATOR)) {
                String[] ciphers = hmacData.split(CIPHER_SEPARATOR);
                return KmcInstance.hmacVerifyDouble(plainText, ciphers);
            }
            return SOFT_INSTANCE.hmacVerify(kmcDomain, plainText.getBytes(StandardCharsets.UTF_8), hmacData.getBytes(StandardCharsets.UTF_8));
        }
        catch (AppException e) {
            logger.error("hmac verify catch exception:" + e.getMessage());
            return false;
        }
    }

    private static boolean hmacVerifyDouble(String plainText, String[] ciphers) throws AppException {
        boolean verifySuccess = false;
        if (KmcInstance.needDecryptByHw(ciphers)) {
            try {
                verifySuccess = HW_INSTANCE.hmacVerify(kmcDomain, plainText.getBytes(StandardCharsets.UTF_8), ciphers[1].getBytes(StandardCharsets.UTF_8));
            }
            catch (AppException ex) {
                logger.error("hmac verify use hw catch exception:" + ex.getMessage());
            }
        }
        return verifySuccess || SOFT_INSTANCE.hmacVerify(kmcDomain, plainText.getBytes(StandardCharsets.UTF_8), ciphers[0].getBytes(StandardCharsets.UTF_8));
    }

    public static String protectPwdEx(String pwd) {
        String result = "";
        if (StringUtils.isEmpty((CharSequence)pwd)) {
            logger.error("Pwd empty. No need do protect.");
            return result;
        }
        try {
            byte[] hashData = SOFT_INSTANCE.protectPwdEx(KDF_ALG_FOR_PWD, 50000, pwd.getBytes(StandardCharsets.UTF_8));
            result = new String(hashData, StandardCharsets.UTF_8);
        }
        catch (AppException e) {
            logger.error(String.format(Locale.ENGLISH, "Hash pwd failed. e:%s", e.getMessage()));
        }
        return result;
    }

    public static boolean verifyPwdEx(String plainText, String hashData) {
        if (StringUtils.isEmpty((CharSequence)plainText) || StringUtils.isEmpty((CharSequence)hashData)) {
            logger.error("Empty plain or hash data.");
            return false;
        }
        try {
            return SOFT_INSTANCE.verifyPwdEx(plainText.getBytes(StandardCharsets.UTF_8), hashData.getBytes(StandardCharsets.UTF_8));
        }
        catch (AppException e) {
            logger.error("Verify pwd catch exception:" + e.getMessage());
            return false;
        }
    }

    static {
        String currentCipher = SysPropertiesUtils.getValueWithDefault("cipher.type", DEFAULT_CIPHER);
        IS_GENERAL_CIPHER = DEFAULT_CIPHER.equals(currentCipher);
        KDF_ALG_FOR_PWD = IS_GENERAL_CIPHER ? KdfAlgForPwd.PWD_PBKDF2_HMAC_SHA256 : KdfAlgForPwd.PWD_PBKDF2_HMAC_SM3;
    }
}

