/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.utils;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.kmc.common.ILogger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ProcessOutputThread
extends Thread {
    private static final ILogger LOGGER = new CryptLogger();
    private InputStream is;
    private List<String> outputList;

    public ProcessOutputThread(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("The provided InputStream is null");
        }
        this.is = is;
        this.outputList = new ArrayList<String>();
    }

    public List<String> getOutputList() {
        return this.outputList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (InputStreamReader ir = new InputStreamReader(this.is, Charset.defaultCharset().name());
             BufferedReader br = new BufferedReader(ir);){
            String output = br.readLine();
            while (output != null) {
                this.outputList.add(output);
                output = br.readLine();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read and write I/O streams.");
        }
        finally {
            ProcessOutputThread.close(this.is);
        }
    }

    public static void close(Closeable closed) {
        try {
            if (closed != null) {
                closed.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to read and write I/O streams.");
        }
    }
}

