/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.utils;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.utils.FileWatchService;
import com.huawei.kmc.common.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SysPropertiesUtils {
    private static final ILogger LOGGER = new CryptLogger();
    private static final String DEFAULT_FILE_NAME = "application.properties";
    private static final String DEFAULT_SM_FILE_NAME = "application-sm.properties";
    private static final String DEFAULT_SM_HW_FILE_NAME = "application-sm-hw.properties";
    private static final String DEFAULT_CIPHER = "generalCipher";
    private static Optional<Properties> nodeProperties = Optional.empty();
    private static Optional<Properties> legoProperties = Optional.empty();
    private static long legoConfigUpdateTime = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(String path) {
        Properties properties = new Properties();
        BufferedReader bufferedReader = null;
        try {
            String currentCipher = SysPropertiesUtils.getCurrentCipherType(path);
            bufferedReader = DEFAULT_CIPHER.equals(currentCipher) ? new BufferedReader(new FileReader(path + "/" + DEFAULT_FILE_NAME)) : new BufferedReader(new FileReader(path + "/" + DEFAULT_SM_FILE_NAME));
            properties.load(bufferedReader);
        }
        catch (IOException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "Load default properties file : %s", e.getMessage()));
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("BufferedReader close error.");
                }
            }
        }
        return properties;
    }

    public static String getCurrentCipherType(String kmcPath) {
        String legoConfigPath = kmcPath + "/../lego.properties";
        Properties properties = SysPropertiesUtils.getProperties(legoConfigPath);
        return properties.getProperty("cipher.type", DEFAULT_CIPHER);
    }

    public static String getPropertyValue(String key) {
        return SysPropertiesUtils.getPropertyValue(key, "");
    }

    public static String getPropertyValue(String key, String defaultValue) {
        if (!legoProperties.isPresent()) {
            SysPropertiesUtils.loadProperties("/LegoRuntime/conf/lego.properties");
        }
        if (!legoProperties.isPresent()) {
            return defaultValue;
        }
        String property = legoProperties.get().getProperty(key);
        return StringUtils.isEmpty((CharSequence)property) ? defaultValue : property;
    }

    public static String getValueWithDefault(String key, String defaultValue) {
        if (!legoProperties.isPresent()) {
            SysPropertiesUtils.loadProperties("/LegoRuntime/conf/lego.properties");
        }
        if (!legoProperties.isPresent()) {
            return defaultValue;
        }
        return legoProperties.get().getProperty(key, defaultValue);
    }

    public static String getRegionProperty(String key) {
        if (!nodeProperties.isPresent()) {
            SysPropertiesUtils.loadProperties("/LegoRuntime/conf/node.properties");
        }
        if (!nodeProperties.isPresent()) {
            return "";
        }
        return nodeProperties.get().getProperty(key, "");
    }

    private static void loadProperties(String file) {
        Optional<String> runtimePath = SysPropertiesUtils.getRuntimePath();
        runtimePath.ifPresent(path -> {
            String configPath = path + file;
            if ("/LegoRuntime/conf/lego.properties".equals(file)) {
                legoProperties = Optional.of(SysPropertiesUtils.getProperties(configPath));
                SysPropertiesUtils.setLegoConfigUpdateTime(System.currentTimeMillis());
            } else {
                nodeProperties = Optional.of(SysPropertiesUtils.getProperties(configPath));
            }
        });
    }

    private static Properties getProperties(String path) {
        File file = new File(path);
        if (!file.exists()) {
            LOGGER.error(String.format(Locale.ENGLISH, "get properties failed. file %s not exist.%n", path));
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException e) {
            LOGGER.error("read properties error.");
        }
        return properties;
    }

    public static Optional<String> getRuntimePath() {
        try {
            Path path;
            Path home = Paths.get("Runtime", new String[0]);
            for (path = Paths.get(SysPropertiesUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()); path != null && !home.equals(path.getFileName()); path = path.getParent()) {
            }
            if (path == null) {
                LOGGER.error("can't find runtime path.");
                return Optional.empty();
            }
            return Optional.of(path.toString());
        }
        catch (Exception e) {
            LOGGER.error("can't find runtime path.");
            return Optional.empty();
        }
    }

    public static Properties getHwProperties(String path) {
        Properties properties = new Properties();
        try (BufferedReader reader = new BufferedReader(new FileReader(path + "/" + DEFAULT_SM_HW_FILE_NAME));){
            properties.load(reader);
        }
        catch (IOException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "load default properties file : %s", e.getMessage()));
        }
        return properties;
    }

    public static void reloadProperties() {
        SysPropertiesUtils.loadProperties("/LegoRuntime/conf/lego.properties");
        SysPropertiesUtils.loadProperties("/LegoRuntime/conf/node.properties");
    }

    public static long getLegoConfigUpdateTime() {
        return legoConfigUpdateTime;
    }

    private static void setLegoConfigUpdateTime(long legoConfigUpdateTime) {
        SysPropertiesUtils.legoConfigUpdateTime = legoConfigUpdateTime;
    }

    static {
        Optional<String> runtimePathOptional = SysPropertiesUtils.getRuntimePath();
        if (runtimePathOptional.isPresent()) {
            try {
                FileWatchService.registerTask(Paths.get(runtimePathOptional.get(), "/LegoRuntime/conf/lego.properties").getParent().toString(), "lego.properties", SysPropertiesUtils::reloadProperties);
                FileWatchService.registerTask(Paths.get(runtimePathOptional.get(), "/LegoRuntime/conf/node.properties").getParent().toString(), "node.properties", SysPropertiesUtils::reloadProperties);
            }
            catch (IOException e) {
                LOGGER.error("SysPropertiesUtils initialize fail.");
                throw new ExceptionInInitializerError("SysPropertiesUtils initialize fail.");
            }
        } else {
            LOGGER.info("RuntimePath not find, skip register file watch task.");
        }
    }
}

