/*
 * Decompiled with CFR 0.152.
 */
package com.google.json;

import java.math.BigInteger;

public final class JsonSanitizer {
    public static final int DEFAULT_NESTING_DEPTH = 64;
    public static final int MAXIMUM_NESTING_DEPTH = 4096;
    private final int maximumNestingDepth;
    private final String jsonish;
    private int bracketDepth;
    private boolean[] isMap;
    private StringBuilder sanitizedJson;
    private int cleaned;
    private static final boolean SUPER_VERBOSE_AND_SLOW_LOGGING = false;
    private static final UnbracketedComma UNBRACKETED_COMMA = new UnbracketedComma();
    private static final char[] HEX_DIGITS;
    private static final int[] DIGITS_BY_BASE_THAT_FIT_IN_63B;

    public static String sanitize(String jsonish) {
        return JsonSanitizer.sanitize(jsonish, 64);
    }

    public static String sanitize(String jsonish, int maximumNestingDepth) {
        JsonSanitizer s = new JsonSanitizer(jsonish, maximumNestingDepth);
        s.sanitize();
        return s.toString();
    }

    JsonSanitizer(String jsonish) {
        this(jsonish, 64);
    }

    JsonSanitizer(String jsonish, int maximumNestingDepth) {
        this.maximumNestingDepth = Math.min(Math.max(1, maximumNestingDepth), 4096);
        this.jsonish = jsonish != null ? jsonish : "null";
    }

    int getMaximumNestingDepth() {
        return this.maximumNestingDepth;
    }

    void sanitize() {
        this.cleaned = 0;
        this.bracketDepth = 0;
        this.sanitizedJson = null;
        State state = State.START_ARRAY;
        int n = this.jsonish.length();
        block33: for (int i = 0; i < n; ++i) {
            try {
                char ch = this.jsonish.charAt(i);
                block1 : switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        state = this.requireValueState(i, state, true);
                        int strEnd = JsonSanitizer.endOfQuotedString(this.jsonish, i);
                        this.sanitizeString(i, strEnd);
                        i = strEnd - 1;
                        break;
                    }
                    case '(': 
                    case ')': {
                        this.elide(i, i + 1);
                        break;
                    }
                    case '[': 
                    case '{': {
                        boolean map;
                        state = this.requireValueState(i, state, false);
                        if (this.isMap == null) {
                            this.isMap = new boolean[this.maximumNestingDepth];
                        }
                        this.isMap[this.bracketDepth] = map = ch == '{';
                        ++this.bracketDepth;
                        state = map ? State.START_MAP : State.START_ARRAY;
                        break;
                    }
                    case ']': 
                    case '}': {
                        char closeBracket;
                        if (this.bracketDepth == 0) {
                            this.elide(i, this.jsonish.length());
                            break block33;
                        }
                        switch (state) {
                            case BEFORE_VALUE: {
                                this.insert(i, "null");
                                break;
                            }
                            case BEFORE_ELEMENT: 
                            case BEFORE_KEY: {
                                this.elideTrailingComma(i);
                                break;
                            }
                            case AFTER_KEY: {
                                this.insert(i, ":null");
                                break;
                            }
                        }
                        --this.bracketDepth;
                        char c = closeBracket = this.isMap[this.bracketDepth] ? (char)'}' : ']';
                        if (ch != closeBracket) {
                            this.replace(i, i + 1, closeBracket);
                        }
                        state = this.bracketDepth == 0 || !this.isMap[this.bracketDepth - 1] ? State.AFTER_ELEMENT : State.AFTER_VALUE;
                        break;
                    }
                    case ',': {
                        if (this.bracketDepth == 0) {
                            throw UNBRACKETED_COMMA;
                        }
                        switch (state) {
                            case AFTER_ELEMENT: {
                                state = State.BEFORE_ELEMENT;
                                break block1;
                            }
                            case AFTER_VALUE: {
                                state = State.BEFORE_KEY;
                                break block1;
                            }
                            case BEFORE_ELEMENT: 
                            case START_ARRAY: {
                                this.insert(i, "null");
                                state = State.BEFORE_ELEMENT;
                                break block1;
                            }
                            case BEFORE_KEY: 
                            case AFTER_KEY: 
                            case START_MAP: {
                                this.elide(i, i + 1);
                                break block1;
                            }
                            case BEFORE_VALUE: {
                                this.insert(i, "null");
                                state = State.BEFORE_KEY;
                            }
                        }
                        break;
                    }
                    case ':': {
                        if (state == State.AFTER_KEY) {
                            state = State.BEFORE_VALUE;
                            break;
                        }
                        this.elide(i, i + 1);
                        break;
                    }
                    case '/': {
                        int end = i + 1;
                        if (i + 1 < n) {
                            block23 : switch (this.jsonish.charAt(i + 1)) {
                                case '/': {
                                    int j;
                                    end = n;
                                    for (j = i + 2; j < n; ++j) {
                                        char cch = this.jsonish.charAt(j);
                                        if (cch != '\n' && cch != '\r' && cch != '\u2028' && cch != '\u2029') continue;
                                        end = j + 1;
                                        break block23;
                                    }
                                    break;
                                }
                                case '*': {
                                    end = n;
                                    if (i + 3 >= n) break;
                                    int j = i + 2;
                                    while ((j = this.jsonish.indexOf(47, j + 1)) >= 0) {
                                        if (this.jsonish.charAt(j - 1) != '*') continue;
                                        end = j + 1;
                                        break block23;
                                    }
                                    break;
                                }
                            }
                        }
                        this.elide(i, end);
                        i = end - 1;
                        break;
                    }
                    default: {
                        boolean isKeyword;
                        char tch;
                        int runEnd;
                        for (runEnd = i; runEnd < n && ('a' <= (tch = this.jsonish.charAt(runEnd)) && tch <= 'z' || '0' <= tch && tch <= '9' || tch == '+' || tch == '-' || tch == '.' || 'A' <= tch && tch <= 'Z' || tch == '_' || tch == '$'); ++runEnd) {
                        }
                        if (runEnd == i) {
                            this.elide(i, i + 1);
                            break;
                        }
                        state = this.requireValueState(i, state, true);
                        boolean isNumber = '0' <= ch && ch <= '9' || ch == '.' || ch == '+' || ch == '-';
                        boolean bl = isKeyword = !isNumber && this.isKeyword(i, runEnd);
                        if (!isNumber && !isKeyword) {
                            while (runEnd < n && !this.isJsonSpecialChar(runEnd)) {
                                ++runEnd;
                            }
                            if (runEnd < n && this.jsonish.charAt(runEnd) == '\"') {
                                ++runEnd;
                            }
                        }
                        if (state == State.AFTER_KEY) {
                            this.insert(i, '\"');
                            if (isNumber) {
                                this.canonicalizeNumber(i, runEnd);
                                this.insert(runEnd, '\"');
                            } else {
                                this.sanitizeString(i, runEnd);
                            }
                        } else if (isNumber) {
                            this.normalizeNumber(i, runEnd);
                        } else if (!isKeyword) {
                            this.insert(i, '\"');
                            this.sanitizeString(i, runEnd);
                        }
                        i = runEnd - 1;
                        break;
                    }
                }
                continue;
            }
            catch (UnbracketedComma e) {
                this.elide(i, this.jsonish.length());
                break;
            }
        }
        if (state == State.START_ARRAY && this.bracketDepth == 0) {
            this.insert(n, "null");
            state = State.AFTER_ELEMENT;
        }
        if (this.sanitizedJson != null && this.sanitizedJson.length() != 0 || this.cleaned != 0 || this.bracketDepth != 0) {
            if (this.sanitizedJson == null) {
                this.sanitizedJson = new StringBuilder(n + this.bracketDepth);
            }
            this.sanitizedJson.append(this.jsonish, this.cleaned, n);
            this.cleaned = n;
            switch (state) {
                case BEFORE_ELEMENT: 
                case BEFORE_KEY: {
                    this.elideTrailingComma(n);
                    break;
                }
                case AFTER_KEY: {
                    this.sanitizedJson.append(":null");
                    break;
                }
                case BEFORE_VALUE: {
                    this.sanitizedJson.append("null");
                    break;
                }
            }
            while (this.bracketDepth != 0) {
                this.sanitizedJson.append(this.isMap[--this.bracketDepth] ? (char)'}' : ']');
            }
        }
    }

    private void sanitizeString(int start, int end) {
        boolean closed = false;
        block19: for (int i = start; i < end; ++i) {
            char ch = this.jsonish.charAt(i);
            switch (ch) {
                case '\t': {
                    this.replace(i, i + 1, "\\t");
                    continue block19;
                }
                case '\n': {
                    this.replace(i, i + 1, "\\n");
                    continue block19;
                }
                case '\r': {
                    this.replace(i, i + 1, "\\r");
                    continue block19;
                }
                case '\u2028': {
                    this.replace(i, i + 1, "\\u2028");
                    continue block19;
                }
                case '\u2029': {
                    this.replace(i, i + 1, "\\u2029");
                    continue block19;
                }
                case '\"': 
                case '\'': {
                    if (i == start) {
                        if (ch != '\'') continue block19;
                        this.replace(i, i + 1, '\"');
                        continue block19;
                    }
                    if (i + 1 == end) {
                        char startDelim = this.jsonish.charAt(start);
                        if (startDelim != '\'') {
                            startDelim = '\"';
                        }
                        boolean bl = closed = startDelim == ch;
                    }
                    if (closed) {
                        if (ch != '\'') continue block19;
                        this.replace(i, i + 1, '\"');
                        continue block19;
                    }
                    if (ch != '\"') continue block19;
                    this.insert(i, '\\');
                    continue block19;
                }
                case '<': {
                    if (i + 3 >= end) continue block19;
                    int la = i + 1;
                    int c1AndDelta = JsonSanitizer.unescapedChar(this.jsonish, la);
                    char c1 = (char)c1AndDelta;
                    long c2AndDelta = JsonSanitizer.unescapedChar(this.jsonish, la += c1AndDelta >>> 16);
                    char c2 = (char)c2AndDelta;
                    la = (int)((long)la + (c2AndDelta >>> 16));
                    long c3AndEnd = JsonSanitizer.unescapedChar(this.jsonish, la);
                    char c3 = (char)c3AndEnd;
                    char lc1 = (char)(c1 | 0x20);
                    char lc2 = (char)(c2 | 0x20);
                    char lc3 = (char)(c3 | 0x20);
                    if (!(c1 == '!' && c2 == '-' && c3 == '-' || lc1 == 's' && lc2 == 'c' && lc3 == 'r') && (c1 != '/' || lc2 != 's' || lc3 != 'c')) continue block19;
                    this.replace(i, i + 1, "\\u003c");
                    continue block19;
                }
                case '>': {
                    if (i - 2 < start) continue block19;
                    int lb = i - 1;
                    int cm1AndDelta = JsonSanitizer.unescapedCharRev(this.jsonish, lb);
                    char cm1 = (char)cm1AndDelta;
                    int cm2AndDelta = JsonSanitizer.unescapedCharRev(this.jsonish, lb -= cm1AndDelta >>> 16);
                    char cm2 = (char)cm2AndDelta;
                    if ('-' != cm2 || '-' != cm1) continue block19;
                    this.replace(i, i + 1, "\\u003e");
                    continue block19;
                }
                case ']': {
                    if (i + 2 >= end) continue block19;
                    int la = i + 1;
                    long c1AndDelta = JsonSanitizer.unescapedChar(this.jsonish, la);
                    char c1 = (char)c1AndDelta;
                    la = (int)((long)la + (c1AndDelta >>> 16));
                    long c2AndEnd = JsonSanitizer.unescapedChar(this.jsonish, la);
                    char c2 = (char)c2AndEnd;
                    if (']' != c1 || '>' != c2) continue block19;
                    this.replace(i, i + 1, "\\u005d");
                    continue block19;
                }
                case '\\': {
                    if (i + 1 == end) {
                        this.elide(i, i + 1);
                        continue block19;
                    }
                    char sch = this.jsonish.charAt(i + 1);
                    switch (sch) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            ++i;
                            continue block19;
                        }
                        case 'v': {
                            this.replace(i, i + 2, "\\u0008");
                            ++i;
                            continue block19;
                        }
                        case 'x': {
                            if (i + 4 < end && this.isHexAt(i + 2) && this.isHexAt(i + 3)) {
                                this.replace(i, i + 2, "\\u00");
                                i += 3;
                                continue block19;
                            }
                            this.elide(i, i + 1);
                            continue block19;
                        }
                        case 'u': {
                            if (i + 6 < end && this.isHexAt(i + 2) && this.isHexAt(i + 3) && this.isHexAt(i + 4) && this.isHexAt(i + 5)) {
                                i += 5;
                                continue block19;
                            }
                            this.elide(i, i + 1);
                            continue block19;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int octalStart;
                            int octalEnd = octalStart = i + 1;
                            if (++octalEnd < end && this.isOctAt(octalEnd) && sch <= '3' && ++octalEnd < end && this.isOctAt(octalEnd)) {
                                ++octalEnd;
                            }
                            int value = 0;
                            for (int j = octalStart; j < octalEnd; ++j) {
                                char digit = this.jsonish.charAt(j);
                                value = value << 3 | digit - 48;
                            }
                            this.replace(octalStart, octalEnd, "u00");
                            this.appendHex(value, 2);
                            i = octalEnd - 1;
                            continue block19;
                        }
                    }
                    this.elide(i, i + 1);
                    continue block19;
                }
                default: {
                    if (ch >= ' ') {
                        if (ch < '\ud800') continue block19;
                        if (ch < '\ue000') {
                            if (Character.isHighSurrogate(ch) && i + 1 < end && Character.isLowSurrogate(this.jsonish.charAt(i + 1))) {
                                ++i;
                                continue block19;
                            }
                        } else if (ch <= '\ufffd') continue block19;
                    }
                    this.replace(i, i + 1, "\\u");
                    int j = 4;
                    while (--j >= 0) {
                        this.sanitizedJson.append(HEX_DIGITS[ch >>> (j << 2) & 0xF]);
                    }
                    break block0;
                }
            }
        }
        if (!closed) {
            this.insert(end, '\"');
        }
    }

    private State requireValueState(int pos, State state, boolean canBeKey) throws UnbracketedComma {
        switch (state) {
            case BEFORE_KEY: 
            case START_MAP: {
                if (canBeKey) {
                    return State.AFTER_KEY;
                }
                this.insert(pos, "\"\":");
                return State.AFTER_VALUE;
            }
            case AFTER_KEY: {
                this.insert(pos, ':');
                return State.AFTER_VALUE;
            }
            case BEFORE_VALUE: {
                return State.AFTER_VALUE;
            }
            case AFTER_VALUE: {
                if (canBeKey) {
                    this.insert(pos, ',');
                    return State.AFTER_KEY;
                }
                this.insert(pos, ",\"\":");
                return State.AFTER_VALUE;
            }
            case BEFORE_ELEMENT: 
            case START_ARRAY: {
                return State.AFTER_ELEMENT;
            }
            case AFTER_ELEMENT: {
                if (this.bracketDepth == 0) {
                    throw UNBRACKETED_COMMA;
                }
                this.insert(pos, ',');
                return State.AFTER_ELEMENT;
            }
        }
        throw new AssertionError();
    }

    private void insert(int pos, char ch) {
        this.replace(pos, pos, ch);
    }

    private void insert(int pos, String s) {
        this.replace(pos, pos, s);
    }

    private void elide(int start, int end) {
        if (this.sanitizedJson == null) {
            this.sanitizedJson = new StringBuilder(this.jsonish.length() + 16);
        }
        this.sanitizedJson.append(this.jsonish, this.cleaned, start);
        this.cleaned = end;
    }

    private void replace(int start, int end, char ch) {
        this.elide(start, end);
        this.sanitizedJson.append(ch);
    }

    private void replace(int start, int end, String s) {
        this.elide(start, end);
        this.sanitizedJson.append(s);
    }

    private static int endOfQuotedString(String s, int start) {
        char quote = s.charAt(start);
        int i = start;
        while ((i = s.indexOf(quote, i + 1)) >= 0) {
            int slashRunStart;
            for (slashRunStart = i; slashRunStart > start && s.charAt(slashRunStart - 1) == '\\'; --slashRunStart) {
            }
            if ((i - slashRunStart & 1) != 0) continue;
            return i + 1;
        }
        return s.length();
    }

    private void elideTrailingComma(int closeBracketPos) {
        int i = closeBracketPos;
        block8: while (--i >= this.cleaned) {
            switch (this.jsonish.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block8;
                }
                case ',': {
                    this.elide(i, i + 1);
                    return;
                }
            }
            throw new AssertionError((Object)("" + this.jsonish.charAt(i)));
        }
        assert (this.sanitizedJson != null);
        i = this.sanitizedJson.length();
        block9: while (--i >= 0) {
            switch (this.sanitizedJson.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case ',': {
                    this.sanitizedJson.setLength(i);
                    return;
                }
            }
            throw new AssertionError((Object)("" + this.sanitizedJson.charAt(i)));
        }
        throw new AssertionError((Object)("Trailing comma not found in " + this.jsonish + " or " + this.sanitizedJson));
    }

    private void normalizeNumber(int start, int end) {
        int intEnd;
        int pos = start;
        if (pos < end) {
            switch (this.jsonish.charAt(pos)) {
                case '+': {
                    this.elide(pos, pos + 1);
                    ++pos;
                    break;
                }
                case '-': {
                    ++pos;
                    break;
                }
            }
        }
        if (pos == (intEnd = this.endOfDigitRun(pos, end))) {
            this.insert(pos, '0');
        } else if ('0' == this.jsonish.charAt(pos)) {
            int digVal;
            boolean reencoded = false;
            int maxDigVal = 0;
            int probableBase = 10;
            int firstDigitIndex = -1;
            if (intEnd - pos == 1 && intEnd < end && 120 == (this.jsonish.charAt(intEnd) | 0x20)) {
                probableBase = 16;
                firstDigitIndex = intEnd + 1;
                ++intEnd;
                while (intEnd < end) {
                    char ch = this.jsonish.charAt(intEnd);
                    if ('0' <= ch && ch <= '9') {
                        digVal = ch - 48;
                    } else {
                        if ('a' > (ch = (char)(ch | 0x20)) || ch > 'f') break;
                        digVal = ch - 87;
                    }
                    maxDigVal = Math.max(digVal, maxDigVal);
                    ++intEnd;
                }
                reencoded = true;
            } else if (intEnd - pos > 1) {
                probableBase = 8;
                firstDigitIndex = pos;
                for (int i = pos; i < intEnd && (digVal = this.jsonish.charAt(i) - 48) >= 0; ++i) {
                    maxDigVal = Math.max(digVal, maxDigVal);
                }
                reencoded = true;
            }
            if (reencoded) {
                int base;
                this.elide(pos, intEnd);
                String digits = this.jsonish.substring(firstDigitIndex, intEnd);
                int nDigits = digits.length();
                int n = probableBase > maxDigVal ? probableBase : (base = maxDigVal > 10 ? 16 : 10);
                if (nDigits == 0) {
                    this.sanitizedJson.append('0');
                } else if (DIGITS_BY_BASE_THAT_FIT_IN_63B[base] >= nDigits) {
                    long value = Long.parseLong(digits, base);
                    this.sanitizedJson.append(value);
                } else {
                    BigInteger value = new BigInteger(digits, base);
                    this.sanitizedJson.append(value);
                }
            }
        }
        pos = intEnd;
        if (pos < end && this.jsonish.charAt(pos) == '.') {
            int fractionEnd;
            if ((fractionEnd = this.endOfDigitRun(++pos, end)) == pos) {
                this.insert(pos, '0');
            }
            pos = fractionEnd;
        }
        if (pos < end && 101 == (this.jsonish.charAt(pos) | 0x20)) {
            int expEnd;
            if (++pos < end) {
                switch (this.jsonish.charAt(pos)) {
                    case '+': 
                    case '-': {
                        ++pos;
                        break;
                    }
                }
            }
            if ((expEnd = this.endOfDigitRun(pos, end)) == pos) {
                this.insert(pos, '0');
            }
            pos = expEnd;
        }
        if (pos != end) {
            this.elide(pos, end);
        }
    }

    private boolean canonicalizeNumber(int start, int end) {
        this.elide(start, start);
        int sanStart = this.sanitizedJson.length();
        this.normalizeNumber(start, end);
        this.elide(end, end);
        int sanEnd = this.sanitizedJson.length();
        return JsonSanitizer.canonicalizeNumber(this.sanitizedJson, sanStart, sanEnd);
    }

    private static boolean canonicalizeNumber(StringBuilder sanitizedJson, int sanStart, int sanEnd) {
        int exp;
        int expStart;
        int expEnd;
        int fractionStart;
        int fractionEnd;
        int intStart;
        char ch;
        int intEnd;
        for (intEnd = intStart = sanStart + (sanitizedJson.charAt(sanStart) == '-' ? 1 : 0); intEnd < sanEnd && '0' <= (ch = sanitizedJson.charAt(intEnd)) && ch <= '9'; ++intEnd) {
        }
        if (intEnd == sanEnd || '.' != sanitizedJson.charAt(intEnd)) {
            fractionStart = fractionEnd = intEnd;
        } else {
            for (fractionEnd = fractionStart = intEnd + 1; fractionEnd < sanEnd && '0' <= (ch = sanitizedJson.charAt(fractionEnd)) && ch <= '9'; ++fractionEnd) {
            }
        }
        if (fractionEnd == sanEnd) {
            expStart = expEnd = sanEnd;
        } else {
            assert (101 == (sanitizedJson.charAt(fractionEnd) | 0x20));
            expStart = fractionEnd + 1;
            if (sanitizedJson.charAt(expStart) == '+') {
                ++expStart;
            }
            expEnd = sanEnd;
        }
        assert (intStart <= intEnd && intEnd <= fractionStart && fractionStart <= fractionEnd && fractionEnd <= expStart && expStart <= expEnd);
        if (expEnd == expStart) {
            exp = 0;
        } else {
            try {
                exp = Integer.parseInt(sanitizedJson.substring(expStart, expEnd), 10);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        int n = exp;
        boolean sawDecimal = false;
        boolean zero = true;
        int digitOutPos = intStart;
        int nZeroesPending = 0;
        for (int i = intStart; i < fractionEnd; ++i) {
            char ch2 = sanitizedJson.charAt(i);
            if (ch2 == '.') {
                sawDecimal = true;
                if (!zero) continue;
                nZeroesPending = 0;
                continue;
            }
            char digit = ch2;
            if (!(zero && digit == '0' || sawDecimal)) {
                ++n;
            }
            if (digit == '0') {
                ++nZeroesPending;
                continue;
            }
            if (zero) {
                if (sawDecimal) {
                    n -= nZeroesPending;
                }
                nZeroesPending = 0;
            }
            zero = false;
            while (nZeroesPending != 0 || digit != '\u0000') {
                char vdigit;
                if (nZeroesPending == 0) {
                    vdigit = digit;
                    digit = '\u0000';
                } else {
                    vdigit = '0';
                    --nZeroesPending;
                }
                sanitizedJson.setCharAt(digitOutPos++, vdigit);
            }
        }
        sanitizedJson.setLength(digitOutPos);
        int k = digitOutPos - intStart;
        if (zero) {
            sanitizedJson.setLength(sanStart);
            sanitizedJson.append('0');
            return true;
        }
        if (k <= n && n <= 21) {
            for (int i = k; i < n; ++i) {
                sanitizedJson.append('0');
            }
        } else if (0 < n && n <= 21) {
            sanitizedJson.insert(intStart + n, '.');
        } else if (-6 < n && n <= 0) {
            sanitizedJson.insert(intStart, "0.000000".substring(0, 2 - n));
        } else {
            if (k != 1) {
                sanitizedJson.insert(intStart + 1, '.');
            }
            int nLess1 = n - 1;
            sanitizedJson.append('e').append(nLess1 < 0 ? (char)'-' : '+').append(Math.abs(nLess1));
        }
        return true;
    }

    private boolean isKeyword(int start, int end) {
        int n = end - start;
        if (n == 5) {
            return "false".regionMatches(0, this.jsonish, start, n);
        }
        if (n == 4) {
            return "null".regionMatches(0, this.jsonish, start, n) || "true".regionMatches(0, this.jsonish, start, n);
        }
        return false;
    }

    private boolean isOctAt(int i) {
        return JsonSanitizer.isOct(this.jsonish.charAt(i));
    }

    private static boolean isOct(char ch) {
        return '0' <= ch && ch <= '7';
    }

    private boolean isHexAt(int i) {
        return JsonSanitizer.isHex(this.jsonish.charAt(i));
    }

    private static boolean isHex(char ch) {
        if ('0' <= ch && ch <= '9') {
            return true;
        }
        int lch = ch | 0x20;
        return 97 <= lch && lch <= 102;
    }

    private static int hexVal(char ch) {
        int lch;
        return lch - ((lch = ch | 0x20) <= 57 ? 48 : 87);
    }

    private boolean isJsonSpecialChar(int i) {
        char ch = this.jsonish.charAt(i);
        if (ch <= ' ') {
            return true;
        }
        switch (ch) {
            case '\"': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private void appendHex(int n, int nDigits) {
        int quadsToShift = nDigits;
        while (--quadsToShift >= 0) {
            int dig;
            this.sanitizedJson.append((char)(dig + ((dig = n >>> 4 * quadsToShift & 0xF) < 10 ? 48 : 87)));
        }
    }

    private int endOfDigitRun(int start, int limit) {
        for (int end = start; end < limit; ++end) {
            char ch = this.jsonish.charAt(end);
            if ('0' <= ch && ch <= '9') continue;
            return end;
        }
        return limit;
    }

    CharSequence toCharSequence() {
        return this.sanitizedJson != null ? this.sanitizedJson : this.jsonish;
    }

    public String toString() {
        return this.sanitizedJson != null ? this.sanitizedJson.toString() : this.jsonish;
    }

    private static int unescapedChar(String s, int left) {
        int n = s.length();
        if (left >= n) {
            return 0;
        }
        char c = s.charAt(left);
        if (c == '\\') {
            if (left + 1 == n) {
                return 65536;
            }
            char nc = s.charAt(left + 1);
            switch (nc) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int octalStart;
                    int octalEnd = octalStart = left + 1;
                    if (++octalEnd < n && JsonSanitizer.isOct(s.charAt(octalEnd)) && nc <= '3' && ++octalEnd < n && JsonSanitizer.isOct(s.charAt(octalEnd))) {
                        ++octalEnd;
                    }
                    int value = 0;
                    for (int j = octalStart; j < octalEnd; ++j) {
                        char digit = s.charAt(j);
                        value = value << 3 | digit - 48;
                    }
                    return octalEnd - left << 16 | value;
                }
                case 'x': {
                    if (left + 3 >= n) break;
                    char d0 = s.charAt(left + 2);
                    char d1 = s.charAt(left + 3);
                    if (!JsonSanitizer.isHex(d0) || !JsonSanitizer.isHex(d1)) break;
                    return 0x4000 | JsonSanitizer.hexVal(d0) << 4 | JsonSanitizer.hexVal(d1);
                }
                case 'u': {
                    if (left + 5 >= n) break;
                    char d0 = s.charAt(left + 2);
                    char d1 = s.charAt(left + 3);
                    char d2 = s.charAt(left + 4);
                    char d3 = s.charAt(left + 5);
                    if (!JsonSanitizer.isHex(d0) || !JsonSanitizer.isHex(d1) || !JsonSanitizer.isHex(d2) || !JsonSanitizer.isHex(d3)) break;
                    return 0x6000 | JsonSanitizer.hexVal(d0) << 12 | JsonSanitizer.hexVal(d1) << 8 | JsonSanitizer.hexVal(d2) << 4 | JsonSanitizer.hexVal(d3);
                }
                case 'b': {
                    return 131080;
                }
                case 'f': {
                    return 131084;
                }
                case 'n': {
                    return 131082;
                }
                case 'r': {
                    return 131085;
                }
                case 't': {
                    return 131081;
                }
                case 'v': {
                    return 131080;
                }
            }
            return 0x20000 | nc;
        }
        return 0x10000 | c;
    }

    private static int unescapedCharRev(String s, int rightIncl) {
        int left;
        if (rightIncl < 0) {
            return 0;
        }
        for (int i = 1; i < 6 && (left = rightIncl - i) >= 0; ++i) {
            int unescaped;
            if (s.charAt(left) != '\\') continue;
            int n = 1;
            while (left - n >= 0 && s.charAt(left - n) == '\\') {
                ++n;
            }
            if ((n & 1) != 0 || (unescaped = JsonSanitizer.unescapedChar(s, left)) >>> 16 != i) break;
            return unescaped;
        }
        return 0x10000 | s.charAt(rightIncl);
    }

    static {
        UNBRACKETED_COMMA.setStackTrace(new StackTraceElement[0]);
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DIGITS_BY_BASE_THAT_FIT_IN_63B = new int[]{-1, -1, 63, 39, 31, 27, 24, 22, 21, 19, 18, 18, 17, 17, 16, 16, 15};
    }

    private static final class UnbracketedComma
    extends Exception {
        private static final long serialVersionUID = 783239978717247850L;

        private UnbracketedComma() {
        }
    }

    private static enum State {
        START_ARRAY,
        BEFORE_ELEMENT,
        AFTER_ELEMENT,
        START_MAP,
        BEFORE_KEY,
        AFTER_KEY,
        BEFORE_VALUE,
        AFTER_VALUE;

    }
}

