/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc4;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc4.GaussDBBufferedStream;

public class Jdbc4GaussBlob
implements Blob {
    private byte[] data;

    protected Jdbc4GaussBlob() {
    }

    public Jdbc4GaussBlob(BaseConnection conn, byte[] data) throws SQLException {
        if (conn == null) {
            throw new SQLException("Connection is null!");
        }
        if (data == null) {
            throw new SQLException("Data is null!");
        }
        int len = data.length / 2;
        String str = new String(data);
        char[] achar = str.toCharArray();
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(Jdbc4GaussBlob.toByte(achar[pos]) << 4 | Jdbc4GaussBlob.toByte(achar[pos + 1]));
        }
        this.data = new byte[result.length + 1];
        System.arraycopy(result, 0, this.data, 1, result.length);
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new GaussDBBufferedStream(this.data);
    }

    @Override
    public InputStream getBinaryStream(long arg0, long arg1) throws SQLException {
        return null;
    }

    @Override
    public byte[] getBytes(long i, int l) throws SQLException {
        if (l < 0 || i < 1L) {
            throw new SQLException("Length is negative number or positon is smaller than 1.");
        }
        byte[] abyte0 = null;
        if (l == 0) {
            abyte0 = new byte[]{};
        } else {
            long l1 = 0L;
            byte[] abyte1 = new byte[l];
            l1 = this.getBytes(i, l, abyte1);
            if (l1 > 0L) {
                if (l1 == (long)l) {
                    abyte0 = abyte1;
                } else {
                    abyte0 = new byte[(int)l1];
                    System.arraycopy(abyte1, 0, abyte0, 0, (int)l1);
                }
            }
        }
        return abyte0;
    }

    public int getBytes(long i, int len, byte[] abyte0) throws SQLException {
        if (abyte0 == null) {
            throw new NullPointerException();
        }
        if (i < 0L || len < 0 || this.data != null && (long)len > (long)this.data.length - i) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0 || this.data == null) {
            return 0;
        }
        if ((long)len + i > (long)this.data.length) {
            System.arraycopy(this.data, (int)i, abyte0, 0, this.data.length - (int)i);
            return this.data.length - (int)i;
        }
        System.arraycopy(this.data, (int)i, abyte0, 0, len);
        return len;
    }

    @Override
    public long length() throws SQLException {
        long len = 0L;
        if (this.data != null) {
            len = this.data.length - 1;
        }
        return len;
    }

    @Override
    public long position(byte[] arg0, long arg1) throws SQLException {
        return 0L;
    }

    @Override
    public long position(Blob arg0, long arg1) throws SQLException {
        return 0L;
    }

    @Override
    public OutputStream setBinaryStream(long arg0) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(long)");
    }

    @Override
    public int setBytes(long arg0, byte[] arg1) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBytes(long,byte[])");
    }

    @Override
    public int setBytes(long arg0, byte[] arg1, int arg2, int arg3) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBytes(long,byte[],int.int)");
    }

    @Override
    public void truncate(long arg0) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "truncate(long)");
    }

    private static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }
}

