/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.alarm.common;

import com.huawei.alarm.common.KeyStoreManager;
import com.huawei.alarm.common.URLContext;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class RestClientImpl {
    private static final Log logger = LogFactory.getInstance(RestClientImpl.class);
    private static final int STATUS_OK = 200;
    private String ip;
    private String port;
    private String userName;
    private String userPwd;
    private CloseableHttpClient httpClient;
    private Function<String, String> decrypt;

    public RestClientImpl(String ip, String port, String userName, String userPwd, Function<String, String> decrypt) throws IOException {
        this.ip = ip;
        this.port = port;
        this.userName = userName;
        this.userPwd = userPwd;
        this.decrypt = decrypt;
        this.httpClient = this.buildRESTHttpClient(ip, Integer.valueOf(port), 60000);
    }

    private void setHeader(HttpUriRequestBase httpRequest) {
        httpRequest.addHeader("x-auth-user", (Object)this.userName);
        httpRequest.addHeader("x-auth-key", (Object)this.userPwd);
        httpRequest.addHeader("Accept", (Object)"application/json;version=1.0; charset=UTF-8");
        httpRequest.addHeader("Content-Type", (Object)"application/json; charset=UTF-8");
    }

    private String getFormatIp(String ipaddress) {
        if (Ipv4AddressUtil.isIPv4Address((String)ipaddress)) {
            return ipaddress;
        }
        if (Ipv6AddressUtil.isIPv6Address((String)ipaddress)) {
            return "[" + ipaddress + "]";
        }
        throw new LegoCheckedException("Get format ip failed, ip is " + ipaddress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void post(String requestParm) {
        URLContext urlContext = new URLContext("https://" + this.getFormatIp(this.ip) + "/ws/alarms", Integer.valueOf(this.port));
        HttpHost targetHost = new HttpHost("https", urlContext.getTargetDomain(), Integer.valueOf(this.port).intValue());
        HttpPost httpPost = new HttpPost("/ws/alarms");
        StringEntity entity = new StringEntity(requestParm, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        this.setHeader((HttpUriRequestBase)httpPost);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute(targetHost, (ClassicHttpRequest)httpPost);
            int status = response.getCode();
            if (status != 200) {
                throw new IOException(response.toString());
            }
            if (null == response) return;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Send post request failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Send post failed.");
            }
            catch (Throwable throwable) {
                if (null == response) throw throwable;
                try {
                    response.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.error((Object)"Close response failed. errMsg=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
                }
                throw throwable;
            }
        }
        try {
            response.close();
            return;
        }
        catch (Exception e) {
            logger.error((Object)"Close response failed. errMsg=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return;
        }
    }

    public void closeHttpClient() {
        if (null != this.httpClient) {
            try {
                this.httpClient.close();
            }
            catch (Exception e) {
                logger.error((Object)"Close httpClient failed. errMsg=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private CloseableHttpClient buildRESTHttpClient(String ipAddress, int port, int timeout) throws IOException {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new KeyStoreManager(this.decrypt)}, SecureRandomFactory.getInstanceStrongWithDRBG());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error((Object)"BuildRESTHttpClient failed: %s", (Throwable)e);
            throw new IOException("BuildRESTHttpClient failed.");
        }
        String[] supportedProtocols = new String[]{"TLSv1.2"};
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, supportedProtocols, null, (HostnameVerifier)new NoopHostnameVerifier());
        Registry registry = RegistryBuilder.create().register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registry);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(Timeout.ofMilliseconds((long)60000L));
        builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)timeout));
        RequestConfig requestConfig = builder.build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connMgr).disableContentCompression().build();
    }
}

