/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signer;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.signer.LogManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;

public class FileSigner {
    private final String exportFile = "SignFile";
    private final String encryptKeyFile = "SignFile.conf";

    public static void main(String[] args) {
        if (args.length < 1) {
            LogManager.info("Param error.");
            return;
        }
        FileSigner sigen = new FileSigner();
        if ("export".equals(args[0])) {
            if (args.length < 3) {
                LogManager.info("usage: [export] [exportPath] [password].");
                return;
            }
            sigen.export(args[1], args[2]);
            return;
        }
        if (args.length == 1) {
            String filePath = args[0];
            sigen.signFile(filePath);
        } else {
            String baseDir = args[0];
            String filePath = args[1];
            LogManager.info("set base directory: " + baseDir);
            LogManager.info("read files from " + filePath + "...");
            File file = new File(FilenameUtils.normalize((String)filePath));
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    String path = baseDir + line.trim();
                    LogManager.info("sign file: " + path);
                    sigen.signFile(path);
                }
            }
            catch (Exception e) {
                LogManager.error("sign file failed, error: " + e);
            }
        }
        System.exit(0);
    }

    private void signFile(String filePath) {
        String file = FilenameUtils.normalize((String)filePath);
        String currPath = System.getProperty("user.dir");
        LogManager.info("currPath =" + currPath);
        String wccConfFile = currPath + "/Runtime/LegoRuntime/conf/wcc";
        wccConfFile = FilenameUtils.normalize((String)wccConfFile);
        File conf = new File(wccConfFile);
        try (FileInputStream input = new FileInputStream(file);){
            KmcInstance.initComponent((String)conf.getCanonicalPath(), (boolean)true);
            LogManager.info("start sign file: " + file);
            byte[] bytes = new byte[((InputStream)input).available()];
            ((InputStream)input).read(bytes);
            String hash = KmcInstance.hmac((String)new String(bytes, StandardCharsets.UTF_8));
            this.writeHashToSign(file, hash);
        }
        catch (FileNotFoundException e) {
            LogManager.error("sigen file [" + file + "] failed, can't find the file.");
        }
        catch (Exception e) {
            LogManager.error("sign file [" + file + "] failed, errMsg: " + e);
        }
    }

    private void writeFile(String file, String msg) throws IOException {
        FileWriter fw = null;
        String normalizedFile = FilenameUtils.normalize((String)file);
        File ff = new File(normalizedFile);
        try {
            if (ff.exists()) {
                ff.delete();
            }
            if (ff.createNewFile()) {
                fw = new FileWriter(normalizedFile);
                fw.write(msg);
                fw.flush();
            }
        }
        catch (Exception e) {
            LogManager.error("write file failed, ErrMsg: " + e);
            throw new IOException("writ file failed, file is: " + file);
        }
        finally {
            FileSigner.closeCloseable(fw);
        }
    }

    private static void closeCloseable(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LogManager.error("Close BufferedReader failed.");
            }
        }
    }

    public void writeHashToSign(String sFile, String hash) throws IOException {
        File sign = new File(FilenameUtils.normalize((String)sFile));
        String path = sign.getParent();
        File sigenFile = new File(path, sign.getName() + ".sign");
        String tmp = sigenFile.getCanonicalPath();
        this.writeFile(tmp, hash);
    }

    private void writePwdToFile(String path, String password) throws IOException {
        String key = null;
        try {
            key = KmcInstance.encrypt((String)password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File encryptFile = new File(FilenameUtils.normalize((String)path), "SignFile.conf");
        String file = encryptFile.getCanonicalPath();
        this.writeFile(file, key);
    }

    private void export(String exportPath, String password) {
        LogManager.info("Export cryptor to file.");
        exportPath = FilenameUtils.normalize((String)exportPath);
        String currPath = System.getProperty("user.dir");
        String wccConfFile = currPath + "/Runtime/LegoRuntime/conf";
        File conf = new File(wccConfFile);
        try {
            KmcInstance.initComponent((String)conf.getCanonicalPath(), (boolean)true);
            this.writePwdToFile(exportPath, password);
        }
        catch (IOException e) {
            LogManager.error("Write encryptedPwd to file failed.");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File export = new File(exportPath, "SignFile");
        try {
            String file = export.getCanonicalPath();
            KmcInstance.getInstance().exportMkFile(file, password.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

