/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.acl.NotOwnerException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.jar.JarException;
import javax.naming.InsufficientResourcesException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.status.StatusLogger;

public class LogManager {
    private static final String[] VALID_PACKAGE_PREFIX_NAMES = new String[]{"com.huawei"};
    private static final String LOG_FILE_NAME = "log4j.properties";
    private static final String FQCN = LogManager.class.getName();
    private static final List<Class<? extends Throwable>> SPECIAL_EXCEPTION_CLASSES = Arrays.asList(SecurityException.class, GeneralSecurityException.class, ClassNotFoundException.class, FileNotFoundException.class, JarException.class, MissingResourceException.class, NotOwnerException.class, ConcurrentModificationException.class, InsufficientResourcesException.class, BindException.class, OutOfMemoryError.class, StackOverflowError.class, SQLException.class);
    private static final Logger RUN_LOG = Logger.getLogger((String)"run");
    private static String userDirectory;

    private static void logging(Level level, Object message) {
        if (message instanceof Throwable) {
            message = LogManager.getErrorMessage((Throwable)message);
        }
        RUN_LOG.log(FQCN, (Priority)level, message, null);
    }

    public static void error(Object msg) {
        LogManager.logging(Level.ERROR, msg);
    }

    public static void fatal(Object msg) {
        LogManager.logging(Level.FATAL, msg);
    }

    public static void debug(Object msg) {
        LogManager.logging(Level.DEBUG, msg);
    }

    public static void warn(Object msg) {
        LogManager.logging(Level.WARN, msg);
    }

    public static void info(Object msg) {
        LogManager.logging(Level.INFO, msg);
    }

    public static String getErrorMessage(Throwable exception) {
        StringBuilder strBuilder = new StringBuilder();
        if (exception == null) {
            return strBuilder.toString();
        }
        strBuilder.append(System.lineSeparator());
        Throwable throwable = exception;
        int index = 0;
        do {
            if (index >= 0) {
                strBuilder.append("Caused by: ");
            }
            String message = throwable.getMessage();
            if (LogManager.isSpecialException(throwable)) {
                message = "***";
            }
            strBuilder.append(throwable.getClass().getName() + ": " + message + System.lineSeparator());
            StackTraceElement[] elements = throwable.getStackTrace();
            LogManager.retrieveStackTraces(elements, strBuilder);
            throwable = throwable.getCause();
            ++index;
        } while (throwable != null);
        return strBuilder.toString();
    }

    private static boolean isSpecialException(Throwable exception) {
        for (Class<? extends Throwable> clazz : SPECIAL_EXCEPTION_CLASSES) {
            if (!clazz.isInstance(exception)) continue;
            return true;
        }
        return false;
    }

    private static void retrieveStackTraces(StackTraceElement[] elements, StringBuilder strBuilder) {
        int index = 0;
        for (StackTraceElement element : elements) {
            String clsName = element.getClassName();
            if (++index != 1 && !LogManager.isValidClass(clsName)) continue;
            strBuilder.append("   at   " + element.toString() + System.lineSeparator());
        }
    }

    private static boolean isValidClass(String clsName) {
        for (String validClsName : VALID_PACKAGE_PREFIX_NAMES) {
            if (!clsName.startsWith(validClsName)) continue;
            return true;
        }
        return false;
    }

    private static void init() {
        String userDir = "";
        try {
            userDir = new File(System.getProperty("user.dir")).getCanonicalPath() + "/logs";
        }
        catch (IOException e) {
            LogManager.error("get userDir fail, cause by " + LogManager.getErrorMessage(e));
        }
        System.setProperty("log4j.configDebug", "false");
        userDirectory = userDir;
        System.setProperty("LOGPATH", userDirectory);
        LogManager.loadLogFile();
    }

    private static void loadLogFile() {
        ClassLoader classLoader = LogManager.class.getClassLoader();
        String logFilePath = null;
        logFilePath = LOG_FILE_NAME;
        String localConfigFile = null;
        try {
            localConfigFile = new File("").getCanonicalPath() + File.separator + logFilePath;
        }
        catch (IOException e1) {
            LogManager.debug("log4j.properties not find.");
            return;
        }
        File file = new File(localConfigFile);
        if (file.exists()) {
            Configurator.initialize(null, (String)localConfigFile);
        } else if (classLoader != null) {
            URL url = classLoader.getResource(logFilePath);
            if (url != null) {
                try {
                    Configurator.initialize(null, (ClassLoader)classLoader, (URI)url.toURI());
                }
                catch (URISyntaxException e) {
                    StatusLogger.getLogger().error("File not exists");
                }
            }
        } else {
            return;
        }
    }

    static {
        LogManager.init();
    }
}

