/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.signer;

import com.huawei.signer.EncryptFile;
import com.huawei.signer.FileUtil;
import com.huawei.signer.LogManager;
import com.huawei.signer.ProperUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class UpdateUsername {
    private static final String PROPERTIES = "username.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateServerXml(String xmlFile, String node, String key, String value1) throws Exception {
        List element;
        Document document;
        XMLWriter writer;
        FileOutputStream fout;
        block5: {
            if (!new File(xmlFile).exists()) {
                LogManager.error("file is not exists: " + xmlFile);
                return;
            }
            fout = null;
            writer = null;
            SAXReader reader = new SAXReader();
            File xml = new File(xmlFile);
            UpdateUsername.setSecurityFeatures(reader);
            document = reader.read(xml);
            element = document.selectNodes(node);
            if (element != null) break block5;
            LogManager.error("select nodes failed.");
            FileUtil.closeOutStream(fout, writer);
            return;
        }
        try {
            for (Node ele : element) {
                String currentValue;
                if (!(ele instanceof Element) || ((Element)ele).attribute(key) == null || (currentValue = ((Element)ele).attribute(key).getValue()) == null || currentValue.equals("")) continue;
                LogManager.info("node key: " + key);
                ((Element)ele).addAttribute(key, value1);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fout = new FileOutputStream(xmlFile);
            writer = new XMLWriter((OutputStream)fout, format);
            writer.write(document);
        }
        catch (Throwable throwable) {
            FileUtil.closeOutStream(fout, writer);
            throw throwable;
        }
        FileUtil.closeOutStream(fout, writer);
    }

    private static void setSecurityFeatures(SAXReader reader) throws SAXException {
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    private static void updateProperties(String file, String key, String value) throws IOException {
        String[] values;
        File tmp = new File(file);
        if (!tmp.exists()) {
            LogManager.error("the file is not exists.");
            throw new IOException();
        }
        String[] keys = key.split(";");
        if (keys.length != (values = value.split(";")).length) {
            LogManager.error("keys length= " + keys.length + ", values length: " + values.length);
            throw new IOException();
        }
        String filePathTmp = new File(file).getParent() + File.separator + "tmpConf.properties";
        try (LineIterator lineIterator = FileUtils.lineIterator((File)new File(file), (String)StandardCharsets.UTF_8.name());
             BufferedWriter filePathTmpBw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(filePathTmp, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            while (lineIterator.hasNext()) {
                String line = lineIterator.next();
                UpdateUsername.writeToFile(keys, values, filePathTmpBw, line);
            }
            new File(file).delete();
            FileUtils.moveFile((File)new File(filePathTmp), (File)new File(file));
        }
    }

    private static void writeToFile(String[] keys, String[] values, BufferedWriter filePathTmpBw, String line) throws IOException {
        if (line != null) {
            String newLine = line;
            for (int i = 0; i < keys.length; ++i) {
                if (FileUtil.isEmpty(line) || !line.replace(" ", "").startsWith(keys[i] + "=")) continue;
                LogManager.info("keys: " + keys[i]);
                newLine = keys[i] + "=" + values[i];
            }
            filePathTmpBw.write(newLine);
            filePathTmpBw.newLine();
        } else {
            filePathTmpBw.write(line);
            filePathTmpBw.newLine();
        }
    }

    public static void main(String[] args) throws Exception {
        ProperUtil properUtil = new ProperUtil();
        properUtil.getEncryptedProperties(PROPERTIES);
        List<EncryptFile> fileList = properUtil.getUtilList();
        if (fileList == null || fileList.isEmpty()) {
            LogManager.error("fileList is null, return");
            return;
        }
        for (EncryptFile fileUtil : fileList) {
            String fileName = fileUtil.getFileName();
            String keyName = fileUtil.getKeyName();
            String keyValue = fileUtil.getKeyValue();
            if (fileName.endsWith(".xml")) {
                String nodeValue = fileUtil.getNodeValue();
                UpdateUsername.updateServerXml(fileName, nodeValue, keyName, keyValue);
                continue;
            }
            if (fileName.endsWith(".properties")) {
                UpdateUsername.updateProperties(fileName, keyName, keyValue);
                continue;
            }
            LogManager.error("Not supported.");
        }
        System.exit(0);
    }
}

