/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.check;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpgradeCheck {
    private static final Log LOG = LogFactory.getInstance(UpgradeCheck.class);

    public static void main(String[] args) {
        try {
            UpdateUtil.exportConfig();
            if (!UpgradeCheck.checkWorkRunning()) {
                SystemExitUtil.exitOK();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Export wcc config failed.", "");
        }
        SystemExitUtil.exitFail();
    }

    public static boolean checkWorkRunning() {
        return UpgradeCheck.checkIsProtectGroupRunning() || UpgradeCheck.checkIsRecoveryRunning();
    }

    private static boolean checkIsProtectGroupRunning() {
        LOG.info((Object)"Start check if ProtectGroup is running.", "");
        boolean isRun = false;
        String querySql = "select status from ti_protectgroup;";
        String[] status = new String[]{"5"};
        List<String> result = UpgradeCheck.queryData(querySql);
        if (UpgradeCheck.checkData(result, status)) {
            isRun = true;
        }
        return isRun;
    }

    private static boolean checkIsRecoveryRunning() {
        LOG.info((Object)"Start check if RecoveryPlan is running.", "");
        boolean isRun = false;
        String querySql = "select PLANSTATUS from ti_recoveryplan;";
        String[] status = new String[]{"1", "4", "7", "10", "15", "17"};
        List<String> result = UpgradeCheck.queryData(querySql);
        if (UpgradeCheck.checkData(result, status)) {
            isRun = true;
        }
        return isRun;
    }

    private static boolean checkData(List<String> result, String[] status) {
        if (!VerifyUtil.isEmpty(result)) {
            for (int i = 0; i < status.length; ++i) {
                if (!result.contains(status[i])) continue;
                LOG.error((Object)("Find status: " + status[i]), "");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> queryData(String querySql) {
        Connection connect = null;
        ArrayList<String> statusList = new ArrayList<String>();
        try {
            DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            connect = LegoDBConnection.getInstance().connectDBWithDba(dataBase, "LEGO");
            if (null == connect) {
                LOG.error((Object)"Connect database failed.", "");
                return statusList;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Connect data base failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            return statusList;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = InitSQL.executeSQLQuery(connect, querySql);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                statusList.add(rs.getString(1));
            }
        }
        catch (PatchException ep) {
            LOG.error((Object)"", (Throwable)ep, "");
        }
        catch (SQLException e) {
            LOG.error((Object)("QueryData failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        finally {
            UpgradeCheck.closeStream(preparedStatement);
            if (null != connect) {
                try {
                    connect.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Close connetcion: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
            }
        }
        return statusList;
    }

    private static void closeStream(PreparedStatement preparedStatement) {
        if (null != preparedStatement) {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                LOG.error((Object)("Close faile: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }
}

