/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.dto;

import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataBaseInfo {
    private static final Log LOG = LogFactory.getInstance(DataBaseInfo.class);
    private String dbHost;
    private String dbPort;
    private String dbName;
    private String dbaUsername;
    private String dbaPassword;
    private String managerUsername = "";
    private String managerPassword = "";
    private String dbFilePath = "";
    private String dbPath = "";
    private String dbaPasswordConf = "";
    private String managerPwd4InputConf = "";
    private String id;
    private String dbType;
    private String defaultManagerPassword = "";
    private String serverInstallPath;
    private boolean isDbaPwdChanged = false;
    private boolean isManagerPwdChanged = false;

    public DataBaseInfo() {
        this.initDefaultManagerPwd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultManagerPwd() {
        FileInputStream fil = null;
        try {
            String currPath = InstallConstant.getCurrentPath();
            String confFile = currPath + "/config/conf/config.properties";
            Properties property = new Properties();
            fil = new FileInputStream(confFile);
            property.load(fil);
            this.defaultManagerPassword = property.getProperty("default.gauss.mangement.password");
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"InitManagerPwd failed, can not find the config.properties", "");
        }
        catch (IOException e) {
            LOG.info((Object)e, "Get Gs default pwd err. ");
        }
        finally {
            if (fil != null) {
                try {
                    fil.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"FileInputStream close exception.", "");
                }
            }
        }
    }

    public void validate() {
        if (this.isStringEmpty(this.dbHost) || this.isStringEmpty(this.dbPort) || this.isStringEmpty(this.dbaUsername) || this.isStringEmpty(this.dbaPassword)) {
            throw new IllegalArgumentException("invalid params (Empty value)");
        }
        int length = this.dbaUsername.length();
        if (4 > length || 8 < length) {
            throw new IllegalArgumentException("invalid param length: " + length + ", excepted 4~8");
        }
        String usernamePattern = "^[A-Za-z]+$";
        if (!this.isStringValid(this.dbaUsername, usernamePattern)) {
            throw new IllegalArgumentException("invalid dbuserName format, excepted pattern: " + usernamePattern);
        }
        if (!ParamCheck.checkIpAddress(this.dbHost)) {
            throw new IllegalArgumentException("invalid dbhost format");
        }
        int port = Integer.parseInt(this.dbPort);
        if (port <= 0 || 65535 < port) {
            throw new IllegalArgumentException("db port out of range: " + port);
        }
    }

    private boolean isStringValid(String string, String pattern) {
        Pattern pat = Pattern.compile(pattern);
        Matcher mat = pat.matcher(Normalizer.normalize(string, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    private boolean isStringEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    public void clear() {
        this.setDbHost("");
        this.setDbPort("");
        this.setDbName("");
        this.setDbaUsername("");
        this.setDbaPassword("");
        this.setDbaPasswordConf("");
        this.setManagerUsername("");
        this.setManagerPassword("");
        this.setManagerPwd4InputConf("");
        this.setDbFilePath("");
        this.setDbPath("");
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbaUsername() {
        return this.dbaUsername;
    }

    public void setDbaUsername(String dbaUsername) {
        this.dbaUsername = dbaUsername;
    }

    public String getDbaPassword() {
        return this.dbaPassword;
    }

    public void setDbaPassword(String dbaPassword) {
        this.dbaPassword = dbaPassword;
    }

    public String getManagerUsername() {
        return this.managerUsername;
    }

    public void setManagerUsername(String managerUsername) {
        this.managerUsername = managerUsername;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public void setManagerPassword(String managerPassword4Input) {
        this.managerPassword = managerPassword4Input;
    }

    public String getDbFilePath() {
        return this.dbFilePath;
    }

    public void setDbFilePath(String dbFilePath) {
        this.dbFilePath = dbFilePath;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    public String getDbaPasswordConf() {
        return this.dbaPasswordConf;
    }

    public void setDbaPasswordConf(String dbaPasswordConf) {
        this.dbaPasswordConf = dbaPasswordConf;
    }

    public String getManagerPwd4InputConf() {
        return this.managerPwd4InputConf;
    }

    public void setManagerPwd4InputConf(String managerPwd4InputConf) {
        this.managerPwd4InputConf = managerPwd4InputConf;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDefaultManagerPassword() {
        return this.defaultManagerPassword;
    }

    public String getServerInstallPath() {
        return this.serverInstallPath;
    }

    public void setServerInstallPath(String serverInstallPath) {
        this.serverInstallPath = serverInstallPath;
    }

    public boolean isDbaPwdChanged() {
        return this.isDbaPwdChanged;
    }

    public void setDbaPwdChanged(boolean dbaPwdChanged) {
        this.isDbaPwdChanged = dbaPwdChanged;
    }

    public boolean isManagerPwdChanged() {
        return this.isManagerPwdChanged;
    }

    public void setManagerPwdChanged(boolean managerPwdChanged) {
        this.isManagerPwdChanged = managerPwdChanged;
    }
}

