/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.DbScript;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class InitDBTool {
    public static final String CREATE_TABLE = "create-table.properties";
    public static final String CREATE_DB = "create-db.properties";
    public static final String DROP_DB = "drop-db.properties";
    public static final String DROP_TABLE = "drop-table.properties";
    private static final Log LOG = LogFactory.getInstance(InitDBTool.class);
    private static final String GAUSS = "Gauss";

    private static DbScript getPlatformDBInit(DataBaseInfo dbInfo) throws IOException {
        String dbFolder = "";
        if (GAUSS.equalsIgnoreCase(dbInfo.getDbType())) {
            dbFolder = InstallConstant.getsBasePath() + LegoResourceManager.getProValue("install.initdb.gauss");
        }
        DbScript dbinit = new DbScript();
        dbinit.setDataFiles(InitDBTool.getInsertDB(dbFolder));
        dbinit.setTable(InitDBTool.getKeyValueMap(dbFolder + CREATE_TABLE));
        dbinit.setDb(InitDBTool.getKeyValueMap(dbFolder + CREATE_DB));
        return dbinit;
    }

    private static DbScript getPlatformDBUpdate(DataBaseInfo dbInfo, String ptVersion, String dbFolder) throws IOException {
        if (VerifyUtil.isEmpty((String)dbFolder)) {
            dbFolder = InstallConstant.getsBasePath() + LegoResourceManager.getProValue("update.initdb.gauss");
        }
        DbScript dbinit = new DbScript();
        File[] files = InitDBTool.getInsertDB(dbFolder);
        dbinit.setDataFiles(InitDBTool.filterSqlFiles(files, ptVersion));
        dbinit.setTable(InitDBTool.getKeyValueMap(dbFolder + CREATE_TABLE));
        dbinit.setDb(InitDBTool.getKeyValueMap(dbFolder + CREATE_DB));
        return dbinit;
    }

    private static File[] filterSqlFiles(File[] files, String version) {
        File[] newFiles = null;
        ArrayList<File> filesTmp = new ArrayList<File>();
        if (null != files && files.length > 0) {
            for (File file : files) {
                String fileName = file.getName();
                String sqlVersion = fileName.substring(0, fileName.indexOf("_"));
                boolean isNewVersion = InitBundleXmlTool.isNewVersion(version, sqlVersion);
                if (!isNewVersion) continue;
                filesTmp.add(file);
                LOG.info((Object)String.format(Locale.ROOT, "Need Excute SQL File:%s", fileName));
            }
        }
        newFiles = new File[filesTmp.size()];
        for (int i = 0; i < filesTmp.size(); ++i) {
            newFiles[i] = (File)filesTmp.get(i);
        }
        return newFiles;
    }

    private static DbScript getProductDBInit(DataBaseInfo dbInfo, String productPath) throws IOException {
        String dbFolder = "";
        if (GAUSS.equalsIgnoreCase(dbInfo.getDbType())) {
            dbFolder = InstallConstant.getsBasePath() + "Plug-In/" + productPath + "/script/dbscript/install/gauss/";
        }
        DbScript dbinit = new DbScript();
        dbinit.setDataFiles(InitDBTool.getInsertDB(dbFolder));
        dbinit.setTable(InitDBTool.getKeyValueMap(dbFolder + CREATE_TABLE));
        dbinit.setDb(InitDBTool.getKeyValueMap(dbFolder + CREATE_DB));
        return dbinit;
    }

    private static DbScript getProductDBUninstall(DataBaseInfo dbInfor, String productId) throws IOException {
        String dbFolder = "";
        String basePath = PrepareParamUtil.getsInstallDto().getInstallpath();
        if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
            dbFolder = basePath + "/Runtime/bin/script/" + productId + "/dbscript/uninstall/gauss/";
        }
        DbScript dbUninstall = new DbScript();
        dbUninstall.setDataFiles(InitDBTool.getInsertDB(dbFolder));
        dbUninstall.setTable(InitDBTool.getKeyValueMap(dbFolder + DROP_TABLE));
        dbUninstall.setDb(InitDBTool.getKeyValueMap(dbFolder + DROP_DB));
        return dbUninstall;
    }

    private static DbScript getProductDBUpdate(DataBaseInfo dbInfo, String productId, String pdVersion, String dbFolder) throws IOException {
        if (VerifyUtil.isEmpty((String)dbFolder)) {
            dbFolder = InstallConstant.getsBasePath() + "Plug-In/" + productId + "/script/dbscript/update/gauss/";
        }
        DbScript dbinit = new DbScript();
        LOG.info((Object)String.format(Locale.ROOT, "GetProductDBUpdate folder: %s", productId));
        File[] files = InitDBTool.getInsertDB(dbFolder);
        if (files != null) {
            for (File item : files) {
                LOG.info((Object)String.format(Locale.ROOT, "GetProductDBUpdate File=%s", item.getName()));
            }
        }
        dbinit.setDataFiles(InitDBTool.filterSqlFiles(files, pdVersion));
        dbinit.setTable(InitDBTool.getKeyValueMap(dbFolder + CREATE_TABLE));
        dbinit.setDb(InitDBTool.getKeyValueMap(dbFolder + CREATE_DB));
        return dbinit;
    }

    private static boolean isAutoInstall() {
        String basePath = InstallConstant.getsBasePath();
        String confFile = basePath + File.separator + "confd.conf";
        File file = new File(confFile);
        if (!file.exists()) {
            LOG.error((Object)"File not found, is not auto install.", "");
            return false;
        }
        return true;
    }

    public static File[] getInsertDB(String dbFolder) {
        File folder = new File(dbFolder);
        File[] files = folder.listFiles(file -> {
            if (!InitDBTool.isAutoInstall() && "12_lego.sql".equals(file.getName())) {
                LOG.info((Object)"No need add to init sql list, file is 12_lego.sql", "");
                return false;
            }
            return file.getName().endsWith(".sql");
        });
        if (null == files || files.length < 1) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            for (int j = i + 1; j < files.length; ++j) {
                String second;
                String first = files[i].getName().substring(0, files[i].getName().lastIndexOf("_"));
                if (InitBundleXmlTool.isNewVersion(first, second = files[j].getName().substring(0, files[j].getName().lastIndexOf("_")))) continue;
                File tmpFile = files[i];
                files[i] = files[j];
                files[j] = tmpFile;
            }
        }
        return files;
    }

    public static Map<String, String> getKeyValueMap(String fileName) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        BufferedReader reader = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                LOG.error((Object)("Can not find the file: " + file.getName()), "");
                LinkedHashMap<String, String> linkedHashMap = map;
                return linkedHashMap;
            }
            reader = new BufferedReader(new FileReader(fileName));
            String text = null;
            while ((text = FileUtil.getLineFromFile(reader)) != null && text.contains("=")) {
                int firstIndex = text.indexOf("=");
                map.put(text.substring(0, firstIndex), text.substring(firstIndex + 1));
            }
        }
        catch (IOException e) {
            LOG.error((Object)e, "GetKeyValueMap IOException");
            throw e;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e, "GetKeyValueMap  close file IOException");
            }
        }
        return map;
    }

    public static void initPlatformDB(DataBaseInfo dbInfor) throws IOException, SQLException {
        LOG.info((Object)"Begin initPlatformDB", "");
        DbScript dbinit = InitDBTool.getPlatformDBInit(dbInfor);
        InitSQL init = new InitSQL(dbinit);
        try {
            init.fixDB(dbInfor);
            init.fixTable(dbInfor);
            init.fixData(dbInfor);
        }
        catch (IOException e1) {
            LOG.error((Object)("Exception: " + e1), "");
            throw e1;
        }
        catch (SQLException e2) {
            LOG.error((Object)("InitPlatformDB failed, SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
            throw new SQLException("InitPlatformDB failed,");
        }
        LOG.info((Object)"End initPlatformDB", "");
    }

    public static InitSQL getInitSQL(DataBaseInfo dbInfor) throws IOException {
        DbScript dbinit = InitDBTool.getPlatformDBInit(dbInfor);
        return new InitSQL(dbinit);
    }

    public static void updatePlatformDB(DataBaseInfo dbInfor, String ptVersion, String dbFolder, boolean isAutoUpdate) throws IOException, SQLException {
        LOG.info((Object)"Begin updatePlatformDB", "");
        DbScript dbinit = InitDBTool.getPlatformDBUpdate(dbInfor, ptVersion, dbFolder);
        InitSQL init = new InitSQL(dbinit);
        init.fixDB(dbInfor);
        init.fixTable(dbInfor);
        init.fixData(dbInfor);
        InitDBTool.updateSsoRole(dbInfor, isAutoUpdate);
        try {
            InitDBTool.updateColumeSql(dbInfor, "ALTER TABLE if exists ti_protectgroupreplica add column MOUNTEDHOST CHARACTER VARYING(255), add column MOUNTSTATUS INTEGER DEFAULT 4,  add column ACCESSLEVEL INTEGER DEFAULT 1,add column LABEL CHARACTER VARYING(255), add column SOURCEREPLICAID CHARACTER VARYING(255), add column CONSISTENTTYPE INTEGER DEFAULT 1, add column GENERATION INTEGER DEFAULT 1;");
            InitDBTool.updateColumeSql(dbInfor, "ALTER TABLE if exists ti_recoveryplan add column PLANUSE INTEGER DEFAULT 0,add column CREATETIME BIGINT;");
            InitDBTool.updateColumeSql(dbInfor, "ALTER TABLE if exists ti_openstackregion add column CONFIG CHARACTER VARYING(255);");
        }
        catch (Exception e) {
            LOG.error((Object)("Update colume failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        LOG.info((Object)"End updatePlatformDB", "");
    }

    private static void updateSsoRole(DataBaseInfo dbInfor, boolean isAutoUpdate) {
        PreparedStatement stPer;
        PreparedStatement stInsert;
        PreparedStatement stQuery;
        Connection conn;
        block16: {
            String basePath = InstallConstant.getsBasePath();
            String confFile = basePath + File.separator + "upgrade.conf";
            File file = new File(confFile);
            if (!file.exists() && !isAutoUpdate) {
                LOG.info((Object)"Is not auto update, no need insert sso role.", "");
                return;
            }
            conn = null;
            stQuery = null;
            stInsert = null;
            stPer = null;
            conn = LegoDBConnection.getInstance().connectDBWithDba(dbInfor, "LEGO");
            if (null == conn) {
                throw new PatchException("updateSsoRole failed, connection database failed.");
            }
            String querySql = "select ROLE_NAME from T_ROLE where ROLE_NAME='OCAdmin' and ROLE_ID=-1;";
            stQuery = conn.prepareStatement(querySql);
            ResultSet result = stQuery.executeQuery();
            if (!result.next()) break block16;
            LOG.info((Object)"The OCAdmin role is already exists, return.", "");
            InitDBTool.closeStatement(stQuery);
            InitDBTool.closeStatement(stInsert);
            InitDBTool.closeStatement(stPer);
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Close Connection SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
            }
            return;
        }
        try {
            LOG.info((Object)"Start update sso role.", "");
            String insertSql = "insert into T_role values(-1,'11','20100203','OCAdmin','ManageOne O&M Plane Admin Role',1);";
            stInsert = conn.prepareStatement(insertSql);
            stInsert.executeUpdate();
            String persionSql = "with permission as (select * from T_operation_r_role where role_id = 1 and opt_id not in (select opt_id from T_operations where serial_number in ('8000-300','8000-300-10','8000-300-10-5','8000-300-10-10','8000-300-10-20','8000-300-10-15','8000-300-10-25','8000-300-10-30','8000-300-20','8000-300-20-5','8000-300-20-10','8000-300-20-20','8000-300-20-15','8000-300-30','8000-300-30-5','8000-300-30-10','8000-300-50'))) insert into T_operation_r_role(role_id, opt_id) select -1, permission.opt_id from permission;";
            stPer = conn.prepareStatement(persionSql);
            stPer.executeUpdate();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Update sso failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("update sso failed");
            }
            catch (Throwable throwable) {
                InitDBTool.closeStatement(stQuery);
                InitDBTool.closeStatement(stInsert);
                InitDBTool.closeStatement(stPer);
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        LOG.error((Object)("Close Connection SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
                    }
                }
                throw throwable;
            }
        }
        InitDBTool.closeStatement(stQuery);
        InitDBTool.closeStatement(stInsert);
        InitDBTool.closeStatement(stPer);
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Close Connection SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateColumeSql(DataBaseInfo dbInfor, String sql) {
        Connection conn = null;
        PreparedStatement updateSql = null;
        try {
            conn = LegoDBConnection.getInstance().connectDBWithDba(dbInfor, "LEGO");
            if (null == conn) {
                throw new PatchException("updateSsoRole failed, connection database failed.");
            }
            LOG.info((Object)"Start update colume.", "");
            updateSql = conn.prepareStatement(sql);
            updateSql.executeUpdate();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Update colume sql failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            catch (Throwable throwable) {
                InitDBTool.closeStatement(updateSql);
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        LOG.error((Object)("Close Connection SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
                    }
                }
                throw throwable;
            }
            InitDBTool.closeStatement(updateSql);
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e3) {
                    LOG.error((Object)("Close Connection SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e3)), "");
                }
            }
        }
        InitDBTool.closeStatement(updateSql);
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Close Connection SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    private static void closeStatement(PreparedStatement st) {
        if (null != st) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Close Statement SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static void initProductDB(DataBaseInfo dbInfor, String productPath) throws IOException, SQLException {
        LOG.info((Object)"Begin initProductDB", "");
        DbScript dbinit = InitDBTool.getProductDBInit(dbInfor, productPath);
        InitSQL init = new InitSQL(dbinit);
        init.fixDB(dbInfor);
        init.fixTable(dbInfor);
        init.fixData(dbInfor);
        LOG.info((Object)"End initProductDB", "");
    }

    public static void updateProductDB(DataBaseInfo dbInfor, String productPath, String pdVersion, String dbFolder) throws IOException, SQLException {
        LOG.info((Object)String.format(Locale.ROOT, "Begin updateProductDB ; pdVersion=%s", pdVersion));
        DbScript dbinit = InitDBTool.getProductDBUpdate(dbInfor, productPath, pdVersion, dbFolder);
        InitSQL init = new InitSQL(dbinit);
        init.fixDB(dbInfor);
        init.fixTable(dbInfor);
        init.fixData(dbInfor);
        LOG.info((Object)String.format(Locale.ROOT, "End updateProductDB, pdVersion=%s", pdVersion));
    }

    public static void uninstallProductDB(DataBaseInfo dbInfor, String productId) throws IOException, SQLException {
        DbScript dbUninstall = InitDBTool.getProductDBUninstall(dbInfor, productId);
        InitSQL init = new InitSQL(dbUninstall);
        init.dropDB(dbInfor);
        init.dropTable(dbInfor);
        init.fixData(dbInfor);
    }
}

