/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;

public class LegoDBConnection {
    private static final Log LOG = LogFactory.getInstance(LegoDBConnection.class);
    private static LegoDBConnection sInstance = null;
    private static final String JDBC_URL = "jdbc:postgresql://%s:%d/%s";

    public static LegoDBConnection getInstance() {
        if (sInstance == null) {
            sInstance = new LegoDBConnection();
        }
        return sInstance;
    }

    public Connection connectDBWithManager(DataBaseInfo dbInfo) {
        return this.connectDBWithCompatible(dbInfo, "postgres", dbInfo.getManagerUsername(), dbInfo.getManagerPassword());
    }

    public Connection connectDBWithDba(DataBaseInfo dbInfo, String dbName, boolean enableSSL) {
        return this.getConnectDB(dbInfo, dbName, dbInfo.getDbaUsername(), dbInfo.getDbaPassword(), enableSSL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dbExist(DataBaseInfo dbInfo, String dbName) {
        try (Connection conn = this.connectDBWithDba(dbInfo, dbName);){
            boolean bl = conn != null;
            return bl;
        }
        catch (SQLException e) {
            LOG.error((Object)String.format(Locale.ROOT, "Check connection Error: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
    }

    private Connection connectDB(String url, String dbUser, String pwd) {
        Connection connection = null;
        try {
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(url, dbUser, pwd);
            LOG.info((Object)"Get db connection success.");
        }
        catch (ClassNotFoundException | SQLException e) {
            LOG.error((Object)String.format(Locale.ROOT, "Connect db %s failed.", url));
            LOG.error((Object)String.format(Locale.ROOT, "DB connect Failed. error: %s", ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5003A");
        }
        return connection;
    }

    public Connection connectDBWithDba(DataBaseInfo dbInfo, String dbName) {
        return this.connectDBWithCompatible(dbInfo, dbName, dbInfo.getDbaUsername(), dbInfo.getDbaPassword());
    }

    private Connection connectDBWithCompatible(DataBaseInfo dbInfo, String dbName, String dbaUsename, String dbaPwd) {
        Connection connection = this.getConnectDB(dbInfo, dbName, dbaUsename, dbaPwd, true);
        if (connection != null) {
            return connection;
        }
        return this.getConnectDB(dbInfo, dbName, dbaUsename, dbaPwd, false);
    }

    private Connection getConnectDB(DataBaseInfo dbInfo, String dbName, String dbaUsename, String dbapwd, boolean enableSSL) {
        int port = Integer.parseInt(dbInfo.getDbPort());
        String url = String.format(Locale.ROOT, JDBC_URL, dbInfo.getDbHost(), port, dbName);
        if (enableSSL) {
            url = url + "?ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory";
        }
        return this.connectDB(url, dbaUsename, dbapwd);
    }
}

