/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UninstallDBTool {
    private static final Log LOG = LogFactory.getInstance(UninstallDBTool.class);
    private static final String GAUSS = "Gauss";

    public static void uninstallDB(DataBaseInfo dbInfor, String savePath) throws IOException, SQLException {
        Connection conn = null;
        String uninstallFile = "";
        try {
            if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                uninstallFile = savePath + "/" + LegoResourceManager.getProValue("install.uninstalldb.target") + "/gauss/drop-lego.sql";
                conn = LegoDBConnection.getInstance().connectDBWithManager(dbInfor);
            }
            if (null == conn) {
                LOG.info((Object)"Connection is null ,no need to fix database", "");
                return;
            }
            List<String> sqls = UninstallDBTool.getSqlList(uninstallFile);
            int count = 0;
            for (String sql : sqls) {
                if (sql.trim().length() <= 0) continue;
                UninstallDBTool.dealDB(sql, count, conn);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "UninstallDB SQL Error");
            throw new SQLException();
        }
        finally {
            UninstallDBTool.closeConnAndPStatement(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dealDB(String sql, int count, Connection conn) throws SQLException {
        PreparedStatement pst = null;
        try {
            LOG.info((Object)String.format(Locale.ROOT, "DealDB, Count:%s", count++));
            if (null != conn) {
                pst = UninstallDBTool.getPreparedStatement(sql.trim(), conn);
            }
            if (null != pst) {
                pst.execute();
            }
        }
        catch (Throwable throwable) {
            UninstallDBTool.closeRes(pst);
            throw throwable;
        }
        UninstallDBTool.closeRes(pst);
    }

    private static PreparedStatement getPreparedStatement(String dropSql, Connection conn) throws SQLException {
        return conn.prepareStatement(dropSql);
    }

    private static void closeRes(PreparedStatement pst) {
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("PreparedStatement close SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    private static void closeConnAndPStatement(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Connection close SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getSqlList(String fileName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String text = null;
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                list.add(text);
            }
        }
        catch (FileNotFoundException e) {
            try {
                LOG.error((Object)("GetSqlList error, file not found: " + new File(fileName).getName()), "");
                throw new InstallException("File not found.");
                catch (IOException e2) {
                    LOG.error((Object)e2, "GetSqlList error");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                UninstallDBTool.closeReader(reader);
                throw throwable;
            }
        }
        UninstallDBTool.closeReader(reader);
        return list;
    }

    private static void closeReader(BufferedReader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"BufferedReader close IOException", (Throwable)e, "");
        }
    }
}

