/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.install.autodeploy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.huawei.cipher.FileSignHandler;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.utils.RandomUtil;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.signer.LogManager;
import com.huawei.util.ExceptionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class GenerateCert {
    private static final Log LOG = LogFactory.getInstance(GenerateCert.class);
    private static final String DRMANAGER_PASSWORD = "DRManager.password";
    private static final String KMC_CONF_PATH = "/Runtime/LegoRuntime/conf/wcc/";
    private static final String LEGO_PROPERTIES_PATH = "/Runtime/LegoRuntime/conf/lego.properties";
    private static final String CMD_STRING = "/generateCert.sh gencert ";
    private static final Map<String, Set<String>> PROPERTIES_REPLACE_KV_LIST = ImmutableMap.of((Object)"/Runtime/LegoRuntime/conf/lego.properties", (Object)ImmutableSet.of((Object)"keyStore", (Object)"arb.privatepwd", (Object)"nginx.keypass", (Object)"internal.keypass"), (Object)"/ha/conf/local/ha.properties", (Object)ImmutableSet.of((Object)"cert.password"), (Object)"/config/conf/config.properties", (Object)ImmutableSet.of((Object)"cert.invoke.pwd"), (Object)"/Runtime/NodeAgent/conf/nodeAgent-pwd.properties", (Object)ImmutableSet.of((Object)"keystorePass", (Object)"keyPass"));
    private static final Map<String, Pair<List<String>, Set<String>>> XML_REPLACE_KV_LIST = ImmutableMap.of((Object)"/PlatFrom/PlatForm_Front/Tomcat6/conf/server.xml", (Object)Pair.of((Object)ImmutableList.of((Object)"Service", (Object)"Connector"), (Object)ImmutableSet.of((Object)"keystorePass", (Object)"keyPass")));
    private static final Set<String> RESIGN_FILE_LIST = ImmutableSet.of((Object)"/config/conf/config.properties");

    public static void main(String[] args) {
        String keystorePwd;
        String drmPwd;
        String currPath = InstallConstant.getsBasePath();
        try {
            KmcInstance.initComponent((String)(currPath + KMC_CONF_PATH), (boolean)true);
            String randomKeystorePwd = RandomUtil.getRandomPassword();
            String encryptRandomKeystorePwd = KmcInstance.encrypt((String)randomKeystorePwd);
            GenerateCert.replacePwd(currPath, encryptRandomKeystorePwd);
            GenerateCert.resignFile(currPath);
            String encryptDrmPwd = LegoConfig.getInstance((String)(currPath + LEGO_PROPERTIES_PATH)).getKeyValue(DRMANAGER_PASSWORD);
            drmPwd = KmcInstance.decrypt((String)encryptDrmPwd);
            keystorePwd = randomKeystorePwd;
        }
        catch (AppException | NoSuchAlgorithmException ex) {
            LOG.error((Object)"[GenerateCert]Failed to decrypt the password.");
            throw new InstallException("[GenerateCert]Failed to decrypt the password.");
        }
        String standByIp = args[0];
        if (!VerifyUtil.isEmpty((String)standByIp) && !ParamCheck.checkIpAddress(standByIp)) {
            LOG.error((Object)"The IP address(%s) of the standby node is abnormal.", standByIp);
            throw new InstallException("Invalid IP address.");
        }
        String generateCertShell = currPath + CMD_STRING + args[0];
        if (!CmdUtil.execStrCmd(generateCertShell, new String[]{keystorePwd, drmPwd})) {
            LOG.error((Object)"Failed to execute the certificate generation script.");
            throw new InstallException("Failed to execute the certificate generation script.");
        }
        System.exit(0);
    }

    private static void replacePwd(String currPath, String encryptPwd) {
        PROPERTIES_REPLACE_KV_LIST.forEach((filePath, configKeySet) -> {
            LegoConfig instance = LegoConfig.getInstance((String)(currPath + filePath));
            configKeySet.forEach(configKey -> instance.setConfigValue(configKey, encryptPwd, Boolean.TRUE.booleanValue()));
        });
        XML_REPLACE_KV_LIST.forEach((filePath, nodesAndKeysPair) -> GenerateCert.updateXmlFile(currPath + filePath, (List)nodesAndKeysPair.getKey(), (Set)nodesAndKeysPair.getValue(), encryptPwd));
    }

    private static void resignFile(String currPath) {
        RESIGN_FILE_LIST.forEach(filePath -> FileSignHandler.signFile((String)(currPath + filePath)));
    }

    private static void updateXmlFile(String xmlFile, List<String> nodes, Set<String> keys, String value) {
        File xml = new File(FilenameUtils.normalize((String)xmlFile));
        if (!xml.exists()) {
            LOG.error((Object)"[GenerateCert]XmlFile is not exists.");
            throw new InstallException("XmlFile is not exists");
        }
        FileOutputStream fout = null;
        XMLWriter writer = null;
        SAXReader reader = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xml);
            Node currentNode = document.node(0);
            for (String string : nodes) {
                List element = currentNode.selectNodes(string);
                if (VerifyUtil.isEmpty((Collection)element)) {
                    LOG.error((Object)"[GenerateCert]element is empty.");
                    throw new InstallException("Element is empty");
                }
                currentNode = (Node)element.get(0);
            }
            if (!(currentNode instanceof Element)) {
                LOG.error((Object)"[GenerateCert]node is not instanceof element.");
                throw new InstallException("Node is not instanceof element.");
            }
            Element element = (Element)currentNode;
            for (String key : keys) {
                Attribute attribute = element.attribute(key);
                if (attribute == null) {
                    LOG.error((Object)"[GenerateCert]attribute is empty.");
                    throw new InstallException("Attribute is empty");
                }
                attribute.setData((Object)value);
            }
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            fout = new FileOutputStream(xmlFile);
            writer = new XMLWriter((OutputStream)fout, outputFormat);
            writer.write(document);
        }
        catch (Exception e) {
            try {
                LOG.error((Object)String.format(Locale.ROOT, "Update xmlFile failed, exception: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new InstallException("Update xmlFile failed");
            }
            catch (Throwable throwable) {
                GenerateCert.closeOutStream(fout, writer);
                throw throwable;
            }
        }
        GenerateCert.closeOutStream(fout, writer);
    }

    private static void closeOutStream(FileOutputStream out, XMLWriter writer) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                LogManager.error((Object)"close out stream failed.");
            }
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LogManager.error((Object)"close writer  failed.");
            }
        }
    }
}

