/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.nginx;

import com.huawei.ism.drm.wcc.util.WccHelper;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;

class StartNginx {
    private static final Log LOG = LogFactory.getInstance(StartNginx.class);
    private static final String INSTALL_PATH = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
    private static final String LEGO_PROPERTIES = Paths.get(INSTALL_PATH, "Runtime", "LegoRuntime", "conf", "lego.properties").toString();
    private static final String CIPHER_TYPE_KEY = "cipher.type";
    private static final String KEYPASS_KEY = "nginx.keypass";
    private static final String NGINX_HOME = Paths.get(INSTALL_PATH, "Runtime", "nginx").toString();
    private static final String NGINX_EXE = Paths.get(NGINX_HOME, "sbin", "nginx").toString();
    private static final File SCRIPT_LOG_FILE = Paths.get(INSTALL_PATH, "Runtime", "bin", "logs", "nginx_ctl.log").toFile();
    private static final String BUSINESS_USER_NAME = "ICUser";

    StartNginx() {
    }

    public static void main(String[] args) {
        int keyCount;
        PropertyUtil propertyUtil = new PropertyUtil(LEGO_PROPERTIES);
        switch (propertyUtil.getValue(CIPHER_TYPE_KEY)) {
            case "SMCompatible": {
                keyCount = 3;
                break;
            }
            case "SMOnly": {
                keyCount = 2;
                break;
            }
            default: {
                keyCount = 1;
            }
        }
        String keypass = null;
        try {
            keypass = WccHelper.getInstance().decrypt(propertyUtil.getValue(KEYPASS_KEY));
        }
        catch (IOException e) {
            LOG.error((Object)"Get keypass from config file failed.", (Throwable)e);
            SystemExitUtil.exitFail();
        }
        if (VerifyUtil.isEmpty((String)keypass)) {
            LOG.error((Object)"Get or decrypt keypass failed.");
            SystemExitUtil.exitFail();
        }
        if (!StartNginx.startProcess(keyCount, keypass)) {
            SystemExitUtil.exitFail();
        }
        SystemExitUtil.exitOK();
    }

    private static boolean startProcess(int keyCount, String keypass) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (BUSINESS_USER_NAME.equals(System.getProperty("user.name"))) {
            processBuilder.command(NGINX_EXE, "-p", NGINX_HOME);
        } else {
            processBuilder.command("su", BUSINESS_USER_NAME, "-s", "/bin/bash", "-c", NGINX_EXE + " -p " + NGINX_HOME);
        }
        processBuilder.redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.appendTo(SCRIPT_LOG_FILE));
        Process process = null;
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            LOG.error((Object)"Start Nginx process failed.", (Throwable)e);
            return false;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));){
            for (int i = 0; i < keyCount; ++i) {
                writer.write(keypass);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            LOG.error((Object)"Write keypass to Nginx process failed.", (Throwable)e);
            return false;
        }
        try {
            return process.waitFor(10L, TimeUnit.SECONDS) && process.exitValue() == 0;
        }
        catch (IllegalThreadStateException | InterruptedException e) {
            LOG.error((Object)"Nginx start process is interrupted.", (Throwable)e);
            return false;
        }
    }
}

