/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update;

import com.huawei.drm.install.common.check.VersionCheck;
import com.huawei.drm.install.common.util.InstallBuffer;
import com.huawei.lego.cli.climain.CliMain;
import com.huawei.lego.cli.update.NeedInstallBundles;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.ha.HAInfo;
import com.huawei.lego.common.upgrade.Upgrade;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.NetWorkUtil;
import com.huawei.lego.common.util.PortCheckUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutoUpdate {
    private static final Log LOGGER = LogFactory.getInstance(AutoUpdate.class);
    private static boolean isGreenGauss = Boolean.parseBoolean(LegoResourceManager.getProValue("isGreenGauss"));
    private boolean updateSystem = false;

    public boolean isUpdateSystem() {
        return this.updateSystem;
    }

    public void setUpdateSystem(boolean updateSystem) {
        this.updateSystem = updateSystem;
    }

    public static void main(String[] args) throws InterruptedException {
        if (args.length == 1 && args[0].equals("BackUp")) {
            Upgrade upgradeProcess = new Upgrade(false);
            upgradeProcess.reNameOldFile();
            return;
        }
        String productDbaPwd = "";
        if (InitBundleXmlTool.getDBType().equals("Gauss") && isGreenGauss && args.length > 1) {
            productDbaPwd = args[1];
        }
        AutoUpdate.initSystemInfo();
        String preVersion = VersionCheck.getInstance().getPreVersion();
        LOGGER.info((Object)String.format(Locale.ROOT, "PreVersion = %s", preVersion), "0x000252000FB5001E");
        if (null == preVersion) {
            LOGGER.info((Object)"Update failed, preVersion can't get.", "0x000252000FB5001E");
            return;
        }
        InstallBuffer.getInstance().addBuffer("preVersion", preVersion);
        AutoUpdate.initEnv(args[0], productDbaPwd);
        AutoUpdate.checkSystemBeforeStartUp();
        LOGGER.info((Object)"Start update", "");
        AutoUpdate.legoUpdate();
    }

    private static void initSystemInfo() {
        try {
            InitInstalledXmlTool.initSystemInfo();
        }
        catch (InstallException e) {
            SystemPrint.systemPrintStr(e.getErrorMsg());
            SystemExitUtil.exitFail();
        }
    }

    private static void initEnv(String dbPwd, String productPwd) {
        String productPwdDecode;
        String dbPwdDecode = WccEncryptor.retryDecode(dbPwd);
        if (!"".equals(dbPwdDecode)) {
            dbPwd = dbPwdDecode;
        }
        if (!"".equals(productPwdDecode = WccEncryptor.retryDecode(productPwd))) {
            productPwd = productPwdDecode;
        }
        PrepareParamUtil.initEnv(dbPwd, productPwd);
    }

    private static void legoUpdate() {
        try {
            Upgrade upgradeProcess = new Upgrade(false);
            upgradeProcess.process();
            LOGGER.info((Object)"Installation is completed.\n\n*************Update Succeed!*************\n\n", "");
            SystemExitUtil.exitOK();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Update failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
    }

    private static void checkSystemBeforeStartUp() {
        if (!(null != NeedInstallBundles.PLATFORM_BUNDLES && NeedInstallBundles.PLATFORM_BUNDLES.size() >= 1 || null != NeedInstallBundles.PRODUCT_BUNDLES && NeedInstallBundles.PRODUCT_BUNDLES.size() >= 1)) {
            SystemPrint.systemPrintStr("The version of the upgrade package is identical to or lower than the current version, so the system can not upgrade.");
            LOGGER.info((Object)"The version of the upgrade package is identical to or lower than the current version, so the system can not upgrade.", "");
            PrepareParamUtil.exitFail(1);
        }
        AutoUpdate.checkSystemRunning();
        if (!AutoUpdate.checkPathChar()) {
            LOGGER.error((Object)LegoResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.CHAR"), "");
            PrepareParamUtil.exitFail(1);
        }
        if (NetWorkUtil.getLocalAllIps().isEmpty()) {
            LOGGER.error((Object)LegoResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.NOIP"), "");
            PrepareParamUtil.exitFail(1);
        }
        AutoUpdate.checkUpgradeIpAddress();
    }

    private static void checkUpgradeIpAddress() {
        LOGGER.info((Object)"Start check upgrade ip address.");
        HAInfo haInfo = HAInfo.getHAInfo();
        if (!haInfo.isSingleHA()) {
            LOGGER.info((Object)String.format(Locale.ROOT, "Current mode:%s, no need check ip, return.", haInfo.getCurrentType()));
            return;
        }
        List<String> items = NetWorkUtil.getLocalAllIps();
        String oldy = InitInstalledXmlTool.getInstalledSystem().getNetWorkPanel().getWorkMangIp();
        for (String item : items) {
            if (item == null || !item.equals(oldy)) continue;
            return;
        }
        LOGGER.error((Object)LegoResourceManager.getString("LEGO.CHANGED.CONFIG.IP"), "");
        PrepareParamUtil.exitFail(1);
    }

    private static void checkSystemRunning() {
        int portNumber = PortCheckUtil.checkSystemUsing();
        if (-1 != portNumber) {
            LOGGER.error((Object)LegoResourceManager.getString("start.err.10001"), "");
            PrepareParamUtil.exitFail(-1);
        }
    }

    private static boolean checkPathChar() {
        String[] folderNames;
        String checkPath = AutoUpdate.getAbsPath();
        if (null != System.getProperty("os.name") && !System.getProperty("os.name").isEmpty() && System.getProperty("os.name").contains("Windows")) {
            String unRootPath = checkPath.replace("\\", "/");
            unRootPath = unRootPath.substring(checkPath.indexOf(":/") + 2);
            folderNames = unRootPath.split("/");
        } else {
            folderNames = checkPath.split("/");
        }
        for (String folder : folderNames) {
            boolean flag1;
            if (folder.length() == 0) continue;
            Pattern pattern = Pattern.compile("^[\\u4e00-\\u9fa5\\w-\\s*.]+$");
            Matcher matcher = pattern.matcher(Normalizer.normalize(folder, Normalizer.Form.NFKC));
            boolean flag = matcher.matches();
            boolean bl = flag1 = folder.indexOf("  ") == -1;
            if (flag && flag1) continue;
            return false;
        }
        return true;
    }

    private static String getAbsPath() {
        String jarPath = CliMain.class.getProtectionDomain().getCodeSource().getLocation().toString();
        try {
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("Decode error :" + e.getMessage()), "");
        }
        String basePath = "";
        if (-1 != jarPath.indexOf(":") && null != System.getProperty("os.name") && !System.getProperty("os.name").isEmpty() && System.getProperty("os.name").contains("Windows")) {
            basePath = jarPath.substring(jarPath.indexOf("/") + 1, jarPath.lastIndexOf("/"));
            basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
        } else {
            basePath = jarPath.substring(jarPath.indexOf("/"), jarPath.lastIndexOf("/"));
            basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
        }
        return basePath;
    }
}

