/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileEncryptor;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ConfigDataBackup {
    private static final Log LOG = LogFactory.getInstance(ConfigDataBackup.class);
    private static final String LINUX_DMP = "/usr/local/gaussdb/bin/gs_dump";
    private static final String SALTFILE = "zip1.tmp";
    private static final String IVFILE = "zip2.tmp";
    private static final String SQL_FILE = "lego.sql";
    private static final String DATAFILE = "data.zip";
    private static final String WCC_FILE = "wcc.conf";
    private static final String WCC_HW_FILE = "wcc-hw.conf";
    private static final String BUNDLEFILE = "bundle.info";
    private static final String SP = File.separator;
    private static final String INSTALL_PATH = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
    private static final String LEGO_PROPERTIES = INSTALL_PATH + File.separator + "Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "lego.properties";
    private static final String DEFAULT_ENCRYPT_PASSWORD_KEY = "config.backup.encrypt.password.default";
    private static final Pattern PATTERN = Pattern.compile("/home/ICUser/FCDConfigData(-\\d{8}_\\d{6})?\\.zip");
    private static Map<String, String> installData = null;

    public static void backupData(String destFile, String encryptPwd) {
        String dstParent = new File(FilenameUtils.normalize((String)destFile)).getParent();
        String sqlFile = dstParent + File.separator + SQL_FILE;
        File zipFile = null;
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            ConfigDataBackup.exportData(sqlFile);
            zipFile = FileUtil.zipFile(new File(sqlFile));
            String ivFile = dstParent + SP + IVFILE;
            String saltFile = dstParent + SP + SALTFILE;
            FileEncryptor.encryptFileAccordingCipher(encryptPwd, zipFile, ivFile, saltFile, DATAFILE);
            fileList.add(DATAFILE);
            fileList.add(IVFILE);
            fileList.add(SALTFILE);
            LOG.info((Object)"Start export wcc.", "");
            ConfigDataBackup.exportKey(dstParent, encryptPwd);
            fileList.add(WCC_FILE);
            fileList.add(WCC_HW_FILE);
            LOG.info((Object)"Start export bundle version info.", "");
            String bundleFile = dstParent + SP + BUNDLEFILE;
            FileUtil.writeFile(bundleFile, ConfigDataBackup.getInstallInfo().get("bundleVersion"));
            fileList.add(BUNDLEFILE);
            FileUtil.zipFile(fileList, dstParent, destFile, false);
        }
        catch (Exception e) {
            LOG.error((Object)("Back data failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("back data failed");
        }
        finally {
            File[] files;
            File file = new File(sqlFile);
            if (file.exists()) {
                file.delete();
            }
            if (null != zipFile && zipFile.exists()) {
                zipFile.delete();
            }
            for (File tmpFile : files = new File(dstParent).listFiles()) {
                if (!fileList.contains(tmpFile.getName())) continue;
                tmpFile.delete();
            }
        }
    }

    private static String getEncryptPwd() throws IOException {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Register postgresql driver failed.", "");
            return CertificateUtil.getPasswordFromConfig(LEGO_PROPERTIES, DEFAULT_ENCRYPT_PASSWORD_KEY);
        }
        return ConfigDataBackup.getEncryptPwdFromDb();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getEncryptPwdFromDb() throws IOException {
        DataBaseInfo dataBaseInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        String querySql = "SELECT DATAPASSWORD FROM TI_FTPSERVERINFO LIMIT 1;";
        try (Connection conn = LegoDBConnection.getInstance().connectDBWithDba(dataBaseInfo, "LEGO");
             PreparedStatement preparedStatement = conn.prepareStatement(querySql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) return CertificateUtil.getPasswordFromConfig(LEGO_PROPERTIES, DEFAULT_ENCRYPT_PASSWORD_KEY);
            String ftpDataPwd = resultSet.getString(1);
            String string = WccEncryptor.decode(ftpDataPwd);
            return string;
        }
        catch (SQLException e) {
            LOG.error((Object)("Execute query failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return CertificateUtil.getPasswordFromConfig(LEGO_PROPERTIES, DEFAULT_ENCRYPT_PASSWORD_KEY);
    }

    private static void exportData(String sqlFile) {
        sqlFile = FilenameUtils.normalize((String)sqlFile);
        Map<String, String> data = ConfigDataBackup.getInstallInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append(LINUX_DMP);
        buffer.append(" -h 127.0.0.1");
        buffer.append(" -U " + data.get("dbUser"));
        buffer.append(" -p " + data.get("dbPort"));
        buffer.append(" -Eutf8 ");
        buffer.append(" --pg-format ");
        buffer.append(" LEGO ");
        buffer.append(" -f ");
        buffer.append(sqlFile);
        LOG.info((Object)"start config system data.", "");
        if (!CmdUtil.execStrCmd(buffer.toString(), new String[]{data.get("dbPwd")})) {
            throw new PatchException("export data failed.");
        }
        if (!new File(sqlFile).exists()) {
            throw new PatchException("export data failed, dest file not found.");
        }
    }

    private static void exportKey(String path, String encryptPwd) {
        ConfigDataBackup.getInstallInfo();
        try {
            KmcInstance.getSoftInstance().exportMkFile(path + SP + WCC_FILE, encryptPwd.getBytes(StandardCharsets.UTF_8));
            KmcInstance.getHwInstance().exportMkFile(path + SP + WCC_HW_FILE, encryptPwd.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOG.error((Object)"Export kmc ks file error. Exception:%s", ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private static Map<String, String> getInstallInfo() {
        if (null != installData) {
            return installData;
        }
        File file = new File(OSInformation.getInstalledFile());
        if (!file.exists()) {
            throw new PatchException("can not find the RDInstalled.xml");
        }
        installData = new HashMap<String, String>();
        try {
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List pathList = document.selectNodes("/install/installpath");
            if (null != pathList && !pathList.isEmpty()) {
                Element ele = (Element)pathList.get(0);
                installData.put("installPath", ele.attributeValue("path"));
            }
            DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            installData.put("dbPort", dbInfo.getDbPort());
            installData.put("dbUser", dbInfo.getDbaUsername());
            installData.put("dbPwd", dbInfo.getDbaPassword());
            StringBuilder data = new StringBuilder();
            String lineSp = System.getProperty("line.separator");
            List bundle = document.selectNodes("/install/platform");
            for (Object obj : bundle) {
                Element el = (Element)obj;
                data.append(el.attribute("id").getValue() + "=" + el.attribute("version").getValue() + lineSp);
            }
            List proBundle = document.selectNodes("/install/product");
            for (Object obj : proBundle) {
                Element el = (Element)obj;
                data.append(el.attribute("id").getValue() + "=" + el.attribute("version").getValue() + lineSp);
            }
            installData.put("bundleVersion", data.toString());
        }
        catch (Exception e) {
            LOG.error((Object)("GetInstallInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("getInstallInfo failed");
        }
        return installData;
    }

    public static void main(String[] args) {
        String destPath;
        File path;
        if (args.length != 1 || !ConfigDataBackup.checkFilePath(args[0])) {
            LOG.error((Object)"Config data failed, param error.", "");
            SystemExitUtil.exitFail();
        }
        if (!(path = new File(FilenameUtils.normalize((String)(destPath = new File(args[0]).getParent())))).exists() && !path.mkdirs()) {
            LOG.info((Object)"Config data path error.", "");
            SystemExitUtil.exitFail();
        }
        try (Scanner scanner = new Scanner(System.in);){
            String encryptPwd = scanner.nextLine();
            if (VerifyUtil.isEmpty((String)encryptPwd)) {
                encryptPwd = ConfigDataBackup.getEncryptPwd();
            }
            ConfigDataBackup.backupData(args[0], encryptPwd);
            LOG.info((Object)"Config data backup successfully.", "");
        }
        catch (Exception e) {
            LOG.error((Object)("Backup config data failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
        SystemExitUtil.exitOK();
    }

    private static boolean checkFilePath(String filePath) {
        return PATTERN.matcher(filePath).matches();
    }
}

