/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.user;

import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UserManager {
    private static final Log LOG = LogFactory.getInstance(UserManager.class);

    public static void main(String[] args) {
        String userName;
        if (args.length < 1) {
            LOG.error((Object)("Args length is: " + args.length), "");
            SystemExitUtil.exitFail();
        }
        if (!UserManager.checkUserName(userName = args[0])) {
            LOG.error((Object)"Param format is error.", "");
            SystemExitUtil.exitFail();
        }
        if (UserManager.createUser(userName)) {
            SystemExitUtil.exitOK();
        }
        SystemExitUtil.exitFail();
    }

    private static boolean checkUserName(String userName) {
        Pattern pattern = Pattern.compile("^[a-zA-Z]{4,10}$");
        Matcher matcher = pattern.matcher(Normalizer.normalize(userName, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    private static boolean createUser(String userName) {
        String pwd = null;
        try {
            pwd = WccEncryptor.decode(UserManager.getUserEncryptPwd(userName));
            if (pwd == null || "".equals(pwd)) {
                LOG.error((Object)"Get user pwd failed.", "");
                boolean bl = false;
                return bl;
            }
            if (!CmdUtil.execStrCmd(UserManager.getCreatCmd(userName))) {
                LOG.error((Object)"Create user failed.");
                boolean bl = false;
                return bl;
            }
            if (CmdUtil.execStrCmd(UserManager.setPwdCmd(userName), new String[]{pwd, pwd})) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format(Locale.ROOT, "Set user pwd failed: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            SecurityUtil.sensitiveClean((String)pwd);
        }
        return false;
    }

    private static String getUserEncryptPwd(String userName) {
        if (StringUtils.equals((CharSequence)"DRManager", (CharSequence)userName)) {
            return LegoResourceManager.getProValue("linux.user.pwd");
        }
        return LegoResourceManager.getProValue("linux.om.user.pwd");
    }

    private static String getCreatCmd(String userName) {
        return String.format(Locale.ROOT, "useradd %s -m", userName);
    }

    private static String setPwdCmd(String userName) {
        return String.format(Locale.ROOT, "passwd %s", userName);
    }
}

