/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;

public class ArbImportCert {
    private static final Log LOG = LogFactory.getInstance(ArbImportCert.class);
    private static final String ALAIS_NAME = "arb";
    private static final String KEYSTORE_TYPE = "JKS";

    public static void main(String[] args) {
        if (args.length != 3) {
            LOG.error((Object)"The param is error.");
            SystemExitUtil.exitFail();
        }
        try {
            String keystorePwd = WccEncryptor.decode(args[1]);
            if (VerifyUtil.isEmpty((String)keystorePwd)) {
                LOG.error((Object)"Decrypt arb pwd failed.");
                throw new PatchException("get keystore password failed.");
            }
            CertificateUtil certUtil = new CertificateUtil(args[2], keystorePwd, KEYSTORE_TYPE);
            certUtil.importCertToKeystore(ALAIS_NAME, args[0], Boolean.TRUE);
            SystemExitUtil.exitOK();
        }
        catch (Exception e) {
            LOG.error((Object)("Hand arb cert failed, errmsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
    }
}

