/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BackupDetail {
    private static final Log LOG = LogFactory.getInstance(BackupDetail.class);
    private Long timestamp;
    private List<String> fileset;
    private Map<String, String> configs;

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public List<String> getFileset() {
        return this.fileset;
    }

    public void setFileset(List<String> fileset) {
        this.fileset = fileset;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, String> configs) {
        this.configs = configs;
    }

    public static String getBackupFileName(String file, long timestamp) {
        return file + ".bak." + timestamp;
    }

    public static String getLastBackupFile(String file) {
        Path path = Paths.get(file, new String[0]);
        Path base = path.getParent();
        String name = path.getFileName().toString();
        File[] backups = base.toFile().listFiles(obj -> obj.getName().startsWith(name + ".bak."));
        if (backups == null || backups.length == 0) {
            throw SystemExitUtil.failed("no backup file for " + name);
        }
        List timestamps = Stream.of(backups).map(backup -> backup.toString().split("\\.bak\\.")).map(obj -> obj[((String[])obj).length - 1]).filter(Pattern.compile("^\\d+$").asPredicate()).map(BackupDetail::parseTimestamp).filter(Objects::nonNull).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        if (timestamps.isEmpty()) {
            throw SystemExitUtil.failed("no valid backup file for " + name);
        }
        return file + ".bak." + timestamps.get(0);
    }

    private static Long parseTimestamp(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Invalid timestamp number: " + str));
            return null;
        }
    }

    public static BackupDetail loadBackupDetail(String path) {
        String backup = BackupDetail.getLastBackupFile(path);
        BackupDetail detail = (BackupDetail)JSONObject.toBean((String)FileUtil.readAll(backup), BackupDetail.class);
        if (detail.timestamp == null || !backup.endsWith("." + detail.timestamp)) {
            return null;
        }
        return detail;
    }
}

