/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.ism.drm.wcc.util.WccHelper;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class CertificateUtil {
    private static final Log LOG = LogFactory.getInstance(CertificateUtil.class);
    private KeyStore ks;
    private String keystoreFile;
    private String keystorePass;

    public CertificateUtil(String keyStoreFile, String pwd, String keyStoreType) {
        this.keystoreFile = FilenameUtils.normalize((String)keyStoreFile);
        this.keystorePass = pwd;
        this.initCertificate(keyStoreFile, pwd, keyStoreType);
    }

    private void setKs(KeyStore ks) {
        this.ks = ks;
    }

    private void initCertificate(String keyStoreFile, String pwd, String keyStoreType) {
        FileInputStream in = null;
        try {
            keyStoreFile = FilenameUtils.normalize((String)keyStoreFile);
            File file = new File(keyStoreFile);
            if (!file.exists()) {
                LOG.error((Object)"The keystore file is not found.", "");
                throw new PatchException("");
            }
            in = new FileInputStream(keyStoreFile);
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(in, pwd.toCharArray());
            this.setKs(keyStore);
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("InitCertificate failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5000D");
                throw new PatchException("initCertificate failed");
            }
            catch (Throwable throwable) {
                CertificateUtil.closeStream(in);
                throw throwable;
            }
        }
        CertificateUtil.closeStream(in);
    }

    public void importCertToKeystore(String alias, String certFile, boolean isArbCert) {
        LOG.info((Object)String.format(Locale.ROOT, "Start import cert to keystore, alias=%s", alias));
        FileInputStream inputFile = null;
        FileOutputStream fos = null;
        try {
            File cert = new File(FilenameUtils.normalize((String)certFile));
            if (!cert.exists()) {
                LOG.error((Object)"ImportCertToKeystore failed, cert file not found.");
                throw new PatchException("");
            }
            inputFile = new FileInputStream(FilenameUtils.normalize((String)certFile));
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            List certList = (List)factory.generateCertificates(inputFile);
            for (int i = 0; i < certList.size(); ++i) {
                LOG.info((Object)String.format(Locale.ROOT, "Start import cert, owner: %s", ((X509Certificate)certList.get(i)).getSubjectDN()));
                String entryName = this.generateEntryName(alias, i, isArbCert);
                this.deleteCertificate(entryName);
                this.ks.setCertificateEntry(entryName, (Certificate)certList.get(i));
            }
            fos = new FileOutputStream(this.keystoreFile);
            this.ks.store(fos, this.keystorePass.toCharArray());
            LOG.info((Object)"Import cert tok keystore successfully.", "");
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Failed to import cert to keystore, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("");
            }
            catch (Throwable throwable) {
                FileUtil.close(fos, "");
                FileUtil.close(inputFile, "");
                throw throwable;
            }
        }
        FileUtil.close(fos, "");
        FileUtil.close(inputFile, "");
    }

    private String generateEntryName(String alias, int index, boolean isArbCert) {
        if (isArbCert) {
            return alias + index;
        }
        return index == 0 ? alias : alias + "-" + index;
    }

    public String getCertsIssuer(String aliasName) {
        String issuer = "";
        try {
            Certificate ca = this.ks.getCertificate(aliasName);
            X509Certificate tmp = (X509Certificate)ca;
            issuer = tmp.getIssuerDN().toString();
        }
        catch (Exception e) {
            LOG.error((Object)("Get certs issuer failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return issuer;
    }

    public boolean isAliasExists(String alias) {
        boolean isExists = true;
        try {
            if (!this.ks.containsAlias(alias)) {
                isExists = false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Query defaults certs failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            isExists = false;
        }
        return isExists;
    }

    public void deleteCertificate(String alias) {
        try {
            this.ks.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            LOG.error((Object)("Delete alias failed." + e), "0x000252000FB5000D");
        }
    }

    public void exportCertToKeyStore(List<String> exceptAlias, String destKeyStore, String destType, String destPwd) {
        if (null == exceptAlias || VerifyUtil.isEmpty((String)destType) || VerifyUtil.isEmpty((String)destPwd)) {
            LOG.error((Object)"ExportCertToKeyStore failed, param error.", "");
            throw new PatchException("exportCertToKeyStore failed.");
        }
        try {
            KeyStore destKeystore = CertificateUtil.loadKeyStore(destKeyStore, destType, destPwd);
            Enumeration<String> enumers = this.ks.aliases();
            boolean isUpdate = false;
            while (enumers.hasMoreElements()) {
                String aliaName = enumers.nextElement();
                if (exceptAlias.contains(aliaName)) continue;
                isUpdate = true;
                LOG.info((Object)String.format(Locale.ROOT, "Export cert for alias=%s", aliaName));
                Certificate cert = this.ks.getCertificate(aliaName);
                destKeystore.setCertificateEntry(aliaName, cert);
            }
            if (isUpdate) {
                CertificateUtil.saveKeyStore(destKeystore, destKeyStore, destPwd);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("ExportCertToKeyStore failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("exportCertToKeyStore failed.");
        }
    }

    public static KeyStore loadKeyStore(String path, String type, String password) throws IOException, GeneralSecurityException {
        return CertificateUtil.loadKeyStore(new File(path), type, password);
    }

    public static KeyStore loadKeyStore(File path, String type, String password) throws IOException, GeneralSecurityException {
        try (FileInputStream in = new FileInputStream(path);){
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    public static List<String> getMatchedCertificateAliases(KeyStore keyStore, String rule) throws KeyStoreException {
        return CertificateUtil.getMatchedCertificateAliases(keyStore, Pattern.compile(rule, 2).asPredicate());
    }

    private static List<String> getMatchedCertificateAliases(KeyStore keyStore, Predicate<String> predicate) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        ArrayList<String> items = new ArrayList<String>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!predicate.test(alias)) continue;
            items.add(alias);
        }
        return items;
    }

    public static void removeMatchedCertificate(KeyStore keyStore, String rule) throws KeyStoreException {
        List<String> items = CertificateUtil.getMatchedCertificateAliases(keyStore, rule);
        for (String item : items) {
            keyStore.deleteEntry(item);
            LOG.info((Object)String.format(Locale.ROOT, "Remove certificate. alias: %s", item));
        }
    }

    public static void renameMatchedCertificate(KeyStore keyStore, String rule, String replacement) throws KeyStoreException {
        Pattern pattern = Pattern.compile(rule, 2);
        List<String> items = CertificateUtil.getMatchedCertificateAliases(keyStore, pattern.asPredicate());
        for (String item : items) {
            Certificate certificate = keyStore.getCertificate(item);
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = pattern.matcher(item);
            while (matcher.find()) {
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            String name = buffer.toString();
            if (name.equals(item)) continue;
            keyStore.deleteEntry(item);
            keyStore.setCertificateEntry(name, certificate);
            LOG.info((Object)String.format(Locale.ROOT, "Rename certificate alias %s to %s", item, name));
        }
    }

    public static Map.Entry<String, KeyStore> loadKeyStore(String home, String file, String conf, String key, String type) throws IOException, GeneralSecurityException {
        String password = CertificateUtil.getPasswordFromConfig(Paths.get(home, conf).toString(), key);
        return new AbstractMap.SimpleEntry<String, KeyStore>(password, CertificateUtil.loadKeyStore(Paths.get(home, file).toFile(), type, password));
    }

    public static String getPasswordFromConfig(String path, String key) throws IOException {
        PropertyUtil config = new PropertyUtil(path);
        return WccHelper.getInstance().decrypt(config.getValue(key));
    }

    public static void saveKeyStore(KeyStore keyStore, String path, String password) throws IOException, GeneralSecurityException {
        CertificateUtil.saveKeyStore(keyStore, new File(path), password);
    }

    public static void saveKeyStore(KeyStore keyStore, File path, String password) throws IOException, GeneralSecurityException {
        try (FileOutputStream out = new FileOutputStream(path);){
            keyStore.store(out, password.toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportCertsToFile(String path, String fileName) {
        if (VerifyUtil.isEmpty((String)path)) {
            throw new PatchException("exportCertsToFile failed. the dest path is empty.");
        }
        File destPath = new File(path);
        if (destPath.exists()) {
            if (!destPath.isDirectory()) {
                throw new PatchException("exportCertsToFile failed. the dest path is not a directory\u3002");
            }
        } else {
            LOG.info((Object)String.format(Locale.ROOT, "ExportCertsToFile, create output path result=%s", destPath.mkdirs()));
        }
        try {
            Enumeration<String> aliasList = this.ks.aliases();
            while (aliasList.hasMoreElements()) {
                String aliasName = aliasList.nextElement();
                FileOutputStream outStream = null;
                try {
                    LOG.info((Object)String.format(Locale.ROOT, "Start export cert which alias name is %s", aliasName));
                    String tmpName = VerifyUtil.isEmpty((String)fileName) ? aliasName + ".cer" : fileName;
                    outStream = new FileOutputStream(destPath.getCanonicalPath() + File.separator + tmpName);
                    Object[] certList = this.ks.getCertificateChain(aliasName);
                    if (VerifyUtil.isEmpty((Object[])certList)) {
                        certList = new Certificate[]{this.ks.getCertificate(aliasName)};
                    }
                    for (Object cert : certList) {
                        outStream.write(((Certificate)cert).getEncoded());
                        outStream.flush();
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.close(outStream, "");
                    throw throwable;
                    return;
                }
                FileUtil.close(outStream, "");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to export certs to file. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("Failed to export certs to file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIssuerDN(String cerFile) {
        FileInputStream input = null;
        String dn = "";
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            input = new FileInputStream(cerFile);
            X509Certificate tmp = (X509Certificate)cf.generateCertificate(input);
            dn = tmp.getIssuerDN().toString();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Check tomcat certs file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            catch (Throwable throwable) {
                CertificateUtil.closeStream(input);
                throw throwable;
            }
            CertificateUtil.closeStream(input);
        }
        CertificateUtil.closeStream(input);
        return dn;
    }

    private static void closeStream(Closeable be) {
        if (null != be) {
            try {
                be.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Close stream failed.", (Throwable)e, "0x000252000FB50012");
            }
        }
    }

    public static String getInstallPath() {
        String installPath;
        try {
            installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
        }
        catch (Exception e) {
            throw SystemExitUtil.failed("obtain install path failed", e);
        }
        return installPath;
    }
}

