/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs.replace;

import com.huawei.lego.common.certs.BackupDetail;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.certs.Component;
import com.huawei.lego.common.certs.replace.JKSCertificateReplaceCommand;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.util.ExceptionUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WebServerCertificateReplaceCommand
extends JKSCertificateReplaceCommand {
    private static final String BCM_KEYSTORE = "Runtime/LegoRuntime/certs/bcm.keystore";
    private static final String LEGO_CONFIG = "Runtime/LegoRuntime/conf/lego.properties";

    private WebServerCertificateReplaceCommand() {
        super(Component.webServer());
    }

    public static void main(String[] args) {
        new WebServerCertificateReplaceCommand().execute(args);
        System.exit(0);
    }

    @Override
    protected void backupOldCertificates(long timestamp, Map<String, String> backups) {
        super.backupOldCertificates(timestamp, backups);
        Path path = Paths.get(this.getComponent().getHome(), BCM_KEYSTORE);
        WebServerCertificateReplaceCommand.backup(backups, path.toString(), timestamp, "backup file: " + path.getFileName());
    }

    @Override
    protected void archiveNewCertificate(Map<String, Object> context, List<String> certFiles) {
        super.archiveNewCertificate(context, certFiles);
        try {
            this.addCaInKeyStoreToTrust((KeyStore)context.get("keyStore"));
        }
        catch (IOException | GeneralSecurityException e) {
            throw SystemExitUtil.failed(String.format(Locale.ENGLISH, "add CA to trust key store for %s failed, error:%s", this.getComponent().getName(), ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void addCaInKeyStoreToTrust(KeyStore keyStore) throws GeneralSecurityException, IOException {
        String home = this.getComponent().getHome();
        Map.Entry<String, KeyStore> trusted = CertificateUtil.loadKeyStore(home, BCM_KEYSTORE, LEGO_CONFIG, "keyStore", "JKS");
        String password = trusted.getKey();
        KeyStore trustStore = trusted.getValue();
        if (!this.addCaInKeyStoreToTrust(keyStore, trustStore)) {
            throw new GeneralSecurityException();
        }
        CertificateUtil.saveKeyStore(trustStore, Paths.get(home, BCM_KEYSTORE).toFile(), password);
    }

    private boolean addCaInKeyStoreToTrust(KeyStore keyStore, KeyStore trusted) throws KeyStoreException {
        String component = this.getComponent().getName();
        boolean changed = false;
        CertificateUtil.removeMatchedCertificate(trusted, String.format(Locale.ROOT, "^%s-backup-.*$", component));
        CertificateUtil.renameMatchedCertificate(trusted, String.format(Locale.ROOT, "^(%s)-active-(.*)$", component), "$1-backup-$2");
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate[] chain = keyStore.getCertificateChain(alias);
            if (chain == null) continue;
            int n = chain.length;
            for (int i = 1; i < n; ++i) {
                X509Certificate x509Certificate = (X509Certificate)chain[i];
                trusted.setCertificateEntry(component + "-active-ca-" + (n - i), x509Certificate);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    protected List<String> getConfigFields() {
        return Arrays.asList("keystoreType", "keystoreFile", "keystorePass", "keyPass", "SSLCertificateFile:keystoreFile");
    }

    @Override
    protected void restart(long timestamp) {
        Path trusts = Paths.get(this.getComponent().getHome(), BackupDetail.getBackupFileName(BCM_KEYSTORE, timestamp));
        if (!trusts.toFile().delete()) {
            throw SystemExitUtil.failed("clean old trust key store for " + this.getComponent().getName() + " failed");
        }
        this.shutdown("webServer", false);
    }
}

