/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs.rollback;

import com.huawei.lego.common.certs.BackupDetail;
import com.huawei.lego.common.certs.Component;
import com.huawei.lego.common.certs.ComponentCommand;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.TextEditor;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CertificateRollbackCommand
extends ComponentCommand {
    private static final Log LOG = LogFactory.getInstance(CertificateRollbackCommand.class);
    protected static final String ROLLBACK_BACKUP_SUFFIX = ".bak.rollback";

    public CertificateRollbackCommand(Component component) {
        super(component);
    }

    public void execute() {
        Component component = this.getComponent();
        String config = component.getConfiguration();
        if (!new File(config).exists()) {
            throw SystemExitUtil.failed(String.format(Locale.ROOT, "config file of component %s is missing", this.getComponent().getName()));
        }
        BackupDetail detail = BackupDetail.loadBackupDetail(config);
        if (detail == null) {
            throw SystemExitUtil.failed("not found valid backup files for component " + this.getComponent().getName());
        }
        String msg = String.format(Locale.ROOT, "You are going to rollback the certfile of %s. After certificate rollback, the component '%s' will be restart. Are you sure you really want to perform the operation? (y/n):", component.getName(), component.getName());
        if (!CertificateRollbackCommand.confirm(msg)) {
            throw SystemExitUtil.failed("user canceled rollback operation.");
        }
        HashMap<String, String> recordings = new HashMap<String, String>();
        try {
            this.backupFiles(recordings);
            this.rollbackCerts(detail, recordings);
            this.rollbackConfig(detail, recordings);
        }
        catch (Exception e2) {
            this.rollback(recordings);
            throw SystemExitUtil.failed("rollback failed for component " + this.getComponent().getName(), e2);
        }
        this.cleanFiles(recordings.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList()));
        this.cleanFile(BackupDetail.getBackupFileName(component.getConfiguration(), detail.getTimestamp()));
    }

    private void backupFiles(Map<String, String> recordings) {
        Component component = this.getComponent();
        List items = Stream.of(Collections.singletonList(this.getCertificateArchivePath()), component.getCertFileList()).flatMap(Collection::stream).collect(Collectors.toList());
        for (String item : items) {
            String file = item + ROLLBACK_BACKUP_SUFFIX;
            CertificateRollbackCommand.copy(item, file, "backup current config files", recordings);
        }
        CertificateRollbackCommand.copy(component.getConfiguration(), component.getConfiguration() + ROLLBACK_BACKUP_SUFFIX, "backup current config files", recordings);
    }

    protected void rollbackCerts(BackupDetail detail, Map<String, String> recordings) {
        long timestamp = detail.getTimestamp();
        String archive = this.getCertificateArchivePath();
        String backup = BackupDetail.getBackupFileName(archive, timestamp);
        CertificateRollbackCommand.move(backup, archive, "rollback archive cert file: " + backup, recordings);
        String baseLocation = this.getComponent().getBaseLocation();
        for (String item : detail.getFileset()) {
            String target = Paths.get(baseLocation, item).toString();
            String source = BackupDetail.getBackupFileName(target, timestamp);
            CertificateRollbackCommand.move(source, target, "rollback cert file: " + item, recordings);
        }
    }

    private void rollbackConfig(BackupDetail detail, Map<String, String> recordings) {
        String configuration;
        TextEditor editor = this.createConfigRollbackEditor(detail);
        boolean done = editor.edit(new File(configuration = this.getComponent().getConfiguration()));
        if (!done) {
            throw SystemExitUtil.failed("Fail to rollback for component " + this.getComponent().getName());
        }
    }

    private void cleanFiles(Collection<String> items) {
        for (String item : items) {
            this.cleanFile(item);
        }
    }

    private void cleanFile(String item) {
        File file = new File(item);
        if (file.exists()) {
            String action = "clean up file " + file.getName();
            String result = file.delete() ? "success" : "failed";
            LOG.info((Object)String.format(Locale.ROOT, "%s %s", action, result));
        }
    }

    protected TextEditor createConfigRollbackEditor(BackupDetail detail) {
        TextEditor editor = this.getComponent().getEditor();
        for (Map.Entry<String, String> item : detail.getConfigs().entrySet()) {
            editor = editor.then(item.getKey(), item.getValue());
        }
        return editor;
    }
}

