/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.changedb;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.changedb.ChangeDbAction;
import com.huawei.lego.common.changeport.ChangePort;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SetProcessThread;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.dom4j.DocumentException;

public class ChangeDBRun
implements Runnable {
    private static final Log LOG = LogFactory.getInstance(ChangeDBRun.class);
    private static boolean sInterupted = false;
    private static boolean sEnd = false;
    private DataBaseInfo dbInfor = null;
    private String dataKey = "gauss.port";

    public ChangeDBRun(DataBaseInfo dbInfor2) {
        dbInfor2.validate();
        this.dbInfor = dbInfor2;
    }

    public ChangeDBRun() {
    }

    public static boolean issEnd() {
        return sEnd;
    }

    public static void setsEnd(boolean e) {
        sEnd = e;
    }

    public static boolean issInterupted() {
        return sInterupted;
    }

    public static void setsInterupted(boolean sinterupted) {
        sInterupted = sinterupted;
    }

    @Override
    public void run() {
        this.doChangeCli();
    }

    private void doChangeCli() {
        try {
            ChangeDbAction.reNameOldFile();
            ChangeDbAction.changeDbInfor(this.dbInfor);
            ChangeDbAction.updateInstallXML(this.dbInfor);
            ChangePort.changePortConfFile(this.dataKey, this.dbInfor.getDbPort());
            if (ChangeDBRun.issInterupted()) {
                ChangeDbAction.rollBack();
                ChangeDBRun.setsEnd(true);
                return;
            }
            SetProcessThread.getInstance().setFinished(true);
            while (!SetProcessThread.getInstance().isFeedBack()) {
                if (ChangeDBRun.issInterupted()) {
                    ChangeDbAction.rollBack();
                    ChangeDBRun.setsEnd(true);
                    return;
                }
                Thread.sleep(500L);
            }
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.CHANGINGDB.PROGRESS.FINISHED.TIP.CLI"));
            String runtimePath = InitInstalledXmlTool.getInstallPath() + File.separator;
            String targetFile = runtimePath + "Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "account.properties";
            this.changeAccountConfFile(targetFile);
        }
        catch (IOException e) {
            LOG.error((Object)"ChangeDB  IOException Error", (Throwable)e, "0x000252000FB50012");
            this.exceptionOpt();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"ChangeDB InterruptedException Error", (Throwable)e, "0x000252000FB50012");
            this.exceptionOpt();
        }
        catch (DocumentException e) {
            LOG.error((Object)"ChangeDB DocumentException Error", (Throwable)e, "0x000252000FB50012");
            this.exceptionOpt();
        }
        ChangeDbAction.deleteOldTmpFile();
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.BLANK.ROW.CLI"));
        LOG.info((Object)LegoResourceManager.getString("LEGO.CHANGEDB.SUCCESS"), "");
        PrepareParamUtil.exitFail(0);
    }

    private void exceptionOpt() {
        SetProcessThread.getInstance().suspend();
        ChangeDbAction.rollBack();
        SystemExitUtil.exitOK();
    }

    private void changeAccountConfFile(String file) {
        if (!new File(file).exists()) {
            LOG.error((Object)"File is not exist.");
            return;
        }
        if (!this.dbInfor.isDbaPwdChanged() && !this.dbInfor.isManagerPwdChanged()) {
            LOG.info((Object)"DbaPwd and managerPwd is not changed");
            return;
        }
        HashMap data = new HashMap();
        try {
            LegoConfig.diffDataBaseConfig(data);
            FileUtil.modifyPropFileUsingStr((String)file, data, (String)file);
        }
        catch (IOException e) {
            LOG.error((Object)e, "ChangeConfFile failed.");
            throw new PatchException("ChangeConfFile failed: " + e);
        }
    }
}

