/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.changedb;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.DataBaseUtil;
import com.huawei.lego.cli.clichangedb.main.CliChangeDB;
import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.changedb.ChangeDBRun;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SetProcessThread;
import com.huawei.lego.common.util.dbtool.ChangeDbInforInJar;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.dom4j.DocumentException;

public class ChangeDbAction {
    private static final Log LOG = LogFactory.getInstance(ChangeDbAction.class);
    private static SetProcessThread sProcessThread = SetProcessThread.getInstance();
    private static DataBaseInfo dbInfor = null;
    private static String savePath = "";
    private static final int STEP1_MAXNUMBER = 5;
    private static final int STEP2_MAXNUMBER = 80;
    private static final int STEP3_MAXNUMBER = 100;
    private static final int FAST = 50;
    private static final int SLOW = 500;
    private static final int VALUE_2 = 2;
    private static final String SUFIX_TMP = "@tmp";

    public ChangeDbAction() {
        dbInfor = Singleton.getInstance().getSystem().getDbInfor();
    }

    public static void reNameOldFile() throws IOException {
        if (ChangeDBRun.issInterupted()) {
            return;
        }
        try {
            sProcessThread.setMaxNumber(5);
            sProcessThread.setSpeed(50);
            String proDBjar = savePath + "/" + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + "/" + LegoResourceManager.getProValue("install.db.propfile.jar");
            FileUtil.copyFile(proDBjar, proDBjar + SUFIX_TMP);
            String dbFile = savePath + File.separator + LegoResourceManager.getProValue("db.config.file");
            FileUtil.copyFile(dbFile, dbFile + SUFIX_TMP);
        }
        catch (IOException e) {
            LOG.error((Object)("Copy Platform Jars Error, errMsg: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void changeDBPwd() throws ClassNotFoundException, SQLException {
        if (ChangeDBRun.issInterupted()) {
            return;
        }
        Connection conn = null;
        PreparedStatement changePwd = null;
        try {
            DataBaseInfo oldDbInfor = Singleton.getInstance().getSystem().getDbInfor();
            String host = oldDbInfor.getDbHost();
            int port = Integer.parseInt(oldDbInfor.getDbPort());
            String user = oldDbInfor.getDbaUsername();
            String pwd = oldDbInfor.getDbaPassword();
            String url = "jdbc:mysql://" + host + ":" + port;
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection(url, user, pwd);
            changePwd = conn.prepareStatement("update mysql.user set password=PASSWORD(?) where user=?");
            changePwd.setString(1, dbInfor.getDbaPassword());
            changePwd.setString(2, user);
            changePwd.executeUpdate();
            changePwd.execute("flush privileges");
        }
        catch (ClassNotFoundException e) {
            try {
                LOG.error((Object)("Change DB pwd Error:" + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5001D");
                throw new ClassNotFoundException("class not found.");
                catch (SQLException se) {
                    LOG.error((Object)("Change DB pwd Error: " + ExceptionUtil.getErrorMessage((Throwable)se)), "0x000252000FB5001D");
                    throw new SQLException("change db pwd error.");
                }
            }
            catch (Throwable throwable) {
                ChangeDbAction.closeConn(conn, changePwd);
                throw throwable;
            }
        }
        ChangeDbAction.closeConn(conn, changePwd);
    }

    private static void closeConn(Connection conn, PreparedStatement changePwd) {
        if (changePwd != null) {
            try {
                changePwd.close();
            }
            catch (SQLException e1) {
                LOG.error((Object)("Close sql connection: " + ExceptionUtil.getErrorMessage((Throwable)e1)), "0x000252000FB5001D");
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e1) {
                LOG.error((Object)("Close sql connection: " + ExceptionUtil.getErrorMessage((Throwable)e1)), "0x000252000FB5001D");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollBackDBPwd() {
        Connection conn = null;
        PreparedStatement changePwd = null;
        try {
            DataBaseInfo oldDbInfor = Singleton.getInstance().getSystem().getDbInfor();
            String host = oldDbInfor.getDbHost();
            int port = Integer.parseInt(oldDbInfor.getDbPort());
            String user = oldDbInfor.getDbaUsername();
            String pwd = dbInfor.getDbaPassword();
            String url = "jdbc:mysql://" + host + ":" + port;
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection(url, user, pwd);
            changePwd = conn.prepareStatement("update mysql.user set password=PASSWORD(?) where user=?");
            changePwd.setString(1, oldDbInfor.getDbaPassword());
            changePwd.setString(2, user);
            changePwd.executeUpdate();
            changePwd.execute("flush privileges");
            ChangeDbAction.closeDBResource(conn, changePwd);
        }
        catch (ClassNotFoundException | SQLException e) {
            LOG.error((Object)("RollBack DB Pwd Error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5001D");
        }
        finally {
            ChangeDbAction.closeDBResource(conn, changePwd);
        }
    }

    private static void closeDBResource(Connection conn, PreparedStatement changePwd) {
        if (changePwd != null) {
            try {
                changePwd.close();
            }
            catch (SQLException e1) {
                LOG.error((Object)("Close connection1: " + ExceptionUtil.getErrorMessage((Throwable)e1)), "0x000252000FB5001D");
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e1) {
                LOG.error((Object)("Close connection2: " + ExceptionUtil.getErrorMessage((Throwable)e1)), "0x000252000FB5001D");
            }
        }
    }

    public static void changeDbInfor(DataBaseInfo dbInfo) throws IOException, DocumentException {
        if (ChangeDBRun.issInterupted()) {
            return;
        }
        try {
            LOG.debug((Object)"Update database configure begin", "0x000252000FB5001E");
            sProcessThread.setMaxNumber(80);
            sProcessThread.setSpeed(500);
            ChangeDbInforInJar.changePropDBFile(dbInfo, savePath);
            LOG.debug((Object)"Update database configure end", "0x000252000FB5001F");
        }
        catch (IOException e) {
            LOG.error((Object)"Change DB Infor Error", (Throwable)e, "0x000252000FB5001D");
            throw e;
        }
    }

    public static void changeDbInfor() throws IOException {
        if (ChangeDBRun.issInterupted()) {
            return;
        }
        try {
            LOG.info((Object)"Update database configure begin", "0x000252000FB5001E");
            sProcessThread.setMaxNumber(80);
            sProcessThread.setSpeed(500);
            ChangeDbInforInJar.changePropDBFile(dbInfor, savePath);
            LOG.info((Object)"Update database configure end", "0x000252000FB5001F");
        }
        catch (IOException e) {
            LOG.error((Object)"Change DB Infor Error", (Throwable)e, "0x000252000FB5001D");
            throw e;
        }
    }

    public static void updateInstallXML(DataBaseInfo dbInfo) throws DocumentException, IOException {
        if (ChangeDBRun.issInterupted()) {
            return;
        }
        LOG.debug((Object)"Change db info in install.xml", "0x000252000FB5001E");
        sProcessThread.setMaxNumber(100);
        sProcessThread.setSpeed(50);
        DataBaseUtil.updatePassword(savePath, dbInfo.getManagerPassword(), dbInfo.getDbaPassword());
    }

    public static void updateInstallXML() {
        if (ChangeDBRun.issInterupted()) {
            return;
        }
        LOG.info((Object)"Change db info in install.xml", "0x000252000FB5001E");
        sProcessThread.setMaxNumber(100);
        sProcessThread.setSpeed(50);
        DataBaseUtil.updatePassword(savePath, dbInfor.getManagerPassword(), dbInfor.getDbaPassword());
    }

    public static void rollBack() {
        String proDBjar = savePath + "/" + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + "/" + LegoResourceManager.getProValue("install.db.propfile.jar");
        FileUtil.deleteFile(proDBjar);
        ChangeDbAction.recoveryName(proDBjar + SUFIX_TMP);
        String dbFile = savePath + File.separator + LegoResourceManager.getProValue("db.config.file");
        FileUtil.deleteFile(dbFile);
        ChangeDbAction.recoveryName(dbFile + SUFIX_TMP);
    }

    public static void deleteOldTmpFile() {
        String backPath = savePath + "/" + LegoResourceManager.getProValue("install.lego_version.backend.jar.path");
        String installXMLPath = OSInformation.getUserHomePath();
        ChangeDbAction.deleteBkFile(backPath);
        ChangeDbAction.deleteBkFile(installXMLPath);
    }

    private static void deleteBkFile(String folderPath) {
        File folder0 = new File(folderPath);
        File[] files = folder0.listFiles(file -> file.getName().endsWith(SUFIX_TMP));
        if (null != files) {
            for (File file0 : files) {
                file0.setWritable(true);
                boolean result = file0.delete();
                if (result) continue;
                LOG.error((Object)("delete file Error: " + file0.getName()), "0x000252000FB5001D");
            }
        }
    }

    private static void recoveryName(String fileName) {
        File oldFile = new File(fileName);
        if (oldFile.exists()) {
            oldFile.setWritable(true);
            boolean succ = oldFile.renameTo(new File(fileName.substring(0, fileName.length() - SUFIX_TMP.length())));
            LOG.info((Object)String.format(Locale.ROOT, "Roll Back %s:%s", oldFile.getName(), succ), "0x000252000FB5003E");
        }
    }

    static {
        savePath = CliChangeDB.getInstance().getInstallSystem().getInstallpath();
    }
}

