/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.changeport;

import com.huawei.lego.common.changeport.ProcessFile;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.exception.StartException;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.PortCheckTool;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PortsUtil {
    private static final Log LOG = LogFactory.getInstance(PortsUtil.class);
    private static final String ILLEAGL_TMP_FILE = "illegalTmpFile";
    private static final String DEFAULT_PORT_FILE = "config/conf/port.ini";
    private static final int LINUX_MIN_PORT = 1024;
    private static final int MAX_PORT = 65535;
    private static final int UTF8_BOME = 65279;
    private Map<String, String> maps = new HashMap<String, String>();

    public PortsUtil(String portFile) {
        String file = portFile;
        if ("".equals(portFile) || null == portFile) {
            file = DEFAULT_PORT_FILE;
        }
        this.init(file);
    }

    private void init(String portFile) {
        File file = new File(portFile);
        if (!file.exists()) {
            throw new PatchException("can not find the port.ini file.");
        }
        InputStreamReader reader = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            reader = new InputStreamReader((InputStream)input, "UTF-8");
            Properties pro = new Properties();
            pro.load(reader);
            this.setProKeys(pro);
            this.closeStream(reader);
            this.closeStream(input);
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Load port config file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new PatchException("load port config file failed.");
            }
            catch (Throwable throwable) {
                this.closeStream(reader);
                this.closeStream(input);
                throw throwable;
            }
        }
    }

    private void setMaps(Map<String, String> maps) {
        this.maps = maps;
    }

    private void setProKeys(Properties pro) {
        HashMap<String, String> entry = new HashMap<String, String>();
        Set<Object> keys = pro.keySet();
        for (String string : keys) {
            String value = pro.getProperty(string);
            String string2 = this.getKey(string);
            if (string2.startsWith("#")) continue;
            entry.put(string2, value);
        }
        this.setMaps(entry);
    }

    private String getKey(String key) {
        String newKey = key;
        char ch = key.charAt(0);
        if (ch == '\ufeff') {
            newKey = key.substring(1);
        }
        return newKey;
    }

    public Map<String, String> getAllPorts() {
        HashMap<String, String> allPorts = new HashMap<String, String>();
        Set<String> keys = this.maps.keySet();
        for (String key : keys) {
            String value = this.maps.get(key);
            if (null == value || "".equals(value) || OSInformation.isLinux() && key.contains("windows") || OSInformation.isWindows() && key.contains("linux")) continue;
            allPorts.put(key, value);
        }
        return allPorts;
    }

    public Map<String, String> getAllllegalPorts() {
        HashMap<String, String> illegalPort = new HashMap<String, String>();
        Set<String> keys = this.maps.keySet();
        for (String key : keys) {
            String value = this.maps.get(key);
            if (OSInformation.isLinux() && key.contains("windows") || OSInformation.isWindows() && key.contains("linux")) continue;
            if (null == value || "".equals(value)) {
                illegalPort.put(key, value);
                continue;
            }
            if (key.contains("gauss") && !this.checkGaussPort(value)) {
                illegalPort.put(key, value);
                continue;
            }
            this.checkTheSamePort(key, value, illegalPort);
            if (this.checkPortIllegal(key, value)) continue;
            illegalPort.put(key, value);
        }
        return illegalPort;
    }

    public Map<String, String> getAllUsedPorts() {
        HashMap<String, String> usedPort = new HashMap<String, String>();
        Set<String> keys = this.maps.keySet();
        for (String key : keys) {
            String value = this.maps.get(key);
            if (null == value || "".equals(value) || OSInformation.isLinux() && key.contains("windows") || OSInformation.isWindows() && key.contains("linux") || key.contains("gauss") && this.checkGaussPort(value) || this.checkPortUsed(value)) continue;
            usedPort.put(key, value);
        }
        return usedPort;
    }

    private void checkTheSamePort(String checkKey, String checkValue, Map<String, String> illegalPort) {
        Set<String> keys = this.maps.keySet();
        for (String key : keys) {
            String value = this.maps.get(key);
            if (OSInformation.isLinux() && key.contains("windows") || OSInformation.isWindows() && key.contains("linux") || !checkValue.equals(value) || checkKey.equals(key)) continue;
            illegalPort.put(key, value);
        }
    }

    public static boolean isPortCanBeUsed(Map<String, String> changedPorts, String port) {
        PortsUtil util = new PortsUtil("");
        Map<String, String> filePortMap = util.getAllPorts();
        if (null != changedPorts) {
            filePortMap.putAll(changedPorts);
        }
        return !filePortMap.containsValue(port);
    }

    public static void checkPortIsUsed() {
        Map<String, String> illegalPorts;
        PortsUtil uti = new PortsUtil("");
        Map<String, String> portsList = illegalPorts = uti.getAllllegalPorts();
        long code = 10011L;
        if (OSInformation.isLinux() && VerifyUtil.isEmpty(illegalPorts)) {
            return;
        }
        if (OSInformation.isWindows() && VerifyUtil.isEmpty(illegalPorts)) {
            Map<String, String> usedPorts = uti.getAllUsedPorts();
            if (VerifyUtil.isEmpty(usedPorts)) {
                return;
            }
            portsList = usedPorts;
            code = 10012L;
        }
        Set<String> ports = portsList.keySet();
        Iterator<String> iter = ports.iterator();
        StringBuffer buff = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        while (iter.hasNext()) {
            String key = iter.next();
            String value = portsList.get(key);
            String tmpbuff = lineSep + key + "=" + value + ";";
            buff.append(tmpbuff);
        }
        if (OSInformation.isLinux()) {
            ProcessFile.writeTmpFile(ILLEAGL_TMP_FILE, buff.toString());
        }
        throw new StartException(buff.toString(), code);
    }

    private boolean checkPortIllegal(String key, String port) {
        boolean isTrue = false;
        try {
            int ports = Integer.parseInt(port);
            if ("http.port".equals(key) || OSInformation.isWindows()) {
                if (ports >= 1 && ports <= 65535) {
                    isTrue = true;
                }
            } else if (ports >= 1024 && ports <= 65535) {
                isTrue = true;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"NumberFormatException: ", (Throwable)e, "");
            isTrue = false;
        }
        return isTrue;
    }

    private boolean checkPortUsed(String port) {
        boolean isOK = true;
        try {
            int ports = Integer.valueOf(port);
            if (!PortCheckTool.checkPortUsed(ports)) {
                isOK = false;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"NumberFormatException: ", (Throwable)e, "");
            isOK = false;
        }
        return isOK;
    }

    private boolean checkGaussPort(String port) {
        boolean isTrue = false;
        try {
            int ports = Integer.parseInt(port);
            if (ports >= 1024 && ports <= 65535) {
                isTrue = true;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"NumberFormatException: ", (Throwable)e, "");
            isTrue = false;
        }
        return isTrue;
    }

    private void closeStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Object)e, "Close stream failed.");
            }
        }
    }
}

