/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cmd;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ScanDbLargeTable {
    private static final Log LOGGER = LogFactory.getInstance(ScanDbLargeTable.class);
    private static final String MAX_TABLE_ROW_SIZE_KEY = "max.table.row.size";
    private static final String ALARM_COMMAND = "/bin/reportAlarm.sh";
    private static final String LEGO_PROPERTIES_PATH = "/LegoRuntime/conf/lego.properties";
    private static final long DEFAULT_MAX_TABLE_ROW_SIZE = 300000L;
    private static final String GENERATE_TYPE = "1";
    private static final String RESTORE_TYPE = "2";
    private static final String MONITOR_TABLES = "monitor.tables";
    private static final String QUERY_ALL_TABLES_SQL = "select RELNAME from PG_STAT_USER_TABLES";
    private static final Set<String> ALL_TABLES = new HashSet<String>();

    public static void main(String[] args) {
        try {
            String[] monitorTables;
            String runtimePath;
            long maxRows;
            LOGGER.info((Object)"Enter ScanDbLargeTable");
            Optional runtimePathOptional = SysPropertiesUtils.getRuntimePath();
            if (!runtimePathOptional.isPresent()) {
                LOGGER.error((Object)"Scan database table failed, cause runtimePath not find.");
                SystemExitUtil.exitFail();
            }
            if ((maxRows = LegoConfig.getInstance((String)((runtimePath = (String)runtimePathOptional.get()) + LEGO_PROPERTIES_PATH)).getNumber(MAX_TABLE_ROW_SIZE_KEY, 300000L)) <= 0L) {
                LOGGER.error((Object)String.format(Locale.ROOT, "The MAX_TABLE_ROW_SIZE configuration is incorrect, MAX_TABLE_ROW_SIZE is %s", maxRows));
                SystemExitUtil.exitFail();
            }
            if ((monitorTables = LegoConfig.getInstance((String)(runtimePath + LEGO_PROPERTIES_PATH)).getKeyValue(MONITOR_TABLES, "").split(",")).length == 0 || !ScanDbLargeTable.monitorTableIsValid(monitorTables)) {
                LOGGER.error((Object)"The MONITOR_TABLES configuration is incorrect");
                SystemExitUtil.exitFail();
            }
            String cmdScript = runtimePath + ALARM_COMMAND;
            String sql = ScanDbLargeTable.combineSql(maxRows, monitorTables);
            if (ScanDbLargeTable.queryScanResult(sql) == 0L) {
                ScanDbLargeTable.sendAlarm(cmdScript, maxRows, RESTORE_TYPE);
                LOGGER.info((Object)"No database table is too large.");
                SystemExitUtil.exitOK();
            }
            ScanDbLargeTable.sendAlarm(cmdScript, maxRows, GENERATE_TYPE);
        }
        catch (Exception e) {
            LOGGER.error((Object)String.format(Locale.ROOT, "Scan database table failed, errMsg=%s", ExceptionUtil.getErrorMessage((Throwable)e)));
            SystemExitUtil.exitFail();
        }
        SystemExitUtil.exitOK();
    }

    private static void sendAlarm(String cmd, long maxRows, String type) throws IOException, InterruptedException {
        String baseCommand = "nohup sh %s --type %s --severity 3 --alarmId 52625524 --moName ManagementSystem --createTime %s --param %s";
        String alarmCommand = String.format(Locale.ENGLISH, baseCommand, cmd, type, System.currentTimeMillis(), maxRows);
        CmdUtil.runShell(alarmCommand);
    }

    private static void queryAllTables(String sql) {
        DataBaseInfo dataBaseInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        try (Connection conn = LegoDBConnection.getInstance().connectDBWithDba(dataBaseInfo, "LEGO");
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            ALL_TABLES.clear();
            while (resultSet.next()) {
                ALL_TABLES.add(resultSet.getString(1));
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)String.format(Locale.ROOT, "Execute all tables failed, message=%s", ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException("Execute all tables failed!");
        }
    }

    /*
     * Exception decompiling
     */
    private static long queryScanResult(String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean monitorTableIsValid(String[] monitorTables) {
        ScanDbLargeTable.queryAllTables(QUERY_ALL_TABLES_SQL);
        if (monitorTables.length > ALL_TABLES.size()) {
            return false;
        }
        for (String monitorTable : monitorTables) {
            if (ALL_TABLES.contains(monitorTable)) continue;
            return false;
        }
        return true;
    }

    private static String combineSql(long maxRows, String[] monitorTables) {
        StringBuffer sql = new StringBuffer("select count(1) from (");
        sql.append(Arrays.stream(monitorTables).map(table -> "SELECT count(1) FROM " + table).collect(Collectors.joining(" UNION ALL ")));
        sql.append(") t where count > ");
        sql.append(maxRows);
        return sql.toString();
    }
}

