/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.ha;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlTool {
    private static final String TEXTTYPE = "HATEXTTYPE";
    private static final Log LOG = LogFactory.getInstance(XmlTool.class);
    private Map<String, Map<String, String>> singleMap = new HashMap<String, Map<String, String>>();
    private Map<String, List<Map<String, String>>> nodesMap = new HashMap<String, List<Map<String, String>>>();

    public XmlTool(String xmlFile) {
        this.initXml(xmlFile);
    }

    private void initXml(String xmlFile) {
        File file = new File(xmlFile);
        if (!file.exists()) {
            LOG.error((Object)("GetXmlInfo failed, file not found: " + file.getName()), "");
            throw new PatchException("getXmlInfo failed");
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            Element root = document.getRootElement();
            this.getAllNodeValue(root);
        }
        catch (Exception e) {
            LOG.error((Object)("InitXml failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("initXml failed");
        }
    }

    private void getAllNodeValue(Element element) {
        List list = element.elements();
        if (list.size() == 0) {
            LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>();
            List prop = element.attributes();
            if (prop.size() == 0) {
                linkMap.put(TEXTTYPE, element.getText());
            }
            for (Attribute bute : prop) {
                linkMap.put(bute.getName(), bute.getStringValue());
            }
            String path = element.getPath();
            if (this.singleMap.containsKey(path) || this.nodesMap.containsKey(path)) {
                ArrayList<Map<String, String>> tmp = new ArrayList<Map<String, String>>();
                tmp.add(linkMap);
                if (this.nodesMap.containsKey(path)) {
                    tmp.addAll((Collection)this.nodesMap.get(path));
                }
                if (this.singleMap.containsKey(path)) {
                    tmp.add(this.singleMap.get(path));
                    this.singleMap.remove(path);
                }
                this.nodesMap.put(path, tmp);
            } else {
                this.singleMap.put(path, linkMap);
            }
        } else {
            for (Element ele : list) {
                this.getAllNodeValue(ele);
            }
        }
    }

    public static void updateXml(String destFile, List<Map.Entry<String, Map<String, String>>> singleList) {
        XMLWriter xmlWriter = null;
        FileOutputStream outStream = null;
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            document = reader.read(destFile);
            XmlTool.updateSingleNode(document, singleList);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            outStream = new FileOutputStream(destFile);
            xmlWriter = new XMLWriter((OutputStream)outStream, format);
            xmlWriter.write(document);
            xmlWriter.flush();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("UpdateXmlFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("updateXmlFile failed." + e);
            }
            catch (Throwable throwable) {
                XmlTool.closeStream(outStream);
                XmlTool.closeWriter(xmlWriter);
                throw throwable;
            }
        }
        XmlTool.closeStream(outStream);
        XmlTool.closeWriter(xmlWriter);
    }

    private static void updateSameNodes(Document document, Map<String, List<Map<String, String>>> nodesMap) {
        for (Map.Entry<String, List<Map<String, String>>> dataMap : nodesMap.entrySet()) {
            String nodePath = dataMap.getKey();
            List eleList = document.selectNodes(nodePath);
            for (Node ele : eleList) {
                ((Element)document.selectSingleNode(nodePath.substring(0, nodePath.lastIndexOf("/")))).remove(ele);
            }
            XmlTool.createSameNodes(document, nodePath, dataMap.getValue());
        }
    }

    private static void createSameNodes(Document document, String nodePath, List<Map<String, String>> dataList) {
        String parentNode = nodePath.substring(0, nodePath.lastIndexOf("/"));
        if (null == document.selectSingleNode(parentNode)) {
            XmlTool.createSingleNode(document, parentNode);
        }
        String newNode = nodePath.substring(parentNode.length() + 1);
        for (Map<String, String> tmpData : dataList) {
            Element ele = ((Element)document.selectSingleNode(parentNode)).addElement(newNode);
            for (Map.Entry<String, String> da : tmpData.entrySet()) {
                if (TEXTTYPE.equals(da.getKey())) {
                    ele.setText(da.getValue());
                    continue;
                }
                ele.addAttribute(da.getKey(), da.getValue());
            }
        }
    }

    private static void updateSingleNode(Document document, List<Map.Entry<String, Map<String, String>>> singleList) {
        for (Map.Entry<String, Map<String, String>> data : singleList) {
            String nodePath = data.getKey();
            Set<Map.Entry<String, String>> dataEntry = data.getValue().entrySet();
            List tmpEle = document.selectNodes(nodePath);
            if (tmpEle.size() > 1) {
                for (Node node : tmpEle) {
                    ((Element)document.selectSingleNode(nodePath.substring(0, nodePath.lastIndexOf("/")))).remove(node);
                }
            }
            if (null == document.selectSingleNode(nodePath)) {
                XmlTool.createSingleNode(document, nodePath);
            }
            for (Map.Entry entry : dataEntry) {
                Element element = (Element)document.selectSingleNode(nodePath);
                if (TEXTTYPE.equals(entry.getKey())) {
                    element.setText((String)entry.getValue());
                    continue;
                }
                element.addAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static void createSingleNode(Document document, String nodePath) {
        String[] nodes = nodePath.split("/");
        String path = "/";
        Node tmp = null;
        for (int i = 1; i < nodes.length; ++i) {
            String curNode = (path = path + nodes[i] + "/").substring(0, path.length() - 1);
            tmp = document.selectSingleNode(curNode);
            if (null != tmp) continue;
            String parentNode = curNode.substring(0, curNode.lastIndexOf("/"));
            ((Element)document.selectSingleNode(parentNode)).addElement(curNode.substring(parentNode.length() + 1));
        }
    }

    public Map<String, Map<String, String>> getSingleMap() {
        return this.singleMap;
    }

    public Map<String, List<Map<String, String>>> getNodesMap() {
        return this.nodesMap;
    }

    private static void closeWriter(XMLWriter writer) {
        if (null != writer) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.error((Object)e, "CloseWriter failed.");
            }
        }
    }

    private static void closeStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Object)e, "Close stream failed.");
            }
        }
    }
}

