/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch.action;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.action.InstallPatchAction;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.model.PatchFile;
import com.huawei.lego.common.patch.model.SqlFile;
import com.huawei.lego.common.patch.util.InitPatchZipTool;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UnInstallPatchAction {
    private static final Log LOGGER = LogFactory.getInstance(UnInstallPatchAction.class);
    private static final String INSTALL_FILE = OSInformation.getInstalledFile();
    private static final String INSTALL_BACK_FILE = INSTALL_FILE + "@backup";

    public static void doAction(boolean isUpdateSQL) throws PatchException {
        LOGGER.info((Object)"Do UnInstallPatchAction(CallBack)! ", "");
        PatchDto dto = null;
        dto = InitPatchZipTool.getPatchInforFromXml();
        String patchPath = InitPatchZipTool.getRuntimePath() + "Runtime" + File.separator + "patch";
        String packagePath = patchPath + File.separator + "package";
        String backupPath = patchPath + File.separator + "backup" + File.separator + "oldFiles";
        String tmpPatckagePath = patchPath + File.separator + "tmp" + File.separator + "package";
        List<PatchFile> rpFiles = dto.getRpFiles();
        List<PatchFile> addFiles = dto.getAddFiles();
        List<PatchFile> delFiles = dto.getDelFiles();
        List<SqlFile> sqls = dto.getUninstallSqlFiles();
        String sp = File.separator;
        try {
            UnInstallPatchAction.cpFiles(backupPath, rpFiles, sp);
            UnInstallPatchAction.delFiles(addFiles);
            UnInstallPatchAction.cpFiles(backupPath, delFiles, sp);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Recovery BCManager system file failed. Please recovery byself.", (Throwable)e, "");
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20022L);
            UnInstallPatchAction.recoveryInstallFile(INSTALL_BACK_FILE, INSTALL_FILE);
            UnInstallPatchAction.recoveryPackage(tmpPatckagePath, packagePath);
            throw ex;
        }
        if (!isUpdateSQL) {
            UnInstallPatchAction.clearDirFiles(backupPath, packagePath);
            UnInstallPatchAction.recoveryPackage(tmpPatckagePath, packagePath);
            return;
        }
        try {
            List<String> list = InstallPatchAction.getUpdateList();
            if (list != null) {
                for (String bundle : list) {
                    List<SqlFile> filterSqls = UnInstallPatchAction.fiterSqlAndSort(sqls, bundle);
                    UnInstallPatchAction.execSql(packagePath, filterSqls, sp);
                }
            }
        }
        catch (PatchException e) {
            throw e;
        }
        finally {
            UnInstallPatchAction.clearDirFiles(backupPath, packagePath);
            UnInstallPatchAction.recoveryInstallFile(INSTALL_BACK_FILE, INSTALL_FILE);
            UnInstallPatchAction.recoveryPackage(tmpPatckagePath, packagePath);
            LOGGER.info((Object)"End Recovery BCManager system! ", "");
        }
    }

    private static void recoveryPackage(String tmpPath, String destPath) {
        try {
            UnInstallPatchAction.restorePackage(tmpPath, destPath);
            File packageFile = new File(tmpPath);
            if (packageFile.exists()) {
                FileUtil.deleteAllFilesInFolder(packageFile);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"RestorePackage or deleteAllFilesInFolder failed.", (Throwable)e, "");
        }
    }

    private static void restorePackage(String src, String dst) throws IOException {
        File packageDir = new File(dst);
        if (packageDir.exists()) {
            FileUtil.deleteAllFilesInFolder(packageDir);
            FileUtil.copyFolder(src, dst);
        }
    }

    private static void recoveryInstallFile(String src, String dest) {
        try {
            FileUtil.copyFile(src, dest);
            File file = new File(src);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Resotre install file failed.", (Throwable)e, "");
        }
    }

    private static void clearDirFiles(String backupPath, String packagePath) {
        File backupDir = new File(backupPath);
        try {
            FileUtil.deleteAllFilesInFolder(backupDir);
            File packageFile = new File(packagePath);
            if (packageFile.exists()) {
                FileUtil.deleteAllFilesInFolder(packageFile);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Clean backup files(patch/backup and patch/package) error. ", (Throwable)e, "");
        }
    }

    private static void execSql(String packagePath, List<SqlFile> sqls, String sp) throws PatchException {
        HashMap sqlFileMap = new HashMap();
        if (sqls.isEmpty()) {
            LOGGER.info((Object)"No sql script should be exec.", "");
            return;
        }
        try {
            for (SqlFile sqlFile : sqls) {
                File sf = new File(packagePath + sp + sqlFile.getSrcName());
                LOGGER.info((Object)String.format(Locale.ROOT, "SqlFile: %s", sqlFile.getSrcName()));
                if (sqlFileMap.containsKey(sqlFile.getDbName())) {
                    ((List)sqlFileMap.get(sqlFile.getDbName())).add(sf);
                    continue;
                }
                ArrayList<File> sqlFiles = new ArrayList<File>();
                sqlFiles.add(sf);
                sqlFileMap.put(sqlFile.getDbName(), sqlFiles);
            }
            Set sqlFileSet = sqlFileMap.entrySet();
            DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            LOGGER.info((Object)String.format(Locale.ROOT, "Exec sql size:%s", sqlFileSet.size()));
            for (Map.Entry entry : sqlFileSet) {
                InitSQL iSql = new InitSQL(null);
                dbInfo.setDbName((String)entry.getKey());
                iSql.fixSql(dbInfo, (List)entry.getValue());
            }
        }
        catch (SQLException e0) {
            LOGGER.error((Object)("UnInstallPatchAction exec sql error. " + ExceptionUtil.getErrorMessage((Throwable)e0)), "");
            PatchException ex = new PatchException("UnInstallPatchAction exec sql error");
            ex.setErrorCode(20021L);
            throw ex;
        }
        catch (IOException e0) {
            LOGGER.error((Object)"UnInstallPatchAction exec sql error. ", (Throwable)e0, "");
            PatchException ex = new PatchException("", e0);
            ex.setErrorCode(20021L);
            throw ex;
        }
    }

    private static List<SqlFile> fiterSqlAndSort(List<SqlFile> sqls, String bundle) {
        ArrayList<SqlFile> filterSqls = new ArrayList<SqlFile>();
        List<String> installedSQL = InstallPatchAction.getSqlFileVersion();
        String newVersion = InstallPatchAction.getMaxOldVersion(INSTALL_FILE, bundle);
        String oldVersion = InstallPatchAction.getMaxOldVersion(INSTALL_BACK_FILE, bundle);
        LOGGER.info((Object)String.format(Locale.ROOT, "The uninstall sql should be exec is version %s to %s, bundle is %s", oldVersion, newVersion, bundle));
        for (SqlFile sqlFile : sqls) {
            String curVersion = sqlFile.getVersion();
            if (!sqlFile.getSrcName().contains(bundle) || !installedSQL.contains(curVersion) || curVersion.compareTo(oldVersion) <= 0 || curVersion.compareTo(newVersion) > 0) continue;
            LOGGER.info((Object)String.format(Locale.ROOT, "Add uninstall sql file : %s", sqlFile.getSrcName()));
            filterSqls.add(sqlFile);
        }
        return UnInstallPatchAction.sortSqlFile(filterSqls);
    }

    private static List<SqlFile> sortSqlFile(List<SqlFile> sqlList) {
        for (int i = 0; i < sqlList.size(); ++i) {
            for (int j = i + 1; j < sqlList.size(); ++j) {
                if (sqlList.get(i).compareTo(sqlList.get(j)) >= 0) continue;
                SqlFile maxFile = sqlList.get(j);
                sqlList.set(j, sqlList.get(i));
                sqlList.set(i, maxFile);
            }
        }
        return sqlList;
    }

    private static void delFiles(List<PatchFile> addFiles) {
        for (PatchFile file : addFiles) {
            for (Map.Entry<String, String> distPath : file.getPaths().entrySet()) {
                FileUtil.deleteFile(distPath.getValue() + file.getDistName());
            }
        }
    }

    private static void cpFiles(String backupPath, List<PatchFile> rpFiles, String sp) throws IOException {
        for (PatchFile file : rpFiles) {
            for (Map.Entry<String, String> distPath : file.getPaths().entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(backupPath).append(sp).append(distPath.getKey()).append(sp).append(file.getDistName());
                FileUtil.copyFile(sb.toString(), distPath.getValue() + file.getDistName());
                LOGGER.info((Object)String.format(Locale.ROOT, "Cp files, src:%s", file.getDistName()));
            }
        }
    }
}

