/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch.version;

import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.model.PatchFile;
import com.huawei.lego.common.patch.model.SqlFile;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class PatchChecker {
    private static final Log LOGGER = LogFactory.getInstance(PatchChecker.class);

    public static boolean isLegal(PatchDto dto) throws IOException, DocumentException, SAXException {
        boolean legal = false;
        try {
            legal = PatchChecker.checkSwNameVersion(dto) && PatchChecker.checkPatchVersion(dto) && PatchChecker.checkPatchIsComplete(dto);
        }
        catch (IOException | DocumentException | SAXException e) {
            LOGGER.error((Object)e, "Adjust Patch Version Error ");
            throw e;
        }
        return legal;
    }

    private static boolean checkPatchVersion(PatchDto dto) throws DocumentException, SAXException {
        boolean legal = false;
        String patchFolder = Singleton.getBasePath() + LegoResourceManager.getProValue("patch.save.folder");
        File folder = new File(patchFolder);
        if (!folder.exists()) {
            boolean flag = folder.mkdir();
            if (!flag) {
                LOGGER.error((Object)"Delete error!", "");
            }
            return true;
        }
        String patchDsFile = patchFolder + "/patch.xml";
        File oldPatchXml = new File(patchDsFile);
        if (!oldPatchXml.exists()) {
            return true;
        }
        String oldPatchVersion = PatchChecker.getoldPatchVersion(oldPatchXml);
        String newPatchVersion = dto.getPatchVersion();
        legal = PatchChecker.validVersion(oldPatchVersion, newPatchVersion);
        return legal;
    }

    private static boolean checkPatchIsComplete(PatchDto dto) {
        for (PatchFile addFile : dto.getAddFiles()) {
            if (dto.getPatchFileNames().contains(addFile.getSrcName())) continue;
            return false;
        }
        for (SqlFile sqlFile : dto.getInstallSqlFiles()) {
            if (dto.getPatchFileNames().contains(sqlFile.getSrcName())) continue;
            return false;
        }
        for (PatchFile rpFile : dto.getRpFiles()) {
            if (dto.getPatchFileNames().contains(rpFile.getSrcName())) continue;
            return false;
        }
        return true;
    }

    private static boolean validVersion(String id1, String id2) {
        return id1.compareTo(id2) < 0;
    }

    private static String getoldPatchVersion(File oldPatchXml) throws DocumentException, SAXException {
        SAXReader sax = new SAXReader();
        CommonUtil.setSecurityFeatures((SAXReader)sax);
        String patchversion = "";
        Document document = sax.read(oldPatchXml);
        Element eleTmp = (Element)document.selectSingleNode("/file/patchversion");
        patchversion = eleTmp.getTextTrim();
        return patchversion;
    }

    private static boolean checkSwNameVersion(PatchDto dto) throws IOException {
        boolean legal = false;
        FileInputStream fis = null;
        try {
            String deployFile = Singleton.getBasePath() + LegoResourceManager.getProValue("patch.software.name.version.file");
            Properties properties = new Properties();
            fis = new FileInputStream(deployFile);
            properties.load(fis);
            String fileNameVersion = properties.getProperty("version");
            String patchDependSwVersion = dto.getPatchVersion();
            if (fileNameVersion.equals(patchDependSwVersion)) {
                legal = true;
            }
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.error((Object)"CheckSwNameVersion failed, file not found.", "");
                throw new PatchException("Check sw name version failed.");
            }
            catch (Throwable throwable) {
                PatchChecker.closeStream(fis);
                throw throwable;
            }
        }
        PatchChecker.closeStream(fis);
        return legal;
    }

    private static void closeStream(FileInputStream fis) {
        if (null != fis) {
            try {
                fis.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close FileInputStream error", (Throwable)e, "");
            }
        }
    }
}

