/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.startup;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class ProUtil {
    public static final String START_STATUS_NOT_RUN = "0";
    public static final String START_STATUS_RUN = "1";
    public static final String START_STATUS_BACK_TIME_OUT = "2";
    public static final String START_STATUS_FORE_TIME_OUT = "3";
    private static final String START_STATUS = "start.status";
    private static final String START_FLAG_CONF = "startStatus.falg";
    private static String installPath = null;
    private static final Logger LOGGER = Logger.getLogger((String)"LEGO_START");

    private ProUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getPro(String fileName, String key) {
        Properties pro = new Properties();
        FileInputStream fileInput = null;
        File flagFile = null;
        try {
            flagFile = new File(fileName);
            fileInput = new FileInputStream(flagFile);
            pro.load(fileInput);
            Object object = pro.get(key);
            return object;
        }
        catch (IOException e) {
            LOGGER.error((Object)"GetPro error.", (Throwable)e);
        }
        finally {
            if (null != fileInput) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"FileInput.close error.", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getLocalPro(String fileName, String key) {
        Properties pro = new Properties();
        InputStream inStream = ProUtil.class.getResourceAsStream(fileName);
        try {
            pro.load(inStream);
            Object value = pro.get(key);
            LOGGER.info((Object)String.format(Locale.ROOT, "GetLocalPro key:%s,value:%s", key, ProUtil.replaceBlank(value.toString())));
            Object object = value;
            return object;
        }
        catch (IOException e) {
            LOGGER.error((Object)"GetPro error.", (Throwable)e);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"FileInput.close error.", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static int getHttpsPort() {
        String fileName = "RDInstalled.xml";
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            File file = new File(fileName);
            if (!file.exists()) {
                throw new DocumentException("get https port from RDInstalled.xml failed.");
            }
            Document document = sax.read(file);
            Element installElement = (Element)document.selectSingleNode("/install/httpsport");
            int httpsPort = Integer.valueOf(installElement.getText());
            LOGGER.info((Object)String.format(Locale.ROOT, "GetHttpsPort is %s", httpsPort));
            return httpsPort;
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"GetHttpPort error.", e);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"NumberFromatException error.", (Throwable)e);
        }
        return 0;
    }

    public static int getWebAJPPort() {
        String fileName = "server.xml";
        String path = ProUtil.getRuntimePath() + "Runtime" + File.separator + "Tomcat6" + File.separator + "conf" + File.separator;
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(path + fileName));
            List connectorElements = document.selectNodes("/Server/Service/Connector");
            for (Node connectorElement : connectorElements) {
                if (!"AJP/1.3".equalsIgnoreCase(((Element)connectorElement).attribute("protocol").getValue().trim())) continue;
                return Integer.valueOf(((Element)connectorElement).attribute("port").getValue());
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"GetWebAJPPort error.", e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getEscapeBundleName() {
        ArrayList<String> bundleNames = new ArrayList<String>();
        InputStream inStream = ProUtil.class.getResourceAsStream("/escape_bundle_name.xml");
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(inStream);
            List list = document.selectNodes("/bundel/exclude");
            for (Node el : list) {
                bundleNames.add(((Element)el).attributeValue("name"));
            }
        }
        catch (DocumentException | SAXException e1) {
            LOGGER.error((Object)"escape_bundle_name file is not exist.");
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"InStream.close error", (Throwable)e);
                }
            }
        }
        return bundleNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStartStatus() {
        Properties pro = new Properties();
        FileInputStream fileInput = null;
        File flagFile = null;
        String statusFlagFile = ProUtil.getRuntimePath() + "Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + START_FLAG_CONF;
        LOGGER.info((Object)"GetStartStatus start...");
        try {
            String status;
            flagFile = new File(statusFlagFile);
            if (!flagFile.exists()) {
                LOGGER.error((Object)"FlagFile is not exist");
                String string = null;
                return string;
            }
            fileInput = new FileInputStream(flagFile);
            pro.load(fileInput);
            String string = status = (String)pro.get(START_STATUS);
            return string;
        }
        catch (IOException e) {
            LOGGER.error((Object)"GetStartStatus error", (Throwable)e);
        }
        finally {
            if (null != fileInput) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"GetStartStatus fileInput.close error", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static void cleanStartStatusFlag() {
        String statusFlagFile = ProUtil.getRuntimePath() + "Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + START_FLAG_CONF;
        LOGGER.info((Object)"CleanStartStatusFlag start...");
        File flagFile = new File(statusFlagFile);
        if (!flagFile.exists()) {
            LOGGER.info((Object)"FlagFile is not exists.");
            return;
        }
        flagFile.setWritable(true);
        boolean flag = flagFile.delete();
        if (!flag) {
            LOGGER.error((Object)"Delete error!");
        }
        LOGGER.info((Object)"CleanStartStatusFlag succ.");
    }

    public static String getRuntimePath() {
        if (null != installPath) {
            return installPath;
        }
        String fileName = "RDInstalled.xml";
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(fileName));
            Element installElement = (Element)document.selectSingleNode("/install/installpath");
            String installPathStr = installElement.attribute("path").getValue();
            if (installPathStr != null) {
                boolean isSpLinux = installPathStr.endsWith("/");
                boolean isSpWindows = installPathStr.endsWith("\\");
                if (!isSpLinux && !isSpWindows) {
                    installPathStr = installPathStr + File.separator;
                }
                installPath = installPathStr;
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"GetRuntimePath error. ", e);
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(10009L);
            throw ex;
        }
        return installPath;
    }

    private static Object replaceBlank(Object value) {
        if (null != value && value instanceof String) {
            return value.toString().replaceAll("\t|\r|\n", "");
        }
        return value;
    }
}

