/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.startup;

import com.huawei.lego.common.startup.ProUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.base.model.Status;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class StartLinuxTest {
    private static final Logger LOGGER = Logger.getLogger((String)"LEGO_START");
    private static final int VALUE_24 = 24;
    private static final int VALUE_10 = 10;
    private static final String LEGO_PROPERTIES_FILE_NAME = "/installConf.properties";
    private static final int RETRY_TIME;

    public static void main(String[] args) {
        int i = 0;
        while (i++ < RETRY_TIME) {
            String status = ProUtil.getStartStatus();
            if (null != status) {
                LOGGER.info((Object)String.format(Locale.ROOT, "StartLinuxTest status : %s", status));
                if (status.equals(Status.STATUS_STARTED.toString())) {
                    LOGGER.info((Object)"Server Start successful!");
                    System.exit(0);
                }
            } else {
                LOGGER.info((Object)"Startup status is null!");
            }
            try {
                SystemPrint.systemPrintStr("Test failed, retry after sleep five seconds .");
                LOGGER.error((Object)"Test failed, retry after sleep five seconds .");
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("Test failed:" + e.getMessage()), (Throwable)e);
            }
        }
        LOGGER.error((Object)"Server Start failed!");
        SystemPrint.systemPrintStr("Server Start failed!");
        SystemExitUtil.exitFail();
    }

    static {
        String retStr = (String)ProUtil.getLocalPro(LEGO_PROPERTIES_FILE_NAME, "retry.linux.time");
        if (null != retStr) {
            SystemPrint.systemPrintStr("retStr is: " + retStr);
            RETRY_TIME = Integer.valueOf(retStr);
        } else {
            RETRY_TIME = 24;
        }
    }
}

