/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.user;

import com.huawei.ism.drm.wcc.util.kms.IamAccessMgr;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.lego.common.util.PasswordCheckUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ChangeOpSvcPwd {
    private static final Log LOG = LogFactory.getInstance(ChangeOpSvcPwd.class);
    private static final String LEGO_FILE = "/LegoRuntime/conf/lego.properties";
    private static final int MAX_RETRY_COUNT = 5;

    public static void main(String[] args) {
        ChangeOpSvcPwd changeOpSvcPwd = new ChangeOpSvcPwd();
        changeOpSvcPwd.verifyOldPwd();
        changeOpSvcPwd.modifyPwd();
        SystemExitUtil.exitOK();
    }

    private void modifyPwd() {
        int index = 0;
        while (index++ < 5) {
            char[] input = System.console().readPassword("Input new password of op_svc_eReplication:", new Object[0]);
            if (input == null || !PasswordCheckUtil.checkIamPasswordComplexity(String.valueOf(input))) {
                SystemPrint.systemPrintStr("Password invalid. The password must contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special characters `!@#$%^&*()-_=+[{]}|;:'\",./?");
                continue;
            }
            char[] confirm = System.console().readPassword("Confirm the password of op_svc_eReplication:", new Object[0]);
            if (!Arrays.equals(input, confirm)) {
                SystemPrint.systemPrintStr("The two passwords are inconsistent.");
                continue;
            }
            Optional result = IamAccessMgr.modifyPwd((String)String.valueOf(input));
            if (result.isPresent()) {
                SystemPrint.systemPrintStr(String.format(Locale.ENGLISH, "Modify password failed for reason: %s", result.get()));
                continue;
            }
            this.modifyPropertyFile(String.valueOf(input));
            SysPropertiesUtils.reloadProperties();
            Arrays.fill(input, '0');
            Arrays.fill(confirm, '0');
            break;
        }
        if (index > 5) {
            SystemPrint.systemPrintStr("Failed 5 times. Forced to quit.");
            System.exit(1);
        }
    }

    private void modifyPropertyFile(String input) {
        try {
            String encryptPwd = WccEncryptor.encode(input);
            Map<String, String> data = Collections.singletonMap("op.svc.eReplicationPwd", encryptPwd);
            String runtimePath = new File("../").getCanonicalPath();
            String legoPropertiesFile = runtimePath + LEGO_FILE;
            FileUtil.modifyPropFileUsingStr((String)legoPropertiesFile, data, (String)legoPropertiesFile);
        }
        catch (IOException e) {
            LOG.error((Object)"Modify op_svc_eReplication pwd error. e:%s", ExceptionUtil.getErrorMessage((Throwable)e));
            SystemPrint.systemPrintStr("Modify lego.properties failed. Check file exist.");
        }
    }

    private void verifyOldPwd() {
        String oldEncryptPwd = SysPropertiesUtils.getPropertyValue((String)"op.svc.eReplicationPwd");
        String oldPwd = WccEncryptor.decode(oldEncryptPwd);
        int index = 0;
        while (index++ < 5) {
            char[] inputPwd = System.console().readPassword("Input old password of op_svc_eReplication:", new Object[0]);
            if (inputPwd != null && StringUtils.equals((CharSequence)oldPwd, (CharSequence)String.valueOf(inputPwd))) {
                Arrays.fill(inputPwd, '0');
                break;
            }
            SystemPrint.systemPrintStr("Old password error.");
        }
        if (index > 5) {
            SystemPrint.systemPrintStr("Failed 5 times. Forced to quit.");
            System.exit(1);
        }
    }
}

