/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.user;

import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.ism.drm.wcc.rest.client.ResponseResult;
import com.huawei.ism.drm.wcc.rest.client.RestAdapter;
import com.huawei.ism.drm.wcc.rest.client.RestClient;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.kms.IamAccessMgr;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.common.ha.HAInfo;
import com.huawei.lego.common.util.PasswordCheckUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.core5.http.HttpEntity;

public class SyncUnitePassword {
    private static final Log LOG = LogFactory.getInstance(SyncUnitePassword.class);
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILED = 1;
    private static final int MAX_RETRY_COUNT = 5;
    private static final int MM_APP_ACCOUNT = 5;
    private static final int NOT_SUPPORT_MODIFY = 3;
    private static final int ADD_OPERATE_TYPE = 0;
    private static final int DELETE_OPERATE_TYPE = 2;
    private static final String COMPONENT_NAME = "eReplication";
    private static final String SUCCESS_CODE = "00000000";
    private static final String IAM_DESCRIPTION = "{\"zh-cn\":\"IAM\u9274\u6743\u5e10\u53f7\",\"en-us\":\"IAM authentication account\"}";
    private static final Set<String> IAM_USER_SET = Stream.of("op_svc_eReplication", "csha_service", "csdr_service", "vha_service").collect(Collectors.toSet());
    private static String token;

    public static void main(String[] args) {
        SyncUnitePassword syncUnitePassword = new SyncUnitePassword();
        String userName = syncUnitePassword.checkAndGetName();
        char[] password = syncUnitePassword.checkAndGetPwd(userName);
        int result = syncUnitePassword.sync(userName, password);
        Arrays.fill(password, '0');
        System.exit(result);
    }

    private int sync(String userName, char[] password) {
        RestClient client;
        JSONObject deleteRequest = this.buildAccountRequest(userName, password, 2);
        JSONObject addRequest = this.buildAccountRequest(userName, password, 0);
        String urlStr = SysPropertiesUtils.getPropertyValue((String)"config.hcs.er.om.float");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            SystemPrint.systemPrintStr("Unite Password account register failed, server urlStr is empty.");
            return 1;
        }
        try {
            String[] endpoints = urlStr.split(":");
            client = new RestClient(endpoints[0], endpoints[1]);
        }
        catch (AppException e) {
            LOG.error((Object)("Register account failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            return 1;
        }
        if (this.register(client, deleteRequest) && this.register(client, addRequest)) {
            return 0;
        }
        return 1;
    }

    private boolean register(RestClient client, JSONObject request) {
        ResponseResult responseResult;
        try {
            responseResult = client.doPost("/rest/mounpwdservice/v1/account", Collections.singletonMap("X-Auth-Token", token), request.toString());
        }
        catch (AppException e) {
            LOG.error((Object)("Register account request failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            return false;
        }
        if (responseResult.isSuccess()) {
            String response = RestAdapter.getResponseContent((HttpEntity)responseResult.getResponse().getEntity());
            if (VerifyUtil.isEmpty((String)response)) {
                SystemPrint.systemPrintStr("Unite Password account register response is empty.");
                return false;
            }
            LOG.info((Object)"Register account result.", response);
            JSONObject result = JSONObject.fromObject((Object)response);
            if (!VerifyUtil.isEmpty((Map)result) && result.containsKey((Object)"code")) {
                String resultCode = result.getString("code");
                return SUCCESS_CODE.equals(resultCode);
            }
        }
        return false;
    }

    private JSONObject buildAccountRequest(String userName, char[] password, int operateType) {
        JSONArray subComponents = new JSONArray();
        JSONObject subComponent = new JSONObject();
        subComponent.put((Object)"subComponentName", (Object)COMPONENT_NAME);
        Account account = this.getIamAccount(userName, String.valueOf(password), operateType);
        subComponent.put((Object)"createdAccountList", Collections.singletonList(account));
        subComponents.add((Object)subComponent);
        JSONObject accountJSONObject = new JSONObject();
        accountJSONObject.put((Object)"componentName", (Object)COMPONENT_NAME);
        accountJSONObject.put((Object)"subComponents", (Object)subComponents);
        return accountJSONObject;
    }

    private Account getIamAccount(String userName, String passwd, int operateType) {
        Account account = new Account();
        account.setAccountName(userName);
        account.setAccountType(5);
        account.setPasswd(passwd);
        account.setOldPasswd(passwd);
        account.setRegion(SysPropertiesUtils.getRegionProperty((String)"config.hcs.node.region"));
        HAInfo haInfo = HAInfo.getHAInfo();
        account.setIp(haInfo.getFloatIP());
        account.setAccountDescription(IAM_DESCRIPTION);
        account.setPasswdExpires(Long.valueOf(-1L));
        account.setOperationType(operateType);
        account.setUrlValid("/ws/bcs/validPasswd");
        account.setModifyType(3);
        return account;
    }

    private char[] checkAndGetPwd(String userName) {
        int index = 0;
        char[] pwd = null;
        while (index++ < 5) {
            pwd = System.console().readPassword("Enter the password of the user to be synchronized:", new Object[0]);
            if (pwd == null || !PasswordCheckUtil.checkIamPasswordComplexity(String.valueOf(pwd))) {
                SystemPrint.systemPrintStr("Password invalid.");
                continue;
            }
            String domainName = userName.startsWith("op_svc") ? "op_svc_eReplication" : "op_service";
            KmcInstance.initComponent((String)(PathUtil.getInstallPath() + "/LegoRuntime/conf/wcc/"), (boolean)true);
            Optional domainToken = IamAccessMgr.getDomainToken((String)domainName, (String)userName, (String)String.valueOf(pwd));
            if (domainToken.isPresent()) {
                token = (String)domainToken.get();
                return pwd;
            }
            SystemPrint.systemPrintStr("Password incorrect.");
        }
        SystemPrint.systemPrintStr("Operation locked. Please retry after 15 minutes.");
        System.exit(1);
        return pwd;
    }

    private String checkAndGetName() {
        String userName = System.console().readLine("Enter the user name to be synchronized:", new Object[0]);
        if (userName == null || !IAM_USER_SET.contains(userName)) {
            SystemPrint.systemPrintStr("Not support User name.");
            System.exit(1);
        }
        return userName;
    }
}

