/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.dto.Validport;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.InstallType;
import com.huawei.lego.common.dto.Custparm;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class InitBundleXmlTool {
    private static final Log LOGGER = LogFactory.getInstance(InitBundleXmlTool.class);
    private static final Map<String, File> BUNDLE_XML_MAP = new LinkedHashMap<String, File>();
    private static final String INSTALL_FILENAME = InstallConstant.getsBasePath() + "PlatFrom/bundle.xml";
    private static final String PRODUCT_FOLDER = InstallConstant.getsBasePath() + "Plug-In";

    private static ProductBundles assembProdBund(Element productEle, ProductBundles bundle) {
        bundle.setId(productEle.attributeValue("id"));
        bundle.setVersion(productEle.attributeValue("version"));
        bundle.setName(productEle.attributeValue("name"));
        bundle.setDescription(productEle.attributeValue("description"));
        bundle.setSize(productEle.attributeValue("size"));
        bundle.setBundlePath(productEle.attributeValue("bundlepathname"));
        bundle.setNeeded(Boolean.parseBoolean(productEle.attributeValue("required")));
        bundle.setDependson(productEle.attributeValue("dependson"));
        bundle.setDependsonVersion(productEle.attributeValue("dependsonversion"));
        List fronJarList = productEle.elements("frontendjar");
        ArrayList<String> frontEndJarList = new ArrayList<String>();
        for (Object object : fronJarList) {
            Element frontJarELe = (Element)object;
            frontEndJarList.add(frontJarELe.getTextTrim());
        }
        bundle.setFrontEndJar(frontEndJarList);
        List backJarList = productEle.elements("backendjar");
        ArrayList<String> backEndJarList = new ArrayList<String>();
        for (Object object : backJarList) {
            Element backJarELe = (Element)object;
            backEndJarList.add(backJarELe.getTextTrim());
        }
        bundle.setBackEndJar(backEndJarList);
        List initscriptEles = productEle.elements("initscript");
        for (Object object : initscriptEles) {
            Element initscriptEle = (Element)object;
            String os = initscriptEle.attributeValue("os");
            if ("windows".equalsIgnoreCase(os)) {
                bundle.setWindowsInitCmd(initscriptEle.getTextTrim());
                continue;
            }
            if ("linux".equalsIgnoreCase(os)) {
                bundle.setLinuxInitCmd(initscriptEle.getTextTrim());
                continue;
            }
            LOGGER.warn((Object)("The os is not supported. os:" + os));
        }
        List uniscriptEles = productEle.elements("finalizescript");
        for (Object object : uniscriptEles) {
            InitBundleXmlTool.setBundle(bundle, (Element)object);
        }
        if (InstallType.getInstallType().contains("guiInstall")) {
            InitBundleXmlTool.setPort(productEle, bundle);
        }
        InitBundleXmlTool.extracted(productEle, bundle);
        return bundle;
    }

    private static void setBundle(ProductBundles bundle, Element object) {
        Element uniscriptEle = object;
        String os = uniscriptEle.attributeValue("os");
        if ("windows".equalsIgnoreCase(os)) {
            bundle.setWindowsUnsCmd(uniscriptEle.getTextTrim());
        } else if ("linux".equalsIgnoreCase(os)) {
            bundle.setLinuxUnsCmd(uniscriptEle.getTextTrim());
        } else {
            LOGGER.warn((Object)("The os is not supported. os:" + os));
        }
    }

    private static void setPort(Element productEle, ProductBundles bundle) {
        List portElements = productEle.elements("validport");
        if (null != portElements && !portElements.isEmpty()) {
            ArrayList<Validport> portList = new ArrayList<Validport>();
            for (Element element : portElements) {
                Validport port = new Validport();
                port.setId(element.attributeValue("id"));
                port.setName(element.attributeValue("name"));
                port.setDefaultvalue(Integer.parseInt(element.attributeValue("defaultvalue")));
                portList.add(port);
            }
            bundle.setValidportList(portList);
        }
    }

    private static void extracted(Element productEle, ProductBundles productBundles) {
        Element extendEle;
        List custParams;
        if (InstallType.getInstallType().contains("guiInstall") && null != (custParams = productEle.elements("custparm")) && !custParams.isEmpty()) {
            ArrayList<Custparm> custParmList = new ArrayList<Custparm>();
            for (Element element : custParams) {
                Custparm cp = new Custparm();
                cp.setId(element.attributeValue("id"));
                cp.setName(element.attributeValue("name"));
                cp.setDefaultvalue(element.attributeValue("defaultvalue"));
                custParmList.add(cp);
            }
            productBundles.setCustParmList(custParmList);
        }
        if (null != (extendEle = productEle.element("extend"))) {
            Element callBackEle;
            Element cardEle = extendEle.element("cardclass");
            if (null != cardEle) {
                productBundles.setExtendCardClz(cardEle.attributeValue("class"));
                productBundles.setExtendCardName(cardEle.attributeValue("name"));
            }
            if (null != (callBackEle = extendEle.element("callbackclass"))) {
                productBundles.setExtendCallBackClz(callBackEle.attributeValue("class"));
            }
        }
    }

    public static String getDBType() {
        return "Gauss";
    }

    public static Map<String, PlatformBundles> initPlatFormBundls() {
        return InitBundleXmlTool.assembPlatFormBundls(INSTALL_FILENAME);
    }

    public static Map<String, ProductBundles> initProductBundls() throws SignatureException {
        File productDir = new File(PRODUCT_FOLDER);
        InitBundleXmlTool.initBundleXml(productDir);
        Collection<File> collection = BUNDLE_XML_MAP.values();
        SAXReader sax = new SAXReader();
        LinkedHashMap<String, ProductBundles> tmp = new LinkedHashMap<String, ProductBundles>();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            for (File file : collection) {
                if (!file.exists()) {
                    LOGGER.error((Object)("File not found: " + file.getName()), "");
                    continue;
                }
                Document document = sax.read(file);
                List list = document.selectNodes("/install/product");
                Element productEle = (Element)list.get(0);
                ProductBundles productBundle = new ProductBundles();
                InitBundleXmlTool.assembProdBund(productEle, productBundle);
                tmp.put(productBundle.getId(), productBundle);
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)e, "InitProductBundls Error!");
        }
        return tmp;
    }

    private static Map<String, PlatformBundles> assembPlatFormBundls(String fileName) {
        SAXReader sax = new SAXReader();
        LinkedHashMap<String, PlatformBundles> tmp = new LinkedHashMap<String, PlatformBundles>();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                LOGGER.error((Object)("File is not found: " + file.getName()));
                throw new DocumentException();
            }
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(fileName));
            List list = document.selectNodes("/install/platform");
            for (Object obj : list) {
                Element el = (Element)obj;
                PlatformBundles bundle = InitBundleXmlTool.parsePlatBundle(el);
                tmp.put(bundle.getId(), bundle);
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)e, "AssembPlatFormBundls Error!");
        }
        return tmp;
    }

    private static void initBundleXml(File productDir) throws SignatureException {
        File[] products;
        for (File file : products = productDir.listFiles()) {
            if (file.isDirectory()) {
                InitBundleXmlTool.initBundleXml(file);
                continue;
            }
            if (!file.getName().equals("bundle.xml")) continue;
            SignVerifier.getInstance().verify(file);
            BUNDLE_XML_MAP.put(productDir.getName(), file);
        }
    }

    private static PlatformBundles parsePlatBundle(Element el) {
        PlatformBundles bundle = new PlatformBundles();
        Attribute id = el.attribute("id");
        bundle.setId(id.getValue());
        Attribute version = el.attribute("version");
        bundle.setVersion(version.getValue());
        Attribute name = el.attribute("name");
        bundle.setName(name.getValue());
        Attribute needed = el.attribute("required");
        bundle.setNeeded(Boolean.parseBoolean(needed.getValue()));
        Attribute description = el.attribute("description");
        bundle.setDescription(description.getValue());
        Attribute size = el.attribute("size");
        bundle.setSize(size.getValue());
        bundle.setDependson(el.attributeValue("dependson"));
        bundle.setDependsonVersion(el.attributeValue("dependsonversion"));
        List backjarEleList = el.elements("backendjar");
        ArrayList<String> jarList = new ArrayList<String>();
        for (Element element : backjarEleList) {
            jarList.add(element.getTextTrim());
        }
        bundle.setJarList(jarList);
        List fronJarList = el.elements("frontendjar");
        ArrayList<String> frontEndJarList = new ArrayList<String>();
        for (Object object : fronJarList) {
            Element frontJarELe = (Element)object;
            frontEndJarList.add(frontJarELe.getTextTrim());
        }
        bundle.setFrontJarList(frontEndJarList);
        List portEle = el.elements("validport");
        if (null != portEle && !portEle.isEmpty()) {
            ArrayList<Validport> portList = new ArrayList<Validport>();
            for (Element element : portEle) {
                Validport port = new Validport();
                port.setId(element.attributeValue("id"));
                port.setName(element.attributeValue("name"));
                port.setDefaultvalue(Integer.parseInt(element.attributeValue("defaultvalue")));
                portList.add(port);
            }
            bundle.setValidportList(portList);
        }
        return bundle;
    }

    public static boolean isNewVersion(String oldVersion, String newVersion) {
        boolean isNewVersion = false;
        boolean isBreak = false;
        if (VerifyUtil.isEmpty((String)oldVersion) || VerifyUtil.isEmpty((String)newVersion)) {
            LOGGER.error((Object)("Check version failed, old=" + oldVersion + ", new Version=" + newVersion), "");
            return isNewVersion;
        }
        String[] id1s = oldVersion.split("\\.");
        String[] id2s = newVersion.split("\\.");
        int length = Math.min(id1s.length, id2s.length);
        try {
            for (int i = 0; i < length; ++i) {
                if (Integer.parseInt(id1s[i]) < Integer.parseInt(id2s[i])) {
                    isNewVersion = true;
                    isBreak = true;
                    break;
                }
                if (Integer.parseInt(id1s[i]) <= Integer.parseInt(id2s[i])) continue;
                isNewVersion = false;
                isBreak = true;
                break;
            }
            if (!isBreak && id1s.length < id2s.length) {
                isNewVersion = true;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e, "NumberFormatException, oldVersion: " + oldVersion + ", newVersion: " + newVersion);
        }
        return isNewVersion;
    }
}

