/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.dto.Validport;
import com.huawei.lego.common.InstallType;
import com.huawei.lego.common.Singleton;
import com.huawei.lego.common.dto.Custparm;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.install.NetWorkPanel;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class InitInstalledXmlTool {
    private static final Log LOG = LogFactory.getInstance(InitInstalledXmlTool.class);
    private static final String INSTALLED_FILE = OSInformation.getInstalledFile();
    private static final String INSTALLED_FILE_LEGO = OSInformation.getUserHomePath() + "/legoInstalled.xml";
    private static InstalledSystem systemInfo = null;

    private static void setSystemInfo(InstalledSystem system) {
        systemInfo = system;
    }

    public static void initSystemInfo() {
        systemInfo = InitInstalledXmlTool.getInstalledSystem();
    }

    public static InstalledSystem getInstalledSystem() {
        if (null != systemInfo) {
            return systemInfo;
        }
        File file = new File(INSTALLED_FILE);
        InstalledSystem system = new InstalledSystem();
        try {
            if (!file.exists()) {
                LOG.error((Object)("GetInstalledSystem, file is not exists: " + file.getName()), "");
                throw new DocumentException("RDInstalled.xml is not exists.");
            }
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            system.setInstallpath(InitInstalledXmlTool.getInstalledPath(document));
            system.setDbInfor(InitInstalledXmlTool.getDatabaseInfo(system.getInstallpath(), document));
            system.setNetWorkPanel(InitInstalledXmlTool.getNetWorkInfo(document));
            system.setPtMap(InitInstalledXmlTool.getInstalledPlatFormBundls(document));
            system.setPdMap(InitInstalledXmlTool.getInstalledProductBundls(document));
            InitInstalledXmlTool.setSystemInfo(system);
        }
        catch (DocumentException | SAXException e) {
            LOG.error((Object)e, "GetInstalledSystem Error!");
        }
        catch (InstallException e) {
            LOG.error((Object)e, "Get system info failed.");
            e.setErrorCode(10001L);
            throw e;
        }
        return system;
    }

    private static DataBaseInfo getDatabaseInfo(String installPath, Document document) {
        List list = document.selectNodes("/install/database");
        if (null != list && !list.isEmpty()) {
            LOG.info((Object)"Get database config from RDInstalled.xml", "");
            return InitInstalledXmlTool.getInstalledDBInfo(document);
        }
        LOG.info((Object)"Get database config from system.xml", "");
        return InitInstalledXmlTool.getDatabaseConfig(installPath);
    }

    private static DataBaseInfo getDatabaseConfig(String installPath) {
        String dbFile = installPath + File.separator + LegoResourceManager.getProValue("db.config.file");
        File file = new File(dbFile);
        if (!file.exists()) {
            LOG.error((Object)"Get database config failed, system.xml not found.", "");
            throw new PatchException("");
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            return InitInstalledXmlTool.getInstalledDBInfo(document);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get database config, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("");
        }
    }

    private static DataBaseInfo getInstalledDBInfo(Document document) {
        DataBaseInfo dbInfo = new DataBaseInfo();
        List list = document.selectNodes("/install/database");
        if (null != list && !list.isEmpty()) {
            Element ele = (Element)list.get(0);
            dbInfo.setDbHost(ele.attributeValue("dbhost"));
            dbInfo.setDbPort(ele.attributeValue("dbport"));
            dbInfo.setDbType(ele.attributeValue("type"));
            dbInfo.setDbaUsername(ele.attributeValue("dbuserName"));
            dbInfo.setDbaPassword(WccEncryptor.retryDecode(ele.attributeValue("dbpassword")));
            dbInfo.setManagerUsername(ele.attributeValue("manageruserName"));
            dbInfo.setManagerPassword(WccEncryptor.retryDecode(ele.attributeValue("managerpassword")));
            dbInfo.setDbFilePath(ele.attributeValue("dbfilepath"));
            dbInfo.setDbPath(ele.attributeValue("dbpath"));
        }
        if (!ParamCheck.checkDBParam(dbInfo)) {
            LOG.error((Object)"CheckDBParam failed.", "");
            throw new InstallException("GetInstalledDBInfo failed.");
        }
        return dbInfo;
    }

    private static NetWorkPanel getNetWorkInfo(Document document) {
        NetWorkPanel panel = new NetWorkPanel();
        panel.setWorkMangIp(InitInstalledXmlTool.getHttpsIp(document));
        panel.setWorkMangHttpsPort(InitInstalledXmlTool.getHttpsPort(document));
        panel.setWorkMangHttpPort(InitInstalledXmlTool.getHttpPort(document));
        if (OSInformation.isLinux()) {
            panel.setWorkMangFloatIp(InitInstalledXmlTool.getFloatIp(document));
        }
        InitInstalledXmlTool.getSecondNetConfig(document, panel);
        return panel;
    }

    public static String getInstallPath() {
        String path = "";
        File file = new File(INSTALLED_FILE);
        if (!file.exists()) {
            LOG.error((Object)"Can not find the RDinstalled.xml.", "");
            return path;
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(file);
            path = InitInstalledXmlTool.getInstalledPath(document);
        }
        catch (Exception e) {
            LOG.error((Object)("Get install path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return path;
    }

    private static String getHttpPort(Document document) {
        String httpPort = "";
        List list = document.selectNodes("/install/httport");
        if (null != list && !list.isEmpty()) {
            Element ele = (Element)list.get(0);
            httpPort = ele.getTextTrim();
        }
        return httpPort;
    }

    private static String getHttpsPort(Document document) {
        String httpPort = "";
        List list = document.selectNodes("/install/httpsport");
        if (null != list && !list.isEmpty()) {
            Element ele = (Element)list.get(0);
            httpPort = ele.getTextTrim();
        }
        if (!ParamCheck.checkPort(httpPort)) {
            LOG.error((Object)"GetHttpsPort failed. ", "");
            throw new InstallException("getHttpsPort failed.");
        }
        return httpPort;
    }

    private static String getHttpsIp(Document document) {
        String httpsip = "";
        List list = document.selectNodes("/install/httpsip");
        if (null != list && !list.isEmpty()) {
            Element ele = (Element)list.get(0);
            httpsip = ele.getTextTrim();
        }
        if (!ParamCheck.checkIpAddress(httpsip)) {
            LOG.error((Object)"Https ip is error.", "");
            throw new InstallException("https ip is error.");
        }
        return httpsip;
    }

    private static String getFloatIp(Document document) {
        String floatip = "";
        List list = document.selectNodes("/install/floatip");
        if (null != list && !list.isEmpty()) {
            Element ele = (Element)list.get(0);
            floatip = ele.getTextTrim();
        }
        return floatip;
    }

    private static void getSecondNetConfig(Document document, NetWorkPanel panel) {
        List list = document.selectNodes("/install/secondnet");
        if (null != list && !list.isEmpty()) {
            String httpsPort;
            Element ele = (Element)list.get(0);
            panel.setEnableSecondIp(Boolean.parseBoolean(ele.attributeValue("isEnable")));
            if (!panel.isEnableSecondIp()) {
                LOG.info((Object)"Secnod net config is not enable.", "");
                return;
            }
            String ip = ele.attributeValue("sip");
            if (!VerifyUtil.isEmpty((String)ip) && !ParamCheck.checkIpAddress(ip)) {
                LOG.error((Object)("The ip address is error, ip=" + ip), "");
                throw new PatchException("");
            }
            panel.setSecondip(ip);
            if (OSInformation.isLinux()) {
                String floatip = ele.attributeValue("sfloatip");
                if (!VerifyUtil.isEmpty((String)floatip) && !ParamCheck.checkIpAddress(floatip)) {
                    LOG.error((Object)("The floatip address is error, floatip=" + floatip), "");
                    throw new PatchException("");
                }
                panel.setSecondFloatIp(floatip);
            }
            if (!VerifyUtil.isEmpty((String)(httpsPort = ele.attributeValue("shttpsport"))) && !ParamCheck.checkPort(httpsPort)) {
                LOG.error((Object)("Https port is error, port=" + httpsPort), "");
                throw new PatchException("");
            }
            panel.setSecondHttpsPort(httpsPort);
            String httpPort = ele.attributeValue("shttpport");
            if (!VerifyUtil.isEmpty((String)httpPort) && !ParamCheck.checkPort(httpPort)) {
                LOG.error((Object)("Http port is error, port=" + httpPort), "");
                throw new PatchException("");
            }
            panel.setSecondHttpPort(httpPort);
        }
    }

    private static String getInstalledPath(Document document) {
        String installedPath = "";
        List list = document.selectNodes("/install/installpath");
        if (null != list && !list.isEmpty()) {
            Element ele = (Element)list.get(0);
            installedPath = ele.attributeValue("path");
        }
        if (!ParamCheck.checkIsPath(installedPath)) {
            LOG.error((Object)"Get intall path failed.", "");
            throw new InstallException("getInstalledPath error.");
        }
        return installedPath;
    }

    private static Map<String, PlatformBundles> getInstalledPlatFormBundls(Document document) {
        LinkedHashMap<String, PlatformBundles> tmp = new LinkedHashMap<String, PlatformBundles>();
        List list = document.selectNodes("/install/platform");
        for (Object obj : list) {
            Element el = (Element)obj;
            PlatformBundles bundles = new PlatformBundles();
            Attribute id = el.attribute("id");
            bundles.setId(id.getValue());
            Attribute version = el.attribute("version");
            bundles.setVersion(version.getValue());
            Attribute name = el.attribute("name");
            bundles.setName(name.getValue());
            Attribute needed = el.attribute("required");
            bundles.setNeeded(Boolean.parseBoolean(needed.getValue()));
            Attribute description = el.attribute("description");
            bundles.setDescription(description.getValue());
            Attribute size = el.attribute("size");
            bundles.setSize(size.getValue());
            bundles.setDependson(el.attributeValue("dependson"));
            bundles.setDependsonVersion(el.attributeValue("dependsonversion"));
            List jarEleList = el.elements("jar");
            ArrayList<String> jarList = new ArrayList<String>();
            for (Element element : jarEleList) {
                jarList.add(element.getTextTrim());
            }
            bundles.setJarList(jarList);
            List portEleList = el.elements("validport");
            if (null != portEleList && !portEleList.isEmpty()) {
                ArrayList<Validport> portList = new ArrayList<Validport>();
                for (Element element : portEleList) {
                    Validport port = new Validport();
                    port.setId(element.attributeValue("id"));
                    port.setName(element.attributeValue("name"));
                    port.setDefaultvalue(Integer.parseInt(element.attributeValue("defaultvalue")));
                    portList.add(port);
                }
                bundles.setValidportList(portList);
            }
            tmp.put(bundles.getId(), bundles);
        }
        return tmp;
    }

    private static void getInstallProductsBundles1(ProductBundles productBundle, Element productEle) {
        Element extendEle;
        List custParamList;
        List portEle = productEle.elements("validport");
        if (null != portEle && !portEle.isEmpty()) {
            ArrayList<Validport> portList = new ArrayList<Validport>();
            for (Object element : portEle) {
                Validport port = new Validport();
                port.setId(element.attributeValue("id"));
                port.setName(element.attributeValue("name"));
                port.setDefaultvalue(Integer.parseInt(element.attributeValue("defaultvalue")));
                portList.add(port);
            }
            productBundle.setValidportList(portList);
        }
        if (InstallType.getInstallType().contains("guiInstall") && null != (custParamList = productEle.elements("custparm")) && !custParamList.isEmpty()) {
            ArrayList<Custparm> custParmList = new ArrayList<Custparm>();
            for (Element element : custParamList) {
                Custparm custparm = new Custparm();
                custparm.setId(element.attributeValue("id"));
                custparm.setName(element.attributeValue("name"));
                custparm.setDefaultvalue(element.attributeValue("defaultvalue"));
                custParmList.add(custparm);
            }
            productBundle.setCustParmList(custParmList);
        }
        if (null != (extendEle = productEle.element("extend"))) {
            Element callBackEle;
            Element cardEle = extendEle.element("cardclass");
            if (null != cardEle) {
                productBundle.setExtendCardClz(cardEle.attributeValue("class"));
                productBundle.setExtendCardName(cardEle.attributeValue("name"));
            }
            if (null != (callBackEle = extendEle.element("callbackclass"))) {
                productBundle.setExtendCallBackClz(callBackEle.attributeValue("class"));
            }
        }
    }

    private static Map<String, ProductBundles> getInstalledProductBundls(Document document) {
        LinkedHashMap<String, ProductBundles> tmp = new LinkedHashMap<String, ProductBundles>();
        List list = document.selectNodes("/install/product");
        for (Object productObj : list) {
            Object object3;
            Element productEle = (Element)productObj;
            ProductBundles productBundle = new ProductBundles();
            productBundle.setId(productEle.attributeValue("id"));
            productBundle.setVersion(productEle.attributeValue("version"));
            productBundle.setName(productEle.attributeValue("name"));
            productBundle.setDescription(productEle.attributeValue("description"));
            productBundle.setSize(productEle.attributeValue("size"));
            productBundle.setBundlePath(productEle.attributeValue("bundlepathname"));
            productBundle.setNeeded(Boolean.parseBoolean(productEle.attributeValue("required")));
            productBundle.setDependson(productEle.attributeValue("dependson"));
            productBundle.setDependsonVersion(productEle.attributeValue("dependsonversion"));
            List fronJarList = productEle.elements("frontendjar");
            ArrayList<String> frontEndJarList = new ArrayList<String>();
            for (Object object2 : fronJarList) {
                Element frontJarELe = (Element)object2;
                frontEndJarList.add(frontJarELe.getTextTrim());
            }
            productBundle.setFrontEndJar(frontEndJarList);
            List backJarList = productEle.elements("backendjar");
            ArrayList<String> backEndJarList = new ArrayList<String>();
            for (Object object3 : backJarList) {
                Element backJarELe = (Element)object3;
                backEndJarList.add(backJarELe.getTextTrim());
            }
            productBundle.setBackEndJar(backEndJarList);
            List initscriptEles = productEle.elements("initscript");
            object3 = initscriptEles.iterator();
            while (object3.hasNext()) {
                Object object4 = object3.next();
                Element initscriptEle = (Element)object4;
                if ("windows".equalsIgnoreCase(initscriptEle.attributeValue("os"))) {
                    productBundle.setWindowsInitCmd(initscriptEle.getTextTrim());
                    continue;
                }
                if (!"linux".equalsIgnoreCase(initscriptEle.attributeValue("os"))) continue;
                productBundle.setLinuxInitCmd(initscriptEle.getTextTrim());
            }
            List uniscriptEles = productEle.elements("finalizescript");
            for (Object object5 : uniscriptEles) {
                InitInstalledXmlTool.setBundleUnsCmd(productBundle, (Element)object5);
            }
            InitInstalledXmlTool.getInstallProductsBundles1(productBundle, productEle);
            tmp.put(productBundle.getId(), productBundle);
        }
        return tmp;
    }

    private static void setBundleUnsCmd(ProductBundles productBundle, Element uniscriptEle) {
        if ("windows".equalsIgnoreCase(uniscriptEle.attributeValue("os"))) {
            productBundle.setWindowsUnsCmd(uniscriptEle.getTextTrim());
        } else if ("linux".equalsIgnoreCase(uniscriptEle.attributeValue("os"))) {
            productBundle.setLinuxUnsCmd(uniscriptEle.getTextTrim());
        }
    }

    public static Map<String, ProductBundles> getInstalledProductBundlsToCli(String installFileCli) {
        File file = new File(FilenameUtils.normalize((String)installFileCli));
        SAXReader sax = new SAXReader();
        LinkedHashMap<String, ProductBundles> tmp = new LinkedHashMap<String, ProductBundles>();
        try {
            if (!file.exists()) {
                return tmp;
            }
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List list = document.selectNodes("/install/product");
            for (Object productObj : list) {
                Element productEle = (Element)productObj;
                ProductBundles productBundle = new ProductBundles();
                productBundle.setId(productEle.attributeValue("id"));
                productBundle.setVersion(productEle.attributeValue("version"));
                productBundle.setName(productEle.attributeValue("name"));
                productBundle.setDescription(productEle.attributeValue("description"));
                productBundle.setSize(productEle.attributeValue("size"));
                productBundle.setBundlePath(productEle.attributeValue("bundlepathname"));
                productBundle.setNeeded(Boolean.parseBoolean(productEle.attributeValue("required")));
                productBundle.setDependson(productEle.attributeValue("dependson"));
                productBundle.setDependsonVersion(productEle.attributeValue("dependsonversion"));
                tmp.put(productBundle.getId(), productBundle);
            }
            return InitInstalledXmlTool.sortBundle(tmp);
        }
        catch (DocumentException | SAXException e) {
            return tmp;
        }
    }

    private static Map<String, ProductBundles> sortBundle(Map<String, ProductBundles> bundle) {
        return new TreeMap<String, ProductBundles>(bundle);
    }

    private static boolean checkWindowsInstallFile() {
        File file = new File(INSTALLED_FILE);
        if (!file.exists()) {
            File file1 = new File(INSTALLED_FILE_LEGO);
            if (!file1.exists()) {
                return false;
            }
            if (InitInstalledXmlTool.checkRDContent(INSTALLED_FILE_LEGO)) {
                InitInstalledXmlTool.renamefile(INSTALLED_FILE_LEGO, INSTALLED_FILE);
            } else {
                return false;
            }
        }
        try {
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List list = document.selectNodes("/install");
            if (null == list || list.isEmpty()) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.info((Object)String.format(Locale.ROOT, "Document read exception: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
        return true;
    }

    private static boolean checkLinuxRDInstall() {
        String rootFilePath = OSInformation.getCurrentUserHomePaht() + "/" + LegoResourceManager.getProValue("install.params.installed.file");
        File file = new File(INSTALLED_FILE);
        if (!file.exists() && !(file = new File(rootFilePath)).exists()) {
            return false;
        }
        try {
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List list = document.selectNodes("/install");
            if (null == list || list.isEmpty()) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.info((Object)String.format(Locale.ROOT, "Document read exception: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
            return false;
        }
        return true;
    }

    private static boolean checkLinuxLegoInstall() {
        String srcFile = INSTALLED_FILE_LEGO;
        String dstFile = INSTALLED_FILE;
        String rootFilePath = OSInformation.getCurrentUserHomePaht() + "/legoInstalled.xml";
        File file = new File(srcFile);
        if (!file.exists()) {
            file = new File(rootFilePath);
            if (!file.exists()) {
                return false;
            }
            srcFile = rootFilePath;
            dstFile = OSInformation.getCurrentUserHomePaht() + "/" + LegoResourceManager.getProValue("install.params.installed.file");
        }
        if (!InitInstalledXmlTool.checkRDContent(srcFile)) {
            return false;
        }
        InitInstalledXmlTool.renamefile(srcFile, dstFile);
        try {
            file = new File(dstFile);
            if (!file.exists()) {
                LOG.error((Object)("File is not found: " + file.getName()), "");
                throw new InstallException("File not found.");
            }
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List list = document.selectNodes("/install");
            if (null == list || list.isEmpty()) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Document read exception." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            return false;
        }
        return true;
    }

    public static boolean isInstalled() {
        if (OSInformation.isWindows()) {
            InitInstalledXmlTool.dealwithInstalledFile();
            return InitInstalledXmlTool.checkWindowsInstallFile();
        }
        if (!InitInstalledXmlTool.checkLinuxRDInstall()) {
            return InitInstalledXmlTool.checkLinuxLegoInstall();
        }
        return true;
    }

    public static void dealwithInstalledFile() {
        if (!OSInformation.isWindows()) {
            return;
        }
        String[] fileList = new String[]{LegoResourceManager.getProValue("install.params.installed.file"), LegoResourceManager.getProValue("install.params.license.file"), LegoResourceManager.getProValue("install.params.tmp.file"), "legoInstalled.xml"};
        String userPath = System.getProperty("user.home");
        for (String name : fileList) {
            File tmpFile = new File(userPath + File.separator + name);
            File destFile = new File(OSInformation.getUserHomePath() + File.separator + name);
            if (!tmpFile.exists() || destFile.exists()) continue;
            LOG.info((Object)String.format(Locale.ROOT, "Start move %s, result=%s", tmpFile.getName(), tmpFile.renameTo(destFile)));
            Singleton.getInstance().getMovedFileList().add(tmpFile.getName());
        }
    }

    private static void renamefile(String src, String dst) {
        File renameFile = new File(src);
        File destFile = new File(dst);
        renameFile.renameTo(destFile);
        Singleton.getInstance().setRenameInstallFile(true);
    }

    private static boolean checkRDContent(String path) {
        File file = new File(path);
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List list = document.selectNodes("/install/platform/jar");
            for (Node ptBundleEle : list) {
                if (!"DRM-Core-SDK-Bundle-0.0.1-SNAPSHOT.jar".equals(ptBundleEle.getText())) continue;
                return true;
            }
        }
        catch (DocumentException | SAXException e) {
            return false;
        }
        return false;
    }
}

