/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class JarFileUtil {
    private static final Log LOG = LogFactory.getInstance(JarFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editJar(String file, String entryName, String fileNameTow) throws IOException {
        FileInputStream inputStream = null;
        InputStream entryIn = null;
        JarOutputStream jarOutputStream = null;
        JarFile jf = null;
        FileOutputStream fos = null;
        File jarFile = new File(file);
        File targetFile = new File(fileNameTow);
        if (!jarFile.exists() || !targetFile.exists()) {
            LOG.error((Object)String.format(Locale.ROOT, "EditJar failed: %s or %s not exists.", jarFile.getName(), targetFile.getName()));
            return;
        }
        LOG.info((Object)String.format(Locale.ROOT, "Start to Edit Jar File: %s", jarFile.getName()), "0x000252000FB50033");
        try {
            inputStream = new FileInputStream(fileNameTow);
            byte[] data = JarFileUtil.getByte(inputStream);
            jf = new JarFile(file);
            TreeMap<String, byte[]> tm = new TreeMap<String, byte[]>();
            Enumeration<JarEntry> es = jf.entries();
            while (es.hasMoreElements()) {
                JarEntry je = es.nextElement();
                try {
                    entryIn = jf.getInputStream(je);
                    byte[] b = JarFileUtil.getByte(entryIn);
                    tm.put(je.getName(), b);
                }
                finally {
                    if (null == entryIn) continue;
                    entryIn.close();
                }
            }
            fos = new FileOutputStream(file);
            jarOutputStream = new JarOutputStream(fos);
            Set set = tm.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                JarFileUtil.dealJarOutPutStream(entryName, jarOutputStream, data, it);
            }
            jarOutputStream.flush();
            LOG.info((Object)"End to Edit Jar File.", "0x000252000FB50033");
        }
        catch (Throwable throwable) {
            JarFileUtil.releaseStream(jarOutputStream);
            JarFileUtil.releaseStream(inputStream);
            JarFileUtil.releaseStream(fos);
            JarFileUtil.releaseStream(jf);
            JarFileUtil.releaseStream(entryIn);
            throw throwable;
        }
        JarFileUtil.releaseStream(jarOutputStream);
        JarFileUtil.releaseStream(inputStream);
        JarFileUtil.releaseStream(fos);
        JarFileUtil.releaseStream(jf);
        JarFileUtil.releaseStream(entryIn);
    }

    private static void dealJarOutPutStream(String entryName, JarOutputStream jarOutputStream, byte[] data, Iterator it) throws IOException {
        Map.Entry me = (Map.Entry)it.next();
        String name = (String)me.getKey();
        JarEntry jeNew = new JarEntry(name);
        jarOutputStream.putNextEntry(jeNew);
        byte[] bytes = name.equals(entryName) ? data : (byte[])me.getValue();
        jarOutputStream.write(bytes, 0, bytes.length);
        jarOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileFromJar(String jarFile, String targetFile, String outFile) throws IOException {
        InputStream entryIn = null;
        JarFile jf = null;
        FileOutputStream fos = null;
        File jar = new File(jarFile);
        if (!jar.exists()) {
            LOG.error((Object)("the jar file is not exist: " + jar.getName()), "");
            return;
        }
        try {
            jf = new JarFile(jarFile);
            Enumeration<JarEntry> es = jf.entries();
            while (es.hasMoreElements()) {
                JarEntry je = es.nextElement();
                if (!je.getName().equals(targetFile)) continue;
                entryIn = jf.getInputStream(je);
                byte[] b = JarFileUtil.getByte(entryIn);
                fos = new FileOutputStream(outFile);
                fos.write(b, 0, b.length);
            }
        }
        finally {
            JarFileUtil.releaseStream(fos);
            JarFileUtil.releaseStream(jf);
            JarFileUtil.releaseStream(entryIn);
        }
    }

    private static void releaseStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                LOG.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }

    private static void releaseStream(JarFile stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                LOG.error((Object)"Release JarFile is Error:", e.getMessage());
            }
        }
    }

    public static byte[] getByte(InputStream s) throws IOException {
        int count;
        byte[] buffer = new byte[]{};
        byte[] chunk = new byte[15360];
        while ((count = s.read(chunk)) >= 0) {
            byte[] t = new byte[buffer.length + count];
            System.arraycopy(buffer, 0, t, 0, buffer.length);
            System.arraycopy(chunk, 0, t, buffer.length, count);
            buffer = t;
        }
        return buffer;
    }
}

