/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.dto.NetInterface;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NetWorkUtil {
    private static final Log LOG = LogFactory.getInstance(NetWorkUtil.class);
    private static final List<String> EXCEPTIONIP = new ArrayList<String>(Arrays.asList("255.255.255.255", "127.0.0.1", "0.0.0.0", "::1", "0:0:0:0:0:0:0:1"));

    public static List<NetInterface> getAllNetInterfaceInfo(boolean isFilterSubNet) {
        ArrayList<NetInterface> devList = new ArrayList<NetInterface>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                String ipAddress;
                InetAddress address;
                NetworkInterface nif = e.nextElement();
                StringBuilder sb = new StringBuilder();
                byte[] macAddress = nif.getHardwareAddress();
                if (null != macAddress) {
                    for (int i = 0; i < macAddress.length; ++i) {
                        sb.append(String.format(Locale.ROOT, "%02X%s", macAddress[i], i < macAddress.length - 1 ? "-" : ""));
                    }
                }
                ArrayList<String> subnetList = new ArrayList<String>();
                if (isFilterSubNet) {
                    Enumeration<NetworkInterface> subnet = nif.getSubInterfaces();
                    while (subnet.hasMoreElements()) {
                        NetworkInterface sub = subnet.nextElement();
                        for (InterfaceAddress inter : sub.getInterfaceAddresses()) {
                            address = inter.getAddress();
                            ipAddress = address.getHostAddress();
                            if (address instanceof Inet6Address) {
                                ipAddress = NetWorkUtil.getSimpleIPv6Addr(ipAddress);
                            }
                            subnetList.add(ipAddress);
                        }
                    }
                }
                List<InterfaceAddress> interfaceList = nif.getInterfaceAddresses();
                for (InterfaceAddress inter : interfaceList) {
                    NetInterface netFace = new NetInterface();
                    address = inter.getAddress();
                    ipAddress = address.getHostAddress();
                    if (address instanceof Inet6Address) {
                        ipAddress = NetWorkUtil.getSimpleIPv6Addr(ipAddress);
                    }
                    netFace.setDevName(nif.getDisplayName());
                    netFace.setIp(ipAddress);
                    netFace.setMac(sb.toString());
                    netFace.setNetmask(String.valueOf(inter.getNetworkPrefixLength()));
                    if (EXCEPTIONIP.contains(ipAddress) || subnetList.contains(ipAddress)) continue;
                    devList.add(netFace);
                }
            }
        }
        catch (SocketException e) {
            LOG.error((Object)("Get Local IP Error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return devList;
    }

    public static List<String> getLocalAllIps() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                Enumeration<InetAddress> l = nif.getInetAddresses();
                while (l.hasMoreElements()) {
                    InetAddress inetAddress = l.nextElement();
                    String ipAddress = inetAddress.getHostAddress();
                    if (inetAddress instanceof Inet6Address) {
                        ipAddress = NetWorkUtil.getSimpleIPv6Addr(ipAddress);
                    }
                    if (EXCEPTIONIP.contains(ipAddress)) continue;
                    ipList.add(ipAddress);
                }
            }
        }
        catch (SocketException e) {
            LOG.error((Object)("Get Local IP Error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        LOG.info((Object)String.format(Locale.ROOT, "Get all local ips: %s", ipList));
        return ipList;
    }

    public static Map<String, Short> getLocalAllIpAndMask() {
        HashMap<String, Short> ipMap = new HashMap<String, Short>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                List<InterfaceAddress> interfaceList = nif.getInterfaceAddresses();
                for (InterfaceAddress inter : interfaceList) {
                    String ip = inter.getAddress().getHostAddress();
                    if (inter.getAddress() instanceof Inet6Address) {
                        ip = NetWorkUtil.getSimpleIPv6Addr(ip);
                    }
                    if (EXCEPTIONIP.contains(ip)) continue;
                    ipMap.put(ip, inter.getNetworkPrefixLength());
                }
            }
        }
        catch (SocketException e) {
            LOG.error((Object)("GetLocalAllIpAndMask failed, " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        LOG.info((Object)String.format(Locale.ROOT, "GetLocalAllIpAndMask: %s", ipMap));
        return ipMap;
    }

    private static String getNormalIPv6(String ipv6) throws UnknownHostException {
        byte[] ret = new byte[16];
        ret[0] = 0;
        int ib = 15;
        if (ipv6.startsWith(":")) {
            ipv6 = ipv6.substring(1);
        }
        String[] groups = ipv6.split(":");
        for (int ig = groups.length - 1; ig > -1; --ig) {
            if ("".equals(groups[ig])) {
                int zlg = 9 - groups.length;
                while (zlg-- > 0) {
                    ret[ib--] = 0;
                    ret[ib--] = 0;
                }
                continue;
            }
            int temp = Integer.parseInt(groups[ig], 16);
            ret[ib--] = (byte)temp;
            ret[ib--] = (byte)(temp >> 8);
        }
        String ipv6New = InetAddress.getByAddress(ret).toString();
        return ipv6New.substring(ipv6New.indexOf(47) + 1).trim();
    }

    public static String getSimpleIPv6Addr(String ipaddr) {
        String ipAddr = ipaddr.toLowerCase(Locale.ROOT);
        if (VerifyUtil.isEmpty((String)ipAddr)) {
            throw new PatchException("getSimpleIPv6Addr failed, param is null.");
        }
        LOG.info((Object)String.format(Locale.ROOT, "Start get simple ipv6 address for %s", ipaddr));
        if (ipAddr.contains("%")) {
            ipAddr = ipAddr.substring(0, ipAddr.lastIndexOf("%"));
        }
        if (ipAddr.contains("::")) {
            String[] ipSpits = ipAddr.split(":");
            boolean isSimple = true;
            for (String ipSplt : ipSpits) {
                if (VerifyUtil.isEmpty((String)ipSplt) || !ipSplt.startsWith("0")) continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                return ipAddr;
            }
        }
        try {
            String ipv6New = NetWorkUtil.getNormalIPv6(ipAddr);
            String[] ipv6NormalArray = ipv6New.split(":");
            if (ipv6NormalArray.length == 8) {
                List<String> zeroList = NetWorkUtil.getZeroList(ipv6NormalArray);
                int zeroMax = 1;
                int zeroBegin = 0;
                for (String str : zeroList) {
                    int zeroCount = Integer.parseInt(str.split(";")[1]);
                    if (zeroCount <= zeroMax) continue;
                    zeroMax = zeroCount;
                    zeroBegin = Integer.parseInt(str.split(";")[0]);
                }
                String newIpv6 = NetWorkUtil.tryFormatIpv6(zeroBegin, zeroMax, ipv6NormalArray);
                if (ParamCheck.checkIPV6Address(newIpv6)) {
                    LOG.info((Object)String.format(Locale.ROOT, "Format successfully: ip=%s", newIpv6));
                    return newIpv6;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Get simple ipv6 failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return ipAddr;
    }

    private static String tryFormatIpv6(int zeroBegin, int zeroMax, String[] ipv6NormalArray) {
        StringBuffer formatIpv6 = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            if (i == zeroBegin || i == zeroBegin + zeroMax - 1) {
                formatIpv6.append(":");
                continue;
            }
            if (i >= zeroBegin && i <= zeroBegin + zeroMax - 1) continue;
            if (i == 7 || i == zeroBegin - 1) {
                formatIpv6.append(ipv6NormalArray[i]);
                continue;
            }
            formatIpv6.append(ipv6NormalArray[i] + ":");
        }
        return formatIpv6.toString();
    }

    private static List<String> getZeroList(String[] ipv6NormalArray) {
        ArrayList<String> zeroList = new ArrayList<String>();
        block0: for (int i = 0; i < 8; ++i) {
            if (!ipv6NormalArray[i].equals("0")) continue;
            int zeroNum = 1;
            for (int j = i + 1; j < 8; ++j) {
                if (ipv6NormalArray[j].equals("0")) {
                    if (j != 7 || ++zeroNum <= 1) continue;
                    zeroList.add(i + ";" + zeroNum);
                    continue;
                }
                if (zeroNum <= 1) continue block0;
                zeroList.add(i + ";" + zeroNum);
                continue block0;
            }
        }
        return zeroList;
    }
}

