/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.EOSType;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class OSInformation {
    private static String os = null;
    private static OSInformation instance = new OSInformation();
    private EOSType platform;

    private OSInformation() {
        String tempOs = System.getProperty("os.name");
        if (null != tempOs) {
            os = tempOs.toLowerCase(Locale.US);
        }
    }

    public static boolean isLinux() {
        return os.contains("linux");
    }

    public static boolean isWindows() {
        return os.contains("windows");
    }

    private static EOSType getOSname1() {
        OSInformation.instance.platform = OSInformation.isWindows() ? EOSType.WINDOWS : EOSType.OTHERS;
        return OSInformation.instance.platform;
    }

    public static EOSType getOSname() {
        if (!OSInformation.isLinux()) {
            return OSInformation.getOSname1();
        }
        OSInformation.instance.platform = EOSType.LINUX;
        return OSInformation.instance.platform;
    }

    public static EOSType getOSnameCLI() {
        OSInformation.instance.platform = OSInformation.isLinux() ? EOSType.LINUX : (OSInformation.isWindows() ? EOSType.WINDOWS : EOSType.OTHERS);
        return OSInformation.instance.platform;
    }

    private static String getLinuxUserHomePath() {
        String homePath = "";
        String deployFile = InstallConstant.getsBasePath() + LegoResourceManager.getProValue("start.user.info.file");
        File file = new File(deployFile);
        if (file.exists()) {
            homePath = LegoResourceManager.getProValue("custom.user.name");
        }
        homePath = "".equals(homePath) ? "/root" : "/home/" + homePath;
        return homePath;
    }

    public static String getCurrentUserHomePaht() {
        try {
            File path = new File(System.getProperty("user.home"));
            if (OSInformation.isWindows()) {
                String parPath = path.getParent();
                if (VerifyUtil.isEmpty((String)parPath) || !new File(parPath).exists()) {
                    throw new PatchException("user path not found.");
                }
                String destPath = parPath + File.separator + "bcmpath";
                File tmpPath = new File(destPath);
                if (!tmpPath.exists()) {
                    tmpPath.mkdir();
                }
                return destPath;
            }
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            throw new PatchException("user path not found.");
        }
    }

    public static String getUserHomePath() {
        if (OSInformation.isLinux()) {
            return OSInformation.getLinuxUserHomePath();
        }
        if (OSInformation.isWindows()) {
            return OSInformation.getCurrentUserHomePaht();
        }
        return OSInformation.getLinuxUserHomePath();
    }

    public static String getInstalledFile() {
        return OSInformation.getUserHomePath() + File.separator + LegoResourceManager.getProValue("install.params.installed.file");
    }
}

